/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.model.Params;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;

public class SemImInitializationParams
implements Params,
TetradSerializable {
    static final long serialVersionUID = 23L;
    private boolean retainPreviousValues = false;
    private double coefLow = 0.5;
    private double coefHigh = 1.5;
    private double covLow = 0.2;
    private double covHigh = 0.3;
    private double varLow = 1.0;
    private double varHigh = 3.0;
    private boolean coefSymmetric = true;
    private boolean covSymmetric = true;

    public static SemImInitializationParams serializableInstance() {
        return new SemImInitializationParams();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    public double getCoefLow() {
        return this.coefLow;
    }

    public void setCoefRange(double coefLow, double coefHigh) {
        if (coefLow < 0.0) {
            throw new IllegalArgumentException("Coef low must be >= 0.");
        }
        if (coefLow > coefHigh) {
            throw new IllegalArgumentException("Coef low must be < coef high.");
        }
        this.coefLow = coefLow;
        this.coefHigh = coefHigh;
    }

    public double getCoefHigh() {
        return this.coefHigh;
    }

    public double getCovLow() {
        return this.covLow;
    }

    public void setCovRange(double covLow, double covHigh) {
        if (covLow < 0.0) {
            throw new IllegalArgumentException("Cov low must be >= 0.");
        }
        if (covLow > covHigh) {
            throw new IllegalArgumentException("Cov low must be < cov high.");
        }
        this.covLow = covLow;
        this.covHigh = covHigh;
    }

    public double getCovHigh() {
        return this.covHigh;
    }

    public double getVarLow() {
        return this.varLow;
    }

    public void setVarRange(double varLow, double varHigh) {
        if (varLow < 0.0) {
            throw new IllegalArgumentException("Var low must be >= 0.");
        }
        if (varLow > varHigh) {
            throw new IllegalArgumentException("Var low must be < var high.");
        }
        this.varLow = varLow;
        this.varHigh = varHigh;
    }

    public double getVarHigh() {
        return this.varHigh;
    }

    public boolean isCoefSymmetric() {
        return this.coefSymmetric;
    }

    public void setCoefSymmetric(boolean coefSymmetric) {
        this.coefSymmetric = coefSymmetric;
    }

    public boolean isCovSymmetric() {
        return this.covSymmetric;
    }

    public void setCovSymmetric(boolean covSymmetric) {
        this.covSymmetric = covSymmetric;
    }

    public boolean isRetainPreviousValues() {
        return this.retainPreviousValues;
    }

    public void setRetainPreviousValues(boolean retainPreviousValues) {
        this.retainPreviousValues = retainPreviousValues;
    }
}

