/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public final class SemManipulation
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private SemIm semIm;
    private boolean[] manipulated;

    public SemManipulation(SemIm semIm) {
        if (semIm == null) {
            throw new NullPointerException();
        }
        this.semIm = semIm;
        this.manipulated = new boolean[semIm.getVariableNodes().size()];
    }

    public SemManipulation(SemManipulation evidence) {
        if (evidence == null) {
            throw new NullPointerException();
        }
        this.semIm = evidence.getSemIm();
        this.manipulated = new boolean[this.semIm.getVariableNodes().size()];
        for (int i = 0; i < this.manipulated.length; ++i) {
            this.manipulated[i] = evidence.isManipulated(i);
        }
    }

    public SemManipulation(SemManipulation evidence, SemIm semIm) {
        if (semIm == null) {
            throw new NullPointerException();
        }
        if (evidence == null) {
            throw new NullPointerException();
        }
        this.semIm = semIm;
        this.manipulated = new boolean[semIm.getVariableNodes().size()];
        for (int i = 0; i < this.manipulated.length; ++i) {
            this.manipulated[i] = evidence.isManipulated(i);
        }
    }

    public static SemManipulation serializableInstance() {
        return new SemManipulation(SemIm.serializableInstance());
    }

    public SemIm getSemIm() {
        return this.semIm;
    }

    public int getNodeIndex(String nodeName) {
        List<Node> nodes = this.semIm.getSemPm().getVariableNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (!node.getName().equals(nodeName)) continue;
            return i;
        }
        return -1;
    }

    public int getNumNodes() {
        return this.semIm.getVariableNodes().size();
    }

    public Node getNode(int nodeIndex) {
        return this.semIm.getVariableNodes().get(nodeIndex);
    }

    public boolean isManipulated(int nodeIndex) {
        return this.manipulated[nodeIndex];
    }

    public void setManipulated(int nodeIndex, boolean manipulated) {
        this.manipulated[nodeIndex] = manipulated;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\nManipulation:");
        buf.append("\n");
        for (int i = 0; i < this.getNumNodes(); ++i) {
            buf.append(this.isManipulated(i) ? "(Man)" : "     ");
            buf.append("\t");
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        SemManipulation evidence = (SemManipulation)o;
        if (this.semIm != evidence.semIm) {
            return false;
        }
        for (int i = 0; i < this.manipulated.length; ++i) {
            if (this.manipulated[i] == evidence.manipulated[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 37;
        hashCode = 19 * hashCode + this.semIm.hashCode();
        hashCode = 19 * hashCode + this.manipulated.hashCode();
        return hashCode;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }
}

