/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemOptimizer;
import edu.cmu.tetrad.sem.SemOptimizerEm;
import edu.cmu.tetrad.util.TetradLogger;
import pal.math.ConjugateDirectionSearch;
import pal.math.MultivariateFunction;

public class SemOptimizerPalCds
implements SemOptimizer {
    static final long serialVersionUID = 23L;
    private static final double FUNC_TOLERANCE = 1.0E-4;
    private static final double PARAM_TOLERANCE = 0.001;

    public static SemOptimizerPalCds serializableInstance() {
        return new SemOptimizerPalCds();
    }

    @Override
    public void optimize(SemIm semIm) {
        new SemOptimizerEm().optimize(semIm);
        ConjugateDirectionSearch search = new ConjugateDirectionSearch();
        search.step = 10.0;
        search.optimize(this.fittingFunction(semIm), semIm.getFreeParamValues(), 1.0E-4, 0.001);
    }

    private PalFittingFunction fittingFunction(SemIm sem) {
        return new PalFittingFunction(sem);
    }

    static class PalFittingFunction
    implements MultivariateFunction {
        private final SemIm sem;

        public PalFittingFunction(SemIm sem) {
            this.sem = sem;
        }

        @Override
        public double evaluate(double[] argument) {
            for (int i = 0; i < argument.length; ++i) {
                if (!Double.isNaN(argument[i])) continue;
                throw new IllegalArgumentException("Attempt to set parameter value to NaN.");
            }
            this.sem.setFreeParamValues(argument);
            double fml = this.sem.getFml();
            TetradLogger.getInstance().log("optimization", "FML = " + fml);
            if (Double.isNaN(fml)) {
                return 10000.0;
            }
            return fml;
        }

        @Override
        public int getNumArguments() {
            return this.sem.getNumFreeParams();
        }

        @Override
        public double getLowerBound(int n) {
            Parameter param = this.sem.getFreeParameters().get(n);
            return param.getType() == ParamType.COEF || param.getType() == ParamType.COVAR ? -10000.0 : 1.0E-4;
        }

        @Override
        public double getUpperBound(int n) {
            return 10000.0;
        }
    }
}

