/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public final class SemProposition
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private SemIm semIm;
    private double[] values;

    private SemProposition(SemIm semIm) {
        if (semIm == null) {
            throw new NullPointerException();
        }
        this.semIm = semIm;
        this.values = new double[semIm.getVariableNodes().size()];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = Double.NaN;
        }
    }

    public static SemProposition tautology(SemIm semIm) {
        return new SemProposition(semIm);
    }

    public SemProposition(SemIm semIm, SemProposition proposition) {
        this(semIm);
        if (proposition == null) {
            throw new NullPointerException();
        }
    }

    public SemProposition(SemProposition proposition) {
        this.semIm = proposition.semIm;
        this.values = new double[proposition.values.length];
        System.arraycopy(proposition.values, 0, this.values, 0, this.values.length);
    }

    public static SemProposition serializableInstance() {
        return new SemProposition(SemIm.serializableInstance());
    }

    public SemIm getSemIm() {
        return this.semIm;
    }

    public int getNumVariables() {
        return this.values.length;
    }

    public int getNodeIndex(String name) {
        return -1;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        SemProposition proposition = (SemProposition)o;
        if (this.semIm != proposition.semIm) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (Double.isNaN(this.values[i]) && Double.isNaN(proposition.values[i]) || this.values[i] == proposition.values[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 37;
        hashCode = 19 * hashCode + this.semIm.hashCode();
        hashCode = 19 * hashCode + this.values.hashCode();
        return hashCode;
    }

    public String toString() {
        List<Node> nodes = this.semIm.getVariableNodes();
        StringBuilder buf = new StringBuilder();
        buf.append("\nProposition: ");
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            buf.append("\n").append(node).append(" = ").append(this.values[i]);
        }
        return buf.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    public double getValue(int i) {
        return this.values[i];
    }

    public void setValue(int i, double value) {
        this.values[i] = value;
    }

    public double getValue(Node node) {
        List<Node> nodes = this.semIm.getVariableNodes();
        return this.values[nodes.indexOf(node)];
    }

    public void setValue(Node node, double value) {
        List<Node> nodes = this.semIm.getVariableNodes();
        this.values[nodes.indexOf((Object)node)] = value;
    }
}

