/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.GeneralizedSemPm;
import edu.cmu.tetradapp.model.calculator.parser.ExpressionParser;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateExpander {
    private static TemplateExpander INSTANCE = new TemplateExpander();

    private TemplateExpander() {
    }

    public static TemplateExpander getInstance() {
        return INSTANCE;
    }

    public String expandTemplate(String template, GeneralizedSemPm semPm, Node node) throws ParseException {
        ExpressionParser parser = new ExpressionParser();
        if (semPm == null && template.contains("$")) {
            throw new IllegalArgumentException("If semPm is null, the template may not contain any parameters or $ expressions.");
        }
        if (semPm == null && node != null) {
            throw new IllegalArgumentException("If semPm is not specified, then node may not be specified either. The node must be for a specific generalized SEM PM.");
        }
        parser.parseExpression(template);
        List<String> usedNames = parser.getParameters();
        template = this.replaceTemplateSums(semPm, template, node);
        template = this.replaceTemplateProducts(semPm, template, node);
        template = this.replaceNewParameters(semPm, template, usedNames);
        Node error = null;
        if (node != null) {
            error = semPm.getErrorNode(node);
        }
        if ((template = template.trim()).equals("")) {
            template = "";
        }
        if (!"".equals(template)) {
            parser.parseExpression(template);
            if (node == null && !parser.getParameters().isEmpty()) {
                throw new IllegalArgumentException("If node is null, the template may not contain any $ expressions.");
            }
        }
        if (node != null && node != error && !template.contains(error.getName())) {
            template = template.trim().equals("") ? error.getName() : template + " + " + error.getName();
        }
        if (template.contains("$")) {
            throw new ParseException("Template contains a $ not inside TSUM or TPROD.", template.indexOf("$"));
        }
        return template;
    }

    private String replaceTemplateSums(GeneralizedSemPm semPm, String formula, Node node) throws ParseException {
        return this.replaceLists("TSUM", semPm, formula, node);
    }

    private String replaceTemplateProducts(GeneralizedSemPm semPm, String formula, Node node) throws ParseException {
        return this.replaceLists("TPROD", semPm, formula, node);
    }

    private String replaceLists(String operator, GeneralizedSemPm semPm, String formula, Node node) throws ParseException {
        Matcher m;
        ArrayList<String> templateOperators = new ArrayList<String>();
        templateOperators.add("TSUM");
        templateOperators.add("TPROD");
        Pattern p = Pattern.compile(Pattern.quote(operator));
        while ((m = p.matcher(formula)).find()) {
            int pos;
            int numLeft = 0;
            int numRight = 0;
            for (pos = m.end(); pos < formula.length(); ++pos) {
                char c = formula.charAt(pos);
                if (c == '(') {
                    ++numLeft;
                } else if (c == ')') {
                    ++numRight;
                }
                if (numLeft == numRight) break;
            }
            String target = formula.substring(m.end() + 1, pos);
            for (String _operator : templateOperators) {
                if (operator.equals(_operator) || !target.contains(_operator)) continue;
                throw new ParseException("Template operators may not be nested.", m.end() + target.indexOf(_operator));
            }
            List<Object> parents = new ArrayList();
            if (semPm != null && node != null) {
                parents = semPm.getParents(node);
            }
            StringBuilder buf = new StringBuilder();
            for (int j = 0; j < parents.size(); ++j) {
                Node parent = (Node)parents.get(j);
                if (!semPm.getVariableNodes().contains(parent)) continue;
                String copy = target;
                copy = copy.replaceAll("\\$", parent.getName());
                buf.append(copy);
                if (j >= parents.size() - 2) continue;
                if (operator.equals("TSUM")) {
                    buf.append(" + ");
                    continue;
                }
                if (!operator.equals("TPROD")) continue;
                buf.append(" * ");
            }
            String toReplace = formula.substring(m.start(), pos + 1);
            toReplace = Pattern.quote(toReplace);
            String replacement = buf.toString();
            formula = formula.replaceFirst(toReplace, replacement);
        }
        formula = this.removeOperatorStrings(formula);
        formula = formula.trim();
        if (formula.startsWith("+")) {
            formula = formula.substring(1, formula.length());
            formula = formula.trim();
        }
        if (formula.startsWith("*")) {
            formula = formula.substring(1, formula.length());
            formula = formula.trim();
        }
        return formula;
    }

    private String removeOperatorStrings(String formula) {
        boolean found = true;
        block0: while (found) {
            int last;
            found = false;
            ArrayList<Character> operatorList = new ArrayList<Character>();
            int first = 0;
            for (int i = last = 0; i < formula.length(); ++i) {
                boolean space;
                char symbol = formula.charAt(i);
                boolean plusOrTimes = '+' == symbol || '*' == symbol;
                boolean bl = space = ' ' == symbol;
                if (space) continue;
                if (plusOrTimes) {
                    if (operatorList.isEmpty()) {
                        first = i;
                    }
                    operatorList.add(Character.valueOf(symbol));
                    continue;
                }
                last = i - 1;
                if (operatorList.size() > 1) {
                    found = true;
                    boolean allStar = true;
                    for (Character c : operatorList) {
                        if (c.charValue() == '*') continue;
                        allStar = false;
                        break;
                    }
                    formula = allStar ? formula.substring(0, first - 1) + " * " + formula.substring(last + 1, formula.length()) : formula.substring(0, first - 1) + " + " + formula.substring(last + 1, formula.length());
                }
                operatorList.clear();
                continue block0;
            }
        }
        return formula;
    }

    private String replaceNewParameters(GeneralizedSemPm semPm, String formula, List<String> usedNames) {
        Matcher m;
        String parameterPattern = "\\$|(([a-zA-Z]{1})([a-zA-Z0-9-_/]*))";
        Pattern p = Pattern.compile("NEW\\((" + parameterPattern + ")\\)");
        while ((m = p.matcher(formula)).find()) {
            String group0 = Pattern.quote(m.group(0));
            String group1 = m.group(1);
            String nextName = semPm.nextParameterName(group1, usedNames);
            formula = formula.replaceFirst(group0, nextName);
            usedNames.add(nextName);
        }
        return formula;
    }
}

