/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemOptimizer;
import edu.cmu.tetrad.sem.SemOptimizerNrPowell;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.sem.SemStdErrorEstimator;
import edu.cmu.tetrad.util.MatrixUtils;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSemEstimator
extends TestCase {
    public TestSemEstimator(String name) {
        super(name);
    }

    public static void rtestSet0() {
        System.out.println("\n\nTest Set 0.");
        Graph graph = TestSemEstimator.constructGraph0();
        SemPm semPm = new SemPm(graph);
        CovarianceMatrix covMatrix = TestSemEstimator.constructCovMatrix0();
        SemEstimator estimator = new SemEstimator(covMatrix, semPm, (SemOptimizer)new SemOptimizerNrPowell());
        System.out.println();
        System.out.println("... Before:");
        System.out.println(estimator);
        estimator.estimate();
        System.out.println();
        System.out.println("... After:");
        System.out.println(estimator);
        System.out.println("\n Parameters in order");
        SemIm estSem = estimator.getEstimatedSem();
        SemStdErrorEstimator stdErrEst = new SemStdErrorEstimator();
        stdErrEst.computeStdErrors(estSem);
        double[] params = estSem.getFreeParamValues();
        List<Parameter> parameters = estSem.getFreeParameters();
        double[] stdErrs = stdErrEst.getStdErrors();
        for (int i = 0; i < params.length; ++i) {
            Parameter p = parameters.get(i);
            System.out.println(" " + p.getName() + " " + p.getType() + " " + p.getNodeA() + " " + p.getNodeB());
            System.out.print("Value of parameter " + i + " " + params[i]);
            System.out.print(" Value of Std Err " + stdErrs[i] + "\n\n");
        }
    }

    public void testSet1() {
        System.out.println("\n\nTest Set 1.");
        Graph graph = this.constructGraph1();
        SemPm semPm = new SemPm(graph);
        CovarianceMatrix covMatrix = this.constructCovMatrix1();
        SemEstimator estimator = new SemEstimator(covMatrix, semPm);
        System.out.println();
        System.out.println("... Before:");
        System.out.println(estimator);
        estimator.estimate();
        System.out.println();
        System.out.println("... After:");
        System.out.println(estimator);
    }

    public void testSet2() {
        System.out.println("\n\nTest Set 2.");
        Graph graph = this.constructGraph2();
        SemPm semPm = new SemPm(graph);
        CovarianceMatrix covMatrix = this.constructCovMatrix2();
        SemEstimator estimator = new SemEstimator(covMatrix, semPm);
        System.out.println();
        System.out.println("... Before:");
        System.out.println(estimator);
        estimator.estimate();
        System.out.println();
        System.out.println("... After:");
        System.out.println(estimator);
    }

    public void testSet3() {
        System.out.println("\n\nTest Set 3.");
        Graph graph = this.constructGraph2();
        SemPm semPm = new SemPm(graph);
        CovarianceMatrix covMatrix = this.constructCovMatrix2();
        SemEstimator estimator = new SemEstimator(covMatrix, semPm);
        System.out.println();
        System.out.println("... Before:");
        System.out.println(estimator);
        estimator.estimate();
        System.out.println();
        System.out.println("... After:");
        System.out.println(estimator);
    }

    public static Test suite() {
        return new TestSuite(TestSemEstimator.class);
    }

    private static Graph constructGraph0() {
        EdgeListGraph graph = new EdgeListGraph();
        GraphNode x1 = new GraphNode("empcur");
        GraphNode x2 = new GraphNode("self-eff");
        GraphNode x3 = new GraphNode("depressed");
        GraphNode x4 = new GraphNode("dadchild");
        GraphNode x5 = new GraphNode("dadmom");
        GraphNode x6 = new GraphNode("home");
        GraphNode x7 = new GraphNode("negbeh");
        GraphNode x8 = new GraphNode("coglang");
        graph.addNode(x1);
        graph.addNode(x2);
        graph.addNode(x3);
        graph.addNode(x4);
        graph.addNode(x5);
        graph.addNode(x6);
        graph.addNode(x7);
        graph.addNode(x8);
        graph.addDirectedEdge(x1, x2);
        graph.addDirectedEdge(x2, x3);
        graph.addDirectedEdge(x3, x5);
        graph.addDirectedEdge(x3, x6);
        graph.addDirectedEdge(x5, x4);
        graph.addDirectedEdge(x4, x6);
        graph.addDirectedEdge(x6, x7);
        graph.addDirectedEdge(x6, x8);
        return graph;
    }

    private static CovarianceMatrix constructCovMatrix0() {
        String[] vars = new String[]{"empcur", "self-eff", "depressed", "dadchild", "dadmom", "home", "negbeh", "coglang"};
        double[][] arr = new double[][]{{1.0}, {0.215, 1.0}, {-0.164, -0.472, 1.0}, {0.112, 0.079, -0.157, 1.0}, {0.034, 0.121, -0.184, 0.407, 1.0}, {0.101, 0.197, -0.19, 0.176, 0.12, 1.0}, {0.071, -0.172, 0.206, -0.049, -0.084, -0.291, 1.0}, {0.043, -0.038, -0.037, -0.062, 0.028, 0.166, -0.149, 1.0}};
        return new CovarianceMatrix(DataUtils.createContinuousVariables(vars), new DenseDoubleMatrix2D(arr), 173);
    }

    private Graph constructGraph1() {
        EdgeListGraph graph = new EdgeListGraph();
        GraphNode x1 = new GraphNode("X1");
        GraphNode x2 = new GraphNode("X2");
        GraphNode x3 = new GraphNode("X3");
        GraphNode x4 = new GraphNode("X4");
        GraphNode x5 = new GraphNode("X5");
        graph.addNode(x1);
        graph.addNode(x2);
        graph.addNode(x3);
        graph.addNode(x4);
        graph.addNode(x5);
        graph.addDirectedEdge(x1, x2);
        graph.addDirectedEdge(x2, x3);
        graph.addDirectedEdge(x3, x4);
        graph.addDirectedEdge(x1, x4);
        graph.addDirectedEdge(x4, x5);
        return graph;
    }

    private CovarianceMatrix constructCovMatrix1() {
        String[] vars = new String[]{"X1", "X2", "X3", "X4", "X5"};
        double[][] arr = new double[][]{{1.04408}, {0.80915, 1.55607}, {0.89296, 1.67375, 2.87584}, {2.23792, 2.68536, 3.94996, 7.78259}, {1.17516, 1.36337, 1.99039, 4.04533, 3.14922}};
        double[][] m = MatrixUtils.convertLowerTriangleToSymmetric(arr);
        DenseDoubleMatrix2D m2 = new DenseDoubleMatrix2D(m);
        return new CovarianceMatrix(DataUtils.createContinuousVariables(vars), m2, 1000);
    }

    private Graph constructGraph2() {
        EdgeListGraph graph = new EdgeListGraph();
        GraphNode x1 = new GraphNode("X1");
        GraphNode x2 = new GraphNode("X2");
        GraphNode x3 = new GraphNode("X3");
        GraphNode x4 = new GraphNode("X4");
        GraphNode x5 = new GraphNode("X5");
        GraphNode x6 = new GraphNode("X6");
        graph.addNode(x1);
        graph.addNode(x2);
        graph.addNode(x3);
        graph.addNode(x4);
        graph.addNode(x5);
        graph.addNode(x6);
        graph.addDirectedEdge(x1, x2);
        graph.addDirectedEdge(x1, x5);
        graph.addDirectedEdge(x2, x5);
        graph.addDirectedEdge(x2, x3);
        graph.addDirectedEdge(x4, x5);
        graph.addDirectedEdge(x4, x6);
        return graph;
    }

    private CovarianceMatrix constructCovMatrix2() {
        String[] vars = new String[]{"X1", "X2", "X3", "X4", "X5", "X6"};
        double[][] arr = new double[][]{{0.915736}, {0.636415, 1.446795}, {0.596983, 1.289278, 2.202219}, {-0.004218, -0.012488, 0.017168, 0.979152}, {2.106086, 2.864279, 2.696651, 1.334353, 9.705821}, {0.029125, -0.027681, -0.043718, 0.679363, 0.886868, 1.495396}};
        double[][] m = MatrixUtils.convertLowerTriangleToSymmetric(arr);
        return new CovarianceMatrix(DataUtils.createContinuousVariables(vars), new DenseDoubleMatrix2D(m), 1000);
    }
}

