/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.sem.SemProposition;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSemProposition
extends TestCase {
    public TestSemProposition(String name) {
        super(name);
    }

    public void testEvidence() {
        Graph graph = this.constructGraph1();
        SemPm semPm = new SemPm(graph);
        SemIm semIm = new SemIm(semPm);
        List<Node> nodes = semIm.getVariableNodes();
        SemProposition proposition = SemProposition.tautology(semIm);
        System.out.println(proposition);
        for (int i = 0; i < semIm.getVariableNodes().size(); ++i) {
            TestSemProposition.assertTrue(Double.isNaN(proposition.getValue(i)));
        }
        proposition.setValue(1, 0.5);
        TestSemProposition.assertEquals(0.5, proposition.getValue(1), 0.0);
        System.out.println(proposition);
        Node node4 = nodes.get(3);
        proposition.setValue(node4, 0.7);
        TestSemProposition.assertEquals(0.7, proposition.getValue(node4), 0.0);
        System.out.println(proposition);
    }

    public static Test suite() {
        return new TestSuite(TestSemProposition.class);
    }

    private Graph constructGraph1() {
        EdgeListGraph graph = new EdgeListGraph();
        GraphNode x1 = new GraphNode("X1");
        GraphNode x2 = new GraphNode("X2");
        GraphNode x3 = new GraphNode("X3");
        GraphNode x4 = new GraphNode("X4");
        GraphNode x5 = new GraphNode("X5");
        graph.addNode(x1);
        graph.addNode(x2);
        graph.addNode(x3);
        graph.addNode(x4);
        graph.addNode(x5);
        graph.addDirectedEdge(x1, x2);
        graph.addDirectedEdge(x2, x3);
        graph.addDirectedEdge(x3, x4);
        graph.addDirectedEdge(x1, x4);
        graph.addDirectedEdge(x4, x5);
        return graph;
    }
}

