/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.session;

import edu.cmu.tetrad.model.Params;
import edu.cmu.tetrad.session.CouldNotCreateModelException;
import edu.cmu.tetrad.session.Executable;
import edu.cmu.tetrad.session.ExecutionRestarter;
import edu.cmu.tetrad.session.ParamsResettable;
import edu.cmu.tetrad.session.SessionAdapter;
import edu.cmu.tetrad.session.SessionEvent;
import edu.cmu.tetrad.session.SessionListener;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.session.SessionSupport;
import edu.cmu.tetrad.session.Type1;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.TetradLoggerConfig;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetrad.util.Unmarshallable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SessionNode
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private String boxType;
    private String displayName;
    private Class[] modelClasses;
    private Class lastModelClass;
    private Class[] modelParamTypes;
    private SessionModel model;
    private SessionModel oldModel;
    private transient SessionModel savedModel;
    private Map<Class, Params> paramMap = new HashMap<Class, Params>();
    private Set<SessionNode> parents = new HashSet<SessionNode>();
    private Set<SessionNode> children = new HashSet<SessionNode>();
    private boolean nextEdgeAddAllowed = true;
    private int repetition = 1;
    private transient SessionSupport sessionSupport;
    private transient SessionHandler sessionHandler;
    private TetradLoggerConfig loggerConfig = null;

    public SessionNode(Class modelClass) {
        this("???", modelClass.getName(), new Class[]{modelClass});
    }

    public SessionNode(String boxType, String displayName, Class modelClass) {
        this(boxType, displayName, new Class[]{modelClass});
    }

    public SessionNode(Class[] modelClasses) {
        this("???", "???", modelClasses);
    }

    public SessionNode(String boxType, String displayName, Class[] modelClasses) {
        this.setBoxType(boxType);
        this.setDisplayName(displayName);
        if (modelClasses == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < modelClasses.length; ++i) {
            if (modelClasses[i] == null) {
                throw new NullPointerException("Model class null: index + " + i);
            }
            if (SessionModel.class.isAssignableFrom(modelClasses[i])) continue;
            throw new ClassCastException("Model class must implement SessionModel: " + modelClasses[i]);
        }
        this.boxType = boxType;
        this.displayName = displayName;
        this.modelClasses = modelClasses;
    }

    public static SessionNode serializableInstance() {
        return new SessionNode(Type1.class);
    }

    public boolean addParent(SessionNode parent) {
        if (this.parents.contains(parent)) {
            return false;
        }
        if (parent == this) {
            return false;
        }
        ArrayList<SessionNode> newParents = new ArrayList<SessionNode>(this.parents);
        newParents.add(parent);
        for (Class modelClass : this.modelClasses) {
            Class[][] parentClasses = new Class[newParents.size()][];
            int[] numModels = new int[newParents.size()];
            for (int j = 0; j < newParents.size(); ++j) {
                SessionNode node = (SessionNode)newParents.get(j);
                parentClasses[j] = node.getModelClasses();
                numModels[j] = parentClasses[j].length;
            }
            if (!this.isConsistentModelClass(modelClass, parentClasses)) continue;
            if (this.getModel() == null) {
                this.parents.add(parent);
                parent.addChild(this);
                parent.addSessionListener(this.getSessionHandler());
                this.getSessionSupport().fireParentAdded(parent, this);
                return true;
            }
            this.parents.add(parent);
            parent.addChild(this);
            parent.addSessionListener(this.getSessionHandler());
            this.getSessionSupport().fireParentAdded(parent, this);
            return true;
        }
        return false;
    }

    public boolean addParent2(SessionNode parent) {
        if (this.parents.contains(parent)) {
            return false;
        }
        if (parent == this) {
            return false;
        }
        ArrayList<SessionNode> newParents = new ArrayList<SessionNode>(this.parents);
        newParents.add(parent);
        for (Class modelClass : this.modelClasses) {
            Class[][] parentClasses = new Class[newParents.size()][];
            int[] numModels = new int[newParents.size()];
            for (int j = 0; j < newParents.size(); ++j) {
                SessionNode node = (SessionNode)newParents.get(j);
                parentClasses[j] = node.getModelClasses();
                numModels[j] = parentClasses[j].length;
            }
            if (!this.isConsistentModelClass(modelClass, parentClasses)) continue;
            if (this.getModel() == null) {
                this.parents.add(parent);
                parent.addChild(this);
                parent.addSessionListener(this.getSessionHandler());
                this.getSessionSupport().fireParentAdded(parent, this);
                return true;
            }
            this.sessionSupport.fireAddingEdge();
            if (this.isNextEdgeAddAllowed()) {
                this.setNextEdgeAddAllowed(true);
                this.parents.add(parent);
                parent.addChild(this);
                parent.addSessionListener(this.getSessionHandler());
                this.getSessionSupport().fireParentAdded(parent, this);
                this.destroyModel();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeParent(SessionNode parent) {
        if (this.parents.contains(parent)) {
            this.parents.remove(parent);
            parent.removeChild(this);
            parent.removeSessionListener(this.getSessionHandler());
            this.getSessionSupport().fireParentRemoved(parent, this);
            return true;
        }
        return false;
    }

    public Set<SessionNode> getParents() {
        return new HashSet<SessionNode>(this.parents);
    }

    public int getNumParents() {
        return this.parents.size();
    }

    public boolean addChild(SessionNode child) {
        if (!this.children.contains(child)) {
            child.addParent(this);
            if (child.containsParent(this)) {
                this.children.add(child);
                return true;
            }
        }
        return false;
    }

    public boolean containsChild(SessionNode child) {
        return this.children.contains(child);
    }

    public boolean removeChild(SessionNode child) {
        if (this.children.contains(child)) {
            child.removeParent(this);
            if (!child.containsParent(this)) {
                this.children.remove(child);
                return true;
            }
        }
        return false;
    }

    public Set<SessionNode> getChildren() {
        return new HashSet<SessionNode>(this.children);
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public boolean createModel(boolean simulation) {
        if (this.getModel() == null) {
            if (this.lastModelClass != null) {
                try {
                    this.createModel(this.lastModelClass, simulation);
                }
                catch (Exception e) {
                    this.getSessionSupport().fireModelUnclear(this);
                }
            } else {
                this.getSessionSupport().fireModelUnclear(this);
            }
        }
        return this.getModel() != null;
    }

    public void createModel(Class modelClass, boolean simulation) throws Exception {
        ArrayList<Object> expandedModels;
        if (!Arrays.asList(this.modelClasses).contains(modelClass)) {
            throw new IllegalArgumentException("Class not among possible model classes: " + modelClass);
        }
        this.loggerConfig = this.getLoggerConfig(modelClass);
        TetradLogger.getInstance().setTetradLoggerConfig(this.loggerConfig);
        TetradLogger.getInstance().log("info", "\n========LOGGING " + this.getDisplayName() + "\n");
        List<Object> parentModels = this.listParentModels();
        Params param = this.getParam(modelClass);
        if (this.model == null) {
            expandedModels = new ArrayList<Object>(parentModels);
            if (this.oldModel != null) {
                expandedModels.add(this.oldModel);
            }
            if (param != null) {
                expandedModels.add(param);
            }
            this.createModelUsingArguments(modelClass, expandedModels);
        }
        if (this.model == null) {
            expandedModels = new ArrayList<Object>(parentModels);
            if (param != null) {
                expandedModels.add(param);
            }
            this.createModelUsingArguments(modelClass, expandedModels);
        }
        if (this.model == null) {
            this.createModelUsingArguments(modelClass, parentModels);
        }
        if (this.model == null) {
            TetradLogger.getInstance().log("info", this.getDisplayName() + " was not created.");
            throw new CouldNotCreateModelException(modelClass);
        }
        if (this.model instanceof Executable) {
            Executable executable = (Executable)((Object)this.model);
            executable.execute();
        }
    }

    public TetradLoggerConfig getLoggerConfig() {
        return this.loggerConfig;
    }

    public TetradLoggerConfig getLoggerConfig(Class modelClass) {
        TetradLoggerConfig oldConfig = this.loggerConfig;
        TetradLoggerConfig newConfig = TetradLogger.getInstance().getLoggerForClass(modelClass);
        if (oldConfig != null && newConfig == null) {
            return oldConfig;
        }
        if (oldConfig != null && newConfig != null) {
            for (TetradLoggerConfig.Event event : newConfig.getSupportedEvents()) {
                for (TetradLoggerConfig.Event _event : oldConfig.getSupportedEvents()) {
                    if (!event.getId().equals(_event.getId())) continue;
                    newConfig.setEventActive(_event.getId(), oldConfig.isEventActive(_event.getId()));
                }
            }
        }
        this.loggerConfig = newConfig;
        return newConfig;
    }

    public void destroyModel() {
        if (this.model != null) {
            this.oldModel = this.model;
            this.model = null;
        }
        this.modelParamTypes = null;
        this.getSessionSupport().fireModelDestroyed(this);
    }

    public void forgetOldModel() {
        this.oldModel = null;
    }

    public Class[] getModelClasses() {
        return this.modelClasses;
    }

    public final void setModelClasses(Class[] modelClasses) {
        for (int i = 0; i < modelClasses.length; ++i) {
            if (modelClasses[i] != null) continue;
            throw new NullPointerException("Model class null: index + " + i);
        }
        this.modelClasses = modelClasses;
    }

    public Class[] getConsistentModelClasses() {
        int i;
        ArrayList<Class> classes = new ArrayList<Class>();
        ArrayList<SessionNode> parents = new ArrayList<SessionNode>(this.parents);
        Class[][] parentModelClasses = new Class[parents.size()][1];
        for (i = 0; i < parents.size(); ++i) {
            SessionNode sessionNode = (SessionNode)parents.get(i);
            SessionModel model = sessionNode.getModel();
            if (model == null) {
                return null;
            }
            parentModelClasses[i][0] = model.getClass();
        }
        for (i = 0; i < this.modelClasses.length; ++i) {
            if (!this.isConsistentModelClass(this.modelClasses[i], parentModelClasses)) continue;
            classes.add(this.modelClasses[i]);
        }
        return classes.toArray(new Class[0]);
    }

    public SessionModel getModel() {
        return this.model;
    }

    public Class getLastModelClass() {
        return this.lastModelClass;
    }

    public void addSessionListener(SessionListener l) {
        this.getSessionSupport().addSessionListener(l);
    }

    public void removeSessionListener(SessionListener l) {
        this.getSessionSupport().removeSessionListener(l);
    }

    public boolean isFreshlyCreated() {
        return this.model == null && this.modelParamTypes == null && this.parents.size() == 0 && this.children.size() == 0 && this.sessionHandler == null && this.sessionSupport == null;
    }

    public void resetToFreshlyCreated() {
        if (!this.isFreshlyCreated()) {
            HashSet<SessionNode> _parents = new HashSet<SessionNode>(this.parents);
            HashSet<SessionNode> _children = new HashSet<SessionNode>(this.children);
            for (SessionNode _parent : _parents) {
                this.removeParent(_parent);
            }
            for (SessionNode a_children : _children) {
                this.removeChild(a_children);
            }
            this.destroyModel();
            this.parents = new HashSet<SessionNode>();
            this.children = new HashSet<SessionNode>();
            this.sessionSupport = null;
            this.sessionHandler = null;
        }
    }

    public void restrictConnectionsToList(List sessionNodes) {
        for (SessionNode sessionNode : this.getParents()) {
            if (sessionNodes.contains(sessionNode)) continue;
            this.removeParent(sessionNode);
        }
        for (SessionNode sessionNode1 : this.getChildren()) {
            if (sessionNodes.contains(sessionNode1)) continue;
            this.removeChild(sessionNode1);
        }
    }

    public void restrictListenersToSessionNodes() {
        this.sessionSupport = null;
        this.sessionHandler = null;
    }

    public boolean isStructurallyIdentical(SessionNode node) {
        SessionModel model;
        HashSet<Class> set2;
        if (node == null) {
            return false;
        }
        HashSet<Class> set1 = new HashSet<Class>(Arrays.asList(this.getModelClasses()));
        if (!((Object)set1).equals(set2 = new HashSet<Class>(Arrays.asList(node.getModelClasses())))) {
            return false;
        }
        Class[] arr1 = this.getModelParamTypes();
        Class[] arr2 = node.getModelParamTypes();
        if (arr1 != null && arr2 != null) {
            if (arr1.length != arr2.length) {
                return false;
            }
            for (int i = 0; i < arr1.length; ++i) {
                if (arr1[i].equals(arr2[i])) continue;
                return false;
            }
        } else if (arr1 == null && arr2 != null) {
            return false;
        }
        SessionModel model1 = this.getModel();
        SessionModel model2 = node.getModel();
        if (model1 == null && model2 != null) {
            return false;
        }
        if (model1 != null && model2 == null) {
            return false;
        }
        if (model1 != null && !model1.equals(model2)) {
            return false;
        }
        set1.clear();
        for (SessionNode sessionNode : this.getParents()) {
            model = sessionNode.getModel();
            if (model == null) continue;
            set1.add(model.getClass());
        }
        set2.clear();
        for (SessionNode sessionNode1 : node.getParents()) {
            model = sessionNode1.getModel();
            if (model == null) continue;
            set2.add(model.getClass());
        }
        if (!((Object)set1).equals(set2)) {
            return false;
        }
        set1.clear();
        for (SessionNode sessionNode2 : this.getChildren()) {
            model = sessionNode2.getModel();
            if (model == null) continue;
            set1.add(model.getClass());
        }
        set2.clear();
        for (SessionNode sessionNode3 : node.getChildren()) {
            model = sessionNode3.getModel();
            if (model == null) continue;
            set2.add(model.getClass());
        }
        return ((Object)set1).equals(set2);
    }

    public String getBoxType() {
        return this.boxType;
    }

    public final void setBoxType(String boxType) {
        if (boxType == null) {
            throw new NullPointerException();
        }
        this.boxType = boxType;
    }

    public void putParam(Class modelClass, Params param) {
        if (param instanceof SessionListener) {
            SessionListener listener = (SessionListener)((Object)param);
            this.getSessionSupport().addSessionListener(listener);
        }
        this.paramMap.put(modelClass, param);
    }

    public Params getParam(Class modelClass) {
        return this.paramMap.get(modelClass);
    }

    public void removeParam(Class modelClass) {
        Params param = this.paramMap.get(modelClass);
        if (param != null && param instanceof SessionListener) {
            SessionListener listener = (SessionListener)((Object)param);
            this.getSessionSupport().removeSessionListener(listener);
        }
        this.paramMap.remove(modelClass);
    }

    public Object[] getModelConstructorArguments(Class modelClass) {
        Constructor<?>[] constructors;
        List<Object> parentModels = this.getParentModels();
        parentModels.add(this.getParam(modelClass));
        for (Constructor<?> constructor : constructors = modelClass.getConstructors()) {
            Class[] parameterTypes = constructor.getParameterTypes();
            Object[] arguments = this.assignParameters(parameterTypes, parentModels);
            if (arguments == null) continue;
            return arguments;
        }
        return null;
    }

    public String toString() {
        return this.getBoxType();
    }

    public void setNextEdgeAddAllowed(boolean nextEdgeAddAllowed) {
        this.nextEdgeAddAllowed = nextEdgeAddAllowed;
    }

    public boolean existsParameterizedConstructor(Class modelClass) {
        Params param = this.getParam(modelClass);
        List<Object> parentModels = this.listParentModels();
        parentModels.add(param);
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = modelClass.getConstructors()) {
                Class[] parameterTypes = constructor.getParameterTypes();
                Object[] arguments = this.assignParameters(parameterTypes, parentModels);
                if (arguments == null) continue;
                return true;
            }
            return false;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not construct model.", e);
        }
    }

    public int getRepetition() {
        return this.repetition;
    }

    public void setRepetition(int repetition) {
        if (repetition < 1) {
            throw new IllegalArgumentException("Repetition must be >= 1.");
        }
        this.repetition = repetition;
    }

    public boolean useClonedModel() {
        try {
            if (this.model instanceof Unmarshallable) {
                return false;
            }
            SessionModel temp = this.model;
            this.model = new MarshalledObject<SessionModel>(this.model).get();
            this.model.setName(this.getDisplayName());
            if (this.model instanceof ParamsResettable && temp instanceof ParamsResettable) {
                Object resettableParams = ((ParamsResettable)((Object)temp)).getResettableParams();
                ((ParamsResettable)((Object)this.model)).resetParams(resettableParams);
            }
            this.savedModel = temp;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void forgetSavedModel() {
        this.savedModel = null;
    }

    public void restoreOriginalModel() {
        this.model = this.savedModel;
        this.model.setName(this.getDisplayName());
        this.savedModel = null;
    }

    boolean isConsistentModelClass(Class<Type1> modelClass, List nodes) {
        Class[][] nodeClasses = new Class[nodes.size()][];
        for (int i = 0; i < nodes.size(); ++i) {
            SessionNode node = (SessionNode)nodes.get(i);
            nodeClasses[i] = node.getModelClasses();
        }
        return this.isConsistentModelClass(modelClass, nodeClasses);
    }

    boolean existsConstructor(Class modelClass, Class[] argumentTypes) {
        Constructor<?>[] constructors;
        for (Class argumentType1 : argumentTypes) {
            if (argumentType1 != null) continue;
            throw new IllegalArgumentException("Argument classes must be non-null");
        }
        block1: for (Constructor<?> constructor : constructors = modelClass.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            ArrayList<Class> remainingParameterTypes = new ArrayList<Class>(Arrays.asList(parameterTypes));
            for (Class argumentType : argumentTypes) {
                Class type = this.findMatchingType(remainingParameterTypes, argumentType);
                if (type == null) continue block1;
                remainingParameterTypes.remove(type);
            }
            return true;
        }
        return false;
    }

    Class getAssignableClass(List classes, Class clazz) {
        for (Object aClass : classes) {
            Class assignableTo = (Class)aClass;
            if (!assignableTo.isAssignableFrom(clazz)) continue;
            return assignableTo;
        }
        return null;
    }

    Object[] assignParameters(Class[] parameterTypes, List objects) throws RuntimeException {
        for (Class parameterType1 : parameterTypes) {
            if (parameterType1 != null) continue;
            throw new NullPointerException("Parameter types must all be non-null.");
        }
        Object[] arguments = new Object[parameterTypes.length];
        List _objects = this.removeNulls(objects);
        for (int i = 0; i < arguments.length; ++i) {
            Object _object;
            block4: {
                Class parameterType = parameterTypes[i];
                for (int j = 0; j < _objects.size(); ++j) {
                    _object = _objects.get(j);
                    if (!parameterType.isAssignableFrom(_object.getClass())) {
                        continue;
                    }
                    break block4;
                }
                return null;
            }
            arguments[i] = _object;
            _objects.remove(_object);
        }
        return _objects.size() > 0 ? null : arguments;
    }

    int[] getValueCombination(int index, int[] numValues) {
        int[] values = new int[numValues.length];
        for (int i = numValues.length - 1; i >= 0; --i) {
            values[i] = index % numValues[i];
            index /= numValues[i];
        }
        return values;
    }

    int getProduct(int[] arr) {
        int n = 1;
        for (int anArr : arr) {
            n *= anArr;
        }
        return n;
    }

    SessionHandler getSessionHandler() {
        if (this.sessionHandler == null) {
            this.sessionHandler = new SessionHandler();
        }
        return this.sessionHandler;
    }

    private boolean containsParent(SessionNode parent) {
        return this.parents.contains(parent);
    }

    private Class[] getModelParamTypes() {
        return this.modelParamTypes;
    }

    private boolean isNextEdgeAddAllowed() {
        return this.nextEdgeAddAllowed;
    }

    private List<Object> getParentModels() {
        ArrayList<Object> models = new ArrayList<Object>();
        for (SessionNode node : this.parents) {
            SessionModel model = node.getModel();
            if (model != null) {
                models.add(model);
                continue;
            }
            return null;
        }
        return models;
    }

    private List<Object> listParentModels() {
        ArrayList<Object> models = new ArrayList<Object>();
        for (SessionNode node : this.parents) {
            SessionModel model = node.getModel();
            if (model == null) {
                throw new RuntimeException("One of the parents has an empty model.");
            }
            models.add(model);
        }
        return models;
    }

    private void createModelUsingArguments(Class modelClass, List models) throws Exception {
        Constructor<?>[] constructors;
        System.out.println("Model class: " + modelClass);
        System.out.println("models: " + models);
        if (!SessionModel.class.isAssignableFrom(modelClass)) {
            throw new ClassCastException("Model class must implement SessionModel: " + modelClass);
        }
        for (Constructor<?> constructor : constructors = modelClass.getConstructors()) {
            Class[] parameterTypes = constructor.getParameterTypes();
            Object[] arguments = this.assignParameters(parameterTypes, models);
            if (arguments == null) continue;
            try {
                this.model = (SessionModel)constructor.newInstance(arguments);
                this.model.setName(this.getDisplayName());
            }
            catch (InstantiationException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                String packagePath = modelClass.getName();
                int begin = packagePath.lastIndexOf(46) + 1;
                String name = packagePath.substring(begin, packagePath.length());
                if (e.getTargetException() instanceof ThreadDeath) {
                    e.printStackTrace();
                    return;
                }
                throw new InvocationTargetException(e, "Could not construct \"" + name + ".\"" + "\nRoot cause: " + e.getCause().getMessage());
            }
            this.modelParamTypes = parameterTypes;
            this.lastModelClass = modelClass;
            this.getSessionSupport().fireModelCreated(this);
            break;
        }
    }

    private boolean isConsistentModelClass(Class modelClass, Class[][] parentClasses) {
        int i;
        Class[] parameterTypes = new Class[parentClasses.length];
        int[] numModels = new int[parentClasses.length];
        for (i = 0; i < parentClasses.length; ++i) {
            numModels[i] = parentClasses[i].length;
        }
        for (i = 0; i < this.getProduct(numModels); ++i) {
            int[] combination = this.getValueCombination(i, numModels);
            for (int j = 0; j < parentClasses.length; ++j) {
                parameterTypes[j] = parentClasses[j][combination[j]];
            }
            if (!this.existsConstructor(modelClass, parameterTypes)) continue;
            return true;
        }
        return false;
    }

    private Class findMatchingType(List<Class> parameterTypes, Class argumentType) {
        for (Class type : parameterTypes) {
            if (!type.isAssignableFrom(argumentType)) continue;
            return type;
        }
        return null;
    }

    private List removeNulls(List objects) {
        ArrayList _objects = new ArrayList();
        for (Object o : objects) {
            if (o == null) continue;
            _objects.add(o);
        }
        return _objects;
    }

    private void reassessModel() {
        if (this.modelParamTypes == null) {
            return;
        }
        ArrayList list1 = new ArrayList();
        for (SessionNode node : this.parents) {
            SessionModel model = node.getModel();
            if (model == null) continue;
            list1.add(model.getClass());
        }
        List<Class> list2 = Arrays.asList(this.modelParamTypes);
        if (!list1.contains(list2) || !list2.contains(list1)) {
            this.destroyModel();
        }
    }

    private SessionSupport getSessionSupport() {
        if (this.sessionSupport == null) {
            this.sessionSupport = new SessionSupport(this);
            for (SessionNode child : this.children) {
                this.sessionSupport.addSessionListener(child.getSessionHandler());
            }
        }
        return this.sessionSupport;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public final void setDisplayName(String displayName) {
        if (displayName == null) {
            throw new NullPointerException();
        }
        this.displayName = displayName;
        if (this.getModel() != null) {
            this.getModel().setName(displayName);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.boxType == null) {
            throw new NullPointerException();
        }
        if (this.displayName == null) {
            throw new NullPointerException();
        }
        if (this.modelClasses == null) {
            throw new NullPointerException();
        }
        if (this.paramMap == null) {
            throw new NullPointerException();
        }
        if (this.parents == null) {
            throw new NullPointerException();
        }
        if (this.children == null) {
            throw new NullPointerException();
        }
        if (this.repetition < 1) {
            throw new IllegalStateException();
        }
    }

    private class SessionHandler
    extends SessionAdapter {
        private SessionHandler() {
        }

        @Override
        public void modelDestroyed(SessionEvent event) {
            SessionNode.this.reassessModel();
        }

        @Override
        public void executionStarted(SessionEvent event) {
            Params param;
            SessionModel model = SessionNode.this.getModel();
            if (model != null && (param = SessionNode.this.getParam(model.getClass())) instanceof ExecutionRestarter) {
                ExecutionRestarter restarter = (ExecutionRestarter)((Object)param);
                restarter.newExecution();
            }
            SessionNode.this.getSessionSupport().fireSessionEvent(event);
        }
    }
}

