/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.session;

import edu.cmu.tetrad.session.SessionEvent;
import edu.cmu.tetrad.session.SessionListener;
import edu.cmu.tetrad.session.SessionNode;
import java.util.ArrayList;
import java.util.List;

public class SessionSupport {
    private Object source;
    private List sessionListeners = new ArrayList();

    public SessionSupport(Object source) {
        if (source == null) {
            throw new IllegalArgumentException("Source must not be null.");
        }
        this.source = source;
    }

    public void addSessionListener(SessionListener l) {
        if (!this.sessionListeners.contains(l)) {
            this.sessionListeners.add(l);
        }
    }

    public void removeSessionListener(SessionListener l) {
        if (this.sessionListeners.contains(l)) {
            this.sessionListeners.remove(l);
        }
    }

    public void fireNodeAdded(SessionNode node) {
        SessionEvent event = new SessionEvent(this.source, node, 0);
        this.fireSessionEvent(event);
    }

    public void fireNodeRemoved(SessionNode node) {
        SessionEvent event = new SessionEvent(this.source, node, 1);
        this.fireSessionEvent(event);
    }

    public void fireParentAdded(SessionNode parent, SessionNode child) {
        SessionEvent event = new SessionEvent(this.source, parent, child, 2);
        this.fireSessionEvent(event);
    }

    public void fireParentRemoved(SessionNode parent, SessionNode child) {
        SessionEvent event = new SessionEvent(this.source, parent, child, 3);
        this.fireSessionEvent(event);
    }

    public void fireModelCreated(SessionNode node) {
        SessionEvent event = new SessionEvent(this.source, node, 4);
        this.fireSessionEvent(event);
    }

    public void fireModelDestroyed(SessionNode node) {
        SessionEvent event = new SessionEvent(this.source, node, 5);
        this.fireSessionEvent(event);
    }

    public void fireModelUnclear(SessionNode node) {
        SessionEvent event = new SessionEvent(this.source, node, 6);
        this.fireSessionEvent(event);
    }

    public void fireRepetitionChanged(SessionNode node) {
        SessionEvent event = new SessionEvent(this.source, node, 8);
        this.fireSessionEvent(event);
    }

    public void fireExecutionStarted() {
        SessionEvent event = new SessionEvent(this.source, 7);
        this.fireSessionEvent(event);
    }

    public void fireAddingEdge() {
        SessionEvent event = new SessionEvent(this.source, 9);
        this.fireSessionEvent(event);
    }

    public void fireSessionEvent(SessionEvent event) {
        this.fireSessionEvent(event, true);
    }

    public void fireSessionEvent(SessionEvent event, boolean restamp) {
        if (restamp && event.getSource() != this.source) {
            event = new SessionEvent(this.source, event);
        }
        block12: for (int i = 0; i < this.sessionListeners.size(); ++i) {
            SessionListener l = (SessionListener)this.sessionListeners.get(i);
            switch (event.getType()) {
                case 0: {
                    l.nodeAdded(event);
                    continue block12;
                }
                case 1: {
                    l.nodeRemoved(event);
                    continue block12;
                }
                case 2: {
                    l.parentAdded(event);
                    continue block12;
                }
                case 3: {
                    l.parentRemoved(event);
                    continue block12;
                }
                case 4: {
                    l.modelCreated(event);
                    continue block12;
                }
                case 5: {
                    l.modelDestroyed(event);
                    continue block12;
                }
                case 6: {
                    l.modelUnclear(event);
                    continue block12;
                }
                case 7: {
                    l.executionStarted(event);
                    continue block12;
                }
                case 8: {
                    l.repetitionChanged(event);
                    continue block12;
                }
                case 9: {
                    l.addingEdge(event);
                    continue block12;
                }
                default: {
                    throw new IllegalStateException("No such state: " + event.getType());
                }
            }
        }
    }
}

