/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.session;

import edu.cmu.tetrad.session.SessionEvent;
import edu.cmu.tetrad.session.SessionListener;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.session.SessionNode;
import edu.cmu.tetrad.session.Type1;
import edu.cmu.tetrad.session.Type2;
import edu.cmu.tetrad.session.Type3;
import edu.cmu.tetrad.session.Type4;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSessionNode
extends TestCase {
    private String eventId;

    public TestSessionNode(String name) {
        super(name);
    }

    public void testExistsConstructor() {
        SessionNode node = new SessionNode(Type1.class);
        Class[] testSet1 = new Class[]{Type1.class};
        Class[] testSet2 = new Class[]{Type2.class};
        Class[] testSet3 = new Class[]{Type3.class};
        Class[] testSet4 = new Class[]{Type2.class, Type3.class};
        Class[] testSet5 = new Class[]{Type3.class, Type4.class};
        Class[] testSet6 = new Class[]{Type2.class, Type2.class};
        TestSessionNode.assertTrue(!node.existsConstructor(Type1.class, testSet1));
        TestSessionNode.assertTrue(node.existsConstructor(Type1.class, testSet2));
        TestSessionNode.assertTrue(node.existsConstructor(Type1.class, testSet3));
        TestSessionNode.assertTrue(node.existsConstructor(Type1.class, testSet4));
        TestSessionNode.assertTrue(!node.existsConstructor(Type1.class, testSet5));
        TestSessionNode.assertTrue(!node.existsConstructor(Type1.class, testSet6));
    }

    public void testGetValueCombination() {
        SessionNode node = new SessionNode(Type1.class);
        int[] numValues = new int[]{2, 3, 4};
        TestSessionNode.assertEquals(24, node.getProduct(numValues));
        TestSessionNode.assertTrue(this.isTheSame(node.getValueCombination(0, numValues), 0, 0, 0));
        TestSessionNode.assertTrue(this.isTheSame(node.getValueCombination(5, numValues), 0, 1, 1));
        TestSessionNode.assertTrue(this.isTheSame(node.getValueCombination(10, numValues), 0, 2, 2));
        TestSessionNode.assertTrue(this.isTheSame(node.getValueCombination(15, numValues), 1, 0, 3));
        TestSessionNode.assertTrue(this.isTheSame(node.getValueCombination(19, numValues), 1, 1, 3));
        TestSessionNode.assertTrue(this.isTheSame(node.getValueCombination(23, numValues), 1, 2, 3));
    }

    private boolean isTheSame(int[] arr, int n1, int n2, int n3) {
        return arr[0] == n1 && arr[1] == n2 && arr[2] == n3;
    }

    public void testAssignParameters1() {
        SessionNode node = new SessionNode(Type1.class);
        Type2 object1 = new Type2();
        Type3 object2 = new Type3(object1);
        ArrayList<SessionModel> objects = new ArrayList<SessionModel>();
        objects.add(object1);
        objects.add(object2);
        Class[] parameterTypes1 = new Class[]{Type2.class, Type3.class};
        Object[] arguments1 = node.assignParameters(parameterTypes1, objects);
        TestSessionNode.assertNotNull(arguments1);
        for (int i = 0; i < parameterTypes1.length; ++i) {
            TestSessionNode.assertEquals(arguments1[i].getClass(), parameterTypes1[i]);
        }
        Class[] parameterTypes2 = new Class[]{Type1.class, Type3.class};
        Object[] arguments2 = node.assignParameters(parameterTypes2, objects);
        TestSessionNode.assertNull(arguments2);
        try {
            Class[] parameterTypes3 = new Class[]{Type2.class, Type3.class, null};
            node.assignParameters(parameterTypes3, objects);
            TestSessionNode.fail("Should not have been able to assign parameters with a null parameter in the list.");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Class[] parameterTypes4 = new Class[]{Type2.class, Type3.class, Type4.class};
        Object[] arguments4 = node.assignParameters(parameterTypes4, objects);
        TestSessionNode.assertNull(arguments4);
    }

    public void testIsConsistentModelClass() {
        SessionNode node1 = new SessionNode(Type1.class);
        SessionNode node2 = new SessionNode(Type2.class);
        SessionNode node3 = new SessionNode(Type3.class);
        SessionNode node4 = new SessionNode(new Class[]{Type1.class, Type2.class});
        SessionNode node6 = new SessionNode(new Class[]{Type1.class, Type2.class, Type3.class});
        SessionNode node7 = new SessionNode(new Class[]{Type1.class, Type4.class});
        ArrayList<SessionNode> parents = new ArrayList<SessionNode>();
        parents.add(node1);
        parents.add(node2);
        parents.add(node3);
        parents.remove(node1);
        parents.remove(node2);
        parents.remove(node3);
        parents.add(node4);
        TestSessionNode.assertTrue(node1.isConsistentModelClass(Type1.class, parents));
        parents.add(node6);
        TestSessionNode.assertTrue(node1.isConsistentModelClass(Type1.class, parents));
        parents.remove(node6);
        parents.add(node7);
        TestSessionNode.assertTrue(!node1.isConsistentModelClass(Type1.class, parents));
    }

    public void testGetAssignableClass() {
        SessionNode node1 = new SessionNode("???", "Node1", Type1.class);
        ArrayList<Class<String>> list = new ArrayList<Class<String>>();
        list.add(List.class);
        list.add(Map.class);
        list.add(String.class);
        TestSessionNode.assertNotNull(node1.getAssignableClass(list, ArrayList.class));
        TestSessionNode.assertNotNull(node1.getAssignableClass(list, SortedMap.class));
        TestSessionNode.assertNull(node1.getAssignableClass(list, Object.class));
    }

    public void testAddRemoveParents() {
        SessionNode node1 = new SessionNode("???", "Node1", Type1.class);
        SessionNode node2 = new SessionNode("???", "Node2", Type2.class);
        SessionNode node3 = new SessionNode("???", "Node2", Type3.class);
        SessionNode node4 = new SessionNode("???", "Node4", Type4.class);
        TestSessionNode.assertTrue(node1.addParent(node2));
        TestSessionNode.assertEquals(1, node2.getNumChildren());
        TestSessionNode.assertEquals(1, node1.getNumParents());
        TestSessionNode.assertTrue(!node1.addParent(node4));
        TestSessionNode.assertTrue(node1.addParent(node3));
        TestSessionNode.assertTrue(!node1.removeParent(node4));
        TestSessionNode.assertTrue(node1.removeParent(node2));
        TestSessionNode.assertEquals(1, node1.getNumParents());
        TestSessionNode.assertTrue(node1.removeParent(node3));
        TestSessionNode.assertEquals(0, node1.getNumParents());
    }

    public void testAddRemoveChildren() {
        SessionNode node1 = new SessionNode("???", "Node1", Type1.class);
        SessionNode node2 = new SessionNode("???", "Node2", Type2.class);
        SessionNode node3 = new SessionNode("???", "Node3", Type3.class);
        SessionNode node4 = new SessionNode("???", "Node4", Type4.class);
        TestSessionNode.assertTrue(node2.addChild(node1));
        TestSessionNode.assertEquals(1, node2.getNumChildren());
        TestSessionNode.assertEquals(1, node1.getNumParents());
        TestSessionNode.assertTrue(!node4.addChild(node1));
        TestSessionNode.assertTrue(node3.addChild(node1));
        TestSessionNode.assertTrue(!node4.removeChild(node1));
        TestSessionNode.assertEquals(1, node2.getNumChildren());
        TestSessionNode.assertEquals(1, node3.getNumChildren());
        TestSessionNode.assertTrue(node2.removeChild(node1));
        TestSessionNode.assertTrue(node3.removeChild(node1));
        TestSessionNode.assertEquals(0, node3.getNumChildren());
    }

    public void testGetConsistentModelClasses() throws Exception {
        boolean simulation = true;
        SessionNode node1 = new SessionNode(new Class[]{Type1.class});
        SessionNode node2 = new SessionNode(new Class[]{Type2.class});
        SessionNode node3 = new SessionNode(new Class[]{Type3.class});
        TestSessionNode.assertTrue(node1.addParent(node2));
        TestSessionNode.assertTrue(node1.addParent(node3));
        TestSessionNode.assertTrue(node3.addParent(node2));
        Class[] classes = node1.getConsistentModelClasses();
        TestSessionNode.assertNull(classes);
        try {
            node2.createModel(Type2.class, simulation);
            node3.createModel(Type3.class, simulation);
        }
        catch (RuntimeException e) {
            TestSessionNode.fail("Model not created.");
        }
        classes = node1.getConsistentModelClasses();
        TestSessionNode.assertNotNull(classes);
        TestSessionNode.assertEquals(classes[0], Type1.class);
    }

    public void testCreateModel() {
        boolean simulation = true;
        SessionNode node1 = new SessionNode(Type1.class);
        SessionNode node2 = new SessionNode(Type2.class);
        SessionNode node3 = new SessionNode(Type3.class);
        node3.addParent(node2);
        node1.addParent(node2);
        node1.addParent(node3);
        try {
            node2.createModel(Type2.class, simulation);
            node3.createModel(Type3.class, simulation);
            node1.createModel(Type1.class, simulation);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestSessionNode.fail("Model not created.");
        }
        node1.destroyModel();
        TestSessionNode.assertNull(node1.getModel());
    }

    public void testEvents() {
        boolean simulation = true;
        SessionListener listener = new SessionListener(){

            @Override
            public void nodeAdded(SessionEvent event) {
                TestSessionNode.this.setEventId("nodeAdded");
            }

            @Override
            public void nodeRemoved(SessionEvent event) {
                TestSessionNode.this.setEventId("nodeRemoved");
            }

            @Override
            public void parentAdded(SessionEvent event) {
                TestSessionNode.this.setEventId("parentAdded");
            }

            @Override
            public void parentRemoved(SessionEvent event) {
                TestSessionNode.this.setEventId("parentRemoved");
            }

            @Override
            public void modelCreated(SessionEvent event) {
                TestSessionNode.this.setEventId("modelCreated");
            }

            @Override
            public void modelDestroyed(SessionEvent event) {
                TestSessionNode.this.setEventId("modelDestroyed");
            }

            @Override
            public void modelUnclear(SessionEvent event) {
                TestSessionNode.this.setEventId("modelUnclear");
            }

            @Override
            public void executionStarted(SessionEvent event) {
                TestSessionNode.this.setEventId("executionBegun");
            }

            @Override
            public void repetitionChanged(SessionEvent event) {
                TestSessionNode.this.setEventId("repetitionChanged");
            }

            @Override
            public void addingEdge(SessionEvent event) {
                TestSessionNode.this.setEventId("addingEdge");
            }
        };
        SessionNode node1 = new SessionNode("???", "Node1", Type1.class);
        SessionNode node2 = new SessionNode("???", "Node2", Type2.class);
        SessionNode node3 = new SessionNode("???", "Node3", Type3.class);
        node1.addSessionListener(listener);
        try {
            this.setEventId(null);
            node1.addParent(node2);
            TestSessionNode.assertEquals("parentAdded", this.getEventId());
            this.setEventId(null);
            node1.removeParent(node2);
            TestSessionNode.assertEquals("parentRemoved", this.getEventId());
            this.setEventId(null);
            node2.addChild(node1);
            TestSessionNode.assertEquals("parentAdded", this.getEventId());
            this.setEventId(null);
            node2.removeChild(node1);
            TestSessionNode.assertEquals("parentRemoved", this.getEventId());
            node1.addParent(node2);
            node1.addParent(node3);
            node3.addParent(node2);
            node2.createModel(Type2.class, simulation);
            node3.createModel(Type3.class, simulation);
            this.setEventId(null);
            node1.createModel(Type1.class, simulation);
            TestSessionNode.assertEquals("modelCreated", this.getEventId());
            this.setEventId(null);
            node1.destroyModel();
            TestSessionNode.assertEquals("modelDestroyed", this.getEventId());
            node1.createModel(Type1.class, simulation);
            TestSessionNode.assertNotNull(node1.getModel());
            node2.destroyModel();
            TestSessionNode.assertNull(node1.getModel());
        }
        catch (Exception e) {
            TestSessionNode.fail(e.getMessage());
        }
    }

    private void setEventId(String eventId) {
        this.eventId = eventId;
    }

    private String getEventId() {
        return this.eventId;
    }

    public void testStructuralIdentity() {
        boolean simulation = true;
        SessionNode node1 = new SessionNode(Type1.class);
        SessionNode node2 = new SessionNode(Type2.class);
        SessionNode node3 = new SessionNode(Type3.class);
        try {
            node1.addParent(node2);
            node1.addParent(node3);
            node3.addParent(node2);
            node2.createModel(Type2.class, simulation);
            node3.createModel(Type3.class, simulation);
            node1.createModel(Type1.class, simulation);
            TestSessionNode.assertTrue(node1.isStructurallyIdentical(node1));
            TestSessionNode.assertTrue(!node1.isStructurallyIdentical(node2));
        }
        catch (Exception e) {
            TestSessionNode.fail(e.getMessage());
        }
    }

    public void testSerialization() {
        boolean simulation = true;
        SessionNode node1 = new SessionNode(Type1.class);
        SessionNode node2 = new SessionNode(Type2.class);
        SessionNode node3 = new SessionNode(Type3.class);
        node1.addParent(node2);
        node1.addParent(node3);
        node3.addParent(node2);
        try {
            node2.createModel(Type2.class, simulation);
            node3.createModel(Type3.class, simulation);
            node1.createModel(Type1.class, simulation);
        }
        catch (Exception e) {
            TestSessionNode.fail("Model not created.");
        }
        SessionNode node1Copy = null;
        try {
            node1Copy = new MarshalledObject<SessionNode>(node1).get();
        }
        catch (Exception e) {
            TestSessionNode.fail("Serialization failed.");
        }
        TestSessionNode.assertTrue(node1.isStructurallyIdentical(node1Copy));
    }

    public void testParameterization() {
        boolean simulation = true;
        SessionNode node1 = new SessionNode(Type1.class);
        SessionNode node2 = new SessionNode(Type2.class);
        SessionNode node3 = new SessionNode(Type3.class);
        Type2 param = new Type2();
        node1.putParam(Type1.class, param);
        node1.addParent(node3);
        node3.addParent(node2);
        try {
            node2.createModel(Type2.class, simulation);
            node3.createModel(Type3.class, simulation);
            node1.createModel(Type1.class, simulation);
        }
        catch (Exception e) {
            TestSessionNode.fail("Model not created.");
        }
        node1.destroyModel();
        try {
            node1.createModel(simulation);
        }
        catch (Exception e) {
            TestSessionNode.fail("Model not created.");
        }
    }

    public void testSetName() {
        String name = "Test";
        SessionNode node1 = new SessionNode("???", name, Type1.class);
        TestSessionNode.assertEquals(name, node1.getDisplayName());
    }

    public static Test suite() {
        return new TestSuite(TestSessionNode.class);
    }
}

