/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.test;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataWriter;
import edu.cmu.tetrad.data.DelimiterType;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.RandomUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDataLoadersRoundtrip
extends TestCase {
    public TestDataLoadersRoundtrip(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        RandomUtil.getInstance().setSeed(302040392L);
        File file = new File("test_data");
        if (!file.exists()) {
            new File("test_data").mkdir();
        }
    }

    public void testContinuousRoundtrip() {
        try {
            Dag randomGraph = GraphUtils.randomDagC(5, 0, 8);
            SemPm semPm1 = new SemPm(randomGraph);
            SemIm semIm1 = new SemIm(semPm1);
            DataSet dataSet = semIm1.simulateData(10, false);
            System.out.println(dataSet);
            FileWriter fileWriter = new FileWriter("test_data/roundtrip.dat");
            PrintWriter writer = new PrintWriter(fileWriter);
            DataWriter.writeRectangularData(dataSet, writer, ',');
            ((Writer)writer).close();
            new File("test_data").mkdir();
            File file = new File("test_data/roundtrip.dat");
            DataReader reader = new DataReader();
            reader.setDelimiter(DelimiterType.COMMA);
            DataSet _dataSet = reader.parseTabular(file);
            System.out.println(dataSet);
            System.out.println(_dataSet);
            TestDataLoadersRoundtrip.assertTrue(dataSet.equals(_dataSet));
        }
        catch (IOException e) {
            e.printStackTrace();
            TestDataLoadersRoundtrip.fail();
        }
    }

    public void testDiscreteRoundtrip() {
        try {
            for (int i = 0; i < 20; ++i) {
                Dag randomGraph = GraphUtils.randomDagC(5, 0, 8);
                Dag dag = new Dag(randomGraph);
                BayesPm bayesPm1 = new BayesPm(dag);
                MlBayesIm bayesIm1 = new MlBayesIm(bayesPm1, 1);
                DataSet dataSet = bayesIm1.simulateData(10, false);
                System.out.println(dataSet);
                new File("test_data").mkdir();
                FileWriter fileWriter = new FileWriter("test_data/roundtrip.dat");
                PrintWriter writer = new PrintWriter(fileWriter);
                DataWriter.writeRectangularData(dataSet, writer, '\t');
                ((Writer)writer).close();
                File file = new File("test_data/roundtrip.dat");
                DataReader reader = new DataReader();
                reader.setKnownVariables(dataSet.getVariables());
                DataSet _dataSet = reader.parseTabular(file);
                System.out.println(_dataSet);
                TestDataLoadersRoundtrip.assertTrue(dataSet.equals(_dataSet));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            TestDataLoadersRoundtrip.fail(e.getMessage());
        }
    }

    public static Test suite() {
        return new TestSuite(TestDataLoadersRoundtrip.class);
    }
}

