/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.test;

import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.StatUtils;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestStatUtils
extends TestCase {
    public TestStatUtils(String name) {
        super(name);
    }

    public void testConditionalCorrelation() {
        RandomUtil.getInstance().setSeed(302995833L);
        Dag graph = GraphUtils.randomDag(5, 0, 5, 3, 3, 3, false);
        SemPm pm = new SemPm(graph);
        SemIm im = new SemIm(pm);
        DataSet dataSet = im.simulateData(1000, false);
        double[] x = dataSet.getDoubleData().viewColumn(0).toArray();
        double[] y = dataSet.getDoubleData().viewColumn(1).toArray();
        double r1 = StatUtils.correlation(x, y);
        double s1 = StatUtils.covariance(x, y);
        double v1 = StatUtils.variance(x);
        double sd1 = StatUtils.standardDeviation(x);
        CovarianceMatrix cov = new CovarianceMatrix(dataSet);
        DoubleMatrix2D _cov = cov.getMatrix();
        System.out.println(cov);
        double r2 = StatUtils.partialCorrelation(_cov, 0, 1, new int[0]);
        double s2 = StatUtils.partialCovariance(_cov, 0, 1, new int[0]);
        double v2 = StatUtils.partialVariance(_cov, 0, new int[0]);
        double sd2 = StatUtils.partialStandardDeviation(_cov, 0, new int[0]);
        TestStatUtils.assertEquals(r1, r2, 0.01);
        TestStatUtils.assertEquals(s1, s2, 0.01);
        TestStatUtils.assertEquals(v1, v2, 0.01);
        TestStatUtils.assertEquals(sd1, sd2, 0.01);
    }

    public static Test suite() {
        return new TestSuite(TestStatUtils.class);
    }
}

