/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import edu.cmu.tetrad.util.Function;
import edu.cmu.tetrad.util.ProbUtils;
import edu.cmu.tetrad.util.TetradSerializable;

public class PartialCorrelationPdf
implements Function,
TetradSerializable {
    static final long serialVersionUID = 23L;
    private int n = 0;
    private int k = 0;
    private double gammaRatio = Double.NaN;
    private double constant = Double.NaN;
    private double outsideExp = 0.0;

    public PartialCorrelationPdf(int n, int k) {
        this.n = n;
        this.k = k;
        this.gammaRatio = this.gammaRatio(n, k);
        this.constant = 1.0 / Math.pow(Math.PI, 0.5) * this.gammaRatio;
        this.outsideExp = (double)(n - k - 2) / 2.0;
    }

    public static PartialCorrelationPdf serializableInstance() {
        return new PartialCorrelationPdf(5, 2);
    }

    @Override
    public double valueAt(double x) {
        return this.constant * Math.pow(1.0 - x * x, this.outsideExp);
    }

    private double gammaRatio(int n, int k) {
        double top = (double)(n - k + 1) / 2.0;
        double bottom = (double)(n - k) / 2.0;
        double lngamma = ProbUtils.lngamma(top) - ProbUtils.lngamma(bottom);
        return Math.exp(lngamma);
    }

    @Override
    public String toString() {
        return "Zero partial correlation distribution with n = " + this.getN() + " and k = " + this.getK() + "\n\n";
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }
}

