/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import cern.jet.random.Beta;
import cern.jet.random.BreitWigner;
import cern.jet.random.ChiSquare;
import cern.jet.random.Exponential;
import cern.jet.random.ExponentialPower;
import cern.jet.random.Gamma;
import cern.jet.random.Hyperbolic;
import cern.jet.random.Logarithmic;
import cern.jet.random.Normal;
import cern.jet.random.Poisson;
import cern.jet.random.StudentT;
import cern.jet.random.Uniform;
import cern.jet.random.VonMises;
import cern.jet.random.engine.MersenneTwister64;
import cern.jet.random.engine.RandomEngine;
import java.util.Date;

public class RandomUtil {
    private static final RandomUtil INSTANCE = new RandomUtil();
    private RandomEngine engine;
    private long seed;

    private RandomUtil() {
        this(new Date().getTime());
    }

    private RandomUtil(long seed) {
        this.seed = seed;
        this.engine = new MersenneTwister64(new Date(this.getSeed()));
    }

    public static RandomUtil getInstance() {
        return INSTANCE;
    }

    public int nextInt(int n) {
        return (int)(this.nextDouble() * (double)n);
    }

    public double nextDouble() {
        return new Uniform(0.0, 1.0, this.engine).nextDouble();
    }

    public double nextUniform(double low, double high) {
        return new Uniform(low, high, this.engine).nextDouble();
    }

    public double nextNormal(double mean, double sd) {
        if (sd < 0.0) {
            throw new IllegalArgumentException("Standard deviation must be non-negative: " + sd);
        }
        return new Normal(mean, sd, this.engine).nextDouble();
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
        this.engine = new MersenneTwister64(new Date(this.getSeed()));
    }

    public double nextPoisson(double lambda) {
        return new Poisson(lambda, this.engine).nextDouble();
    }

    public double normalPdf(double mean, double sd, double value) {
        return new Normal(mean, sd, this.engine).pdf(value);
    }

    public double normalCdf(double mean, double sd, double value) {
        return new Normal(mean, sd, this.engine).cdf(value);
    }

    public double nextBeta(double alpha, double beta) {
        return new Beta(alpha, beta, this.engine).nextDouble();
    }

    public double nextVonMises(double kappa) {
        return new VonMises(kappa, this.engine).nextDouble();
    }

    public double nextStudentT(double df) {
        return new StudentT(df, this.engine).nextDouble();
    }

    public double nextExponential(double lambda) {
        return new Exponential(lambda, this.engine).nextDouble();
    }

    public double nextExponentialPower(double tau) {
        System.out.println("tau = " + tau);
        return new ExponentialPower(tau, this.engine).nextDouble();
    }

    public double nextChiSquare(double df) {
        return new ChiSquare(df, this.engine).nextDouble();
    }

    public double nextGamma(double alpha, double lambda) {
        return new Gamma(alpha, lambda, this.engine).nextDouble();
    }

    public double nextLogarithmic(double p) {
        return new Logarithmic(p, this.engine).nextDouble();
    }

    public double nextBreitWigner(double mean, double gamma, double cut) {
        return new BreitWigner(mean, gamma, cut, this.engine).nextDouble();
    }

    public double nextHyperbolic(double alpha, double gamma) {
        return new Hyperbolic(alpha, gamma, this.engine).nextDouble();
    }
}

