/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import edu.cmu.tetrad.util.MultiDimIntTable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestMultiDimIntTable
extends TestCase {
    private MultiDimIntTable table;

    public TestMultiDimIntTable(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        int[] dims = new int[]{2, 3, 4, 5};
        this.table = new MultiDimIntTable(dims);
    }

    @Override
    public void tearDown() {
    }

    public void testSize() {
        TestMultiDimIntTable.assertEquals(this.table.getNumCells(), 120);
    }

    public void testIndexCalculation1() {
        int[] coords = new int[]{0, 0, 1, 0};
        int index = this.table.getCellIndex(coords);
        TestMultiDimIntTable.assertEquals(5, index);
    }

    public void testIndexCalculation2() {
        int[] coords = new int[]{0, 1, 2, 0};
        int index = this.table.getCellIndex(coords);
        TestMultiDimIntTable.assertEquals(30, index);
    }

    public void testCoordinateCalculation() {
        int[] coords = this.table.getCoordinates(30);
        TestMultiDimIntTable.assertEquals(1, coords[1]);
    }

    public void testCellIncrement() {
        int[] coords = this.table.getCoordinates(30);
        this.table.increment(coords, 1);
        TestMultiDimIntTable.assertEquals(1L, this.table.getValue(coords));
    }

    public void testNumDimensions() {
        TestMultiDimIntTable.assertEquals(4, this.table.getNumDimensions());
    }

    public static Test suite() {
        return new TestSuite(TestMultiDimIntTable.class);
    }
}

