/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import edu.cmu.tetrad.util.MultiDimIntTable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestMultiDimIntTable2
extends TestCase {
    private MultiDimIntTable table;

    public TestMultiDimIntTable2(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        int[] dims = new int[]{2, 3, 4, 5};
        this.table = new MultiDimIntTable(dims);
    }

    @Override
    public void tearDown() {
    }

    public void testIndexCalculation1() {
        int[] coords = new int[]{0, 0, 1, 0};
        int index = this.table.getCellIndex(coords);
        TestMultiDimIntTable2.assertEquals(5, index);
    }

    public void testIndexCalculation2() {
        int[] coords = new int[]{0, 1, 2, 0};
        int index = this.table.getCellIndex(coords);
        TestMultiDimIntTable2.assertEquals(30, index);
    }

    public void testCoordinateCalculation() {
        int[] coords = this.table.getCoordinates(30);
        TestMultiDimIntTable2.assertEquals(1, coords[1]);
    }

    public void testCellIncrement() {
        int[] coords = this.table.getCoordinates(30);
        this.table.increment(coords, 1);
        TestMultiDimIntTable2.assertEquals(1L, this.table.getValue(coords));
    }

    public void testNumDimensions() {
        TestMultiDimIntTable2.assertEquals(4, this.table.getNumDimensions());
    }

    public static Test suite() {
        return new TestSuite(TestMultiDimIntTable2.class);
    }
}

