/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util.dist;

import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.Distribution;

public class BreitWigner
implements Distribution {
    static final long serialVersionUID = 23L;
    private double mean = 0.0;
    private double gamma = 1.0;
    private double cut = 2.0;

    public BreitWigner(double mean, double gamma, double cut) {
        this.mean = mean;
        this.gamma = gamma;
        this.cut = cut;
    }

    public static BreitWigner serializableInstance() {
        return new BreitWigner(0.0, 1.0, 2.0);
    }

    @Override
    public double nextRandom() {
        return RandomUtil.getInstance().nextBreitWigner(this.mean, this.gamma, this.cut);
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0) {
            this.mean = value;
        } else if (index == 1) {
            this.gamma = value;
        } else if (index == 2) {
            this.cut = value;
        } else {
            throw new IllegalArgumentException("Illegal value: " + value);
        }
    }

    @Override
    public double getParameter(int index) {
        if (index == 0) {
            return this.mean;
        }
        if (index == 1) {
            return this.gamma;
        }
        if (index == 2) {
            return this.cut;
        }
        throw new IllegalArgumentException("Illegal index: " + index);
    }

    @Override
    public String getParameterName(int index) {
        if (index == 0) {
            return "Mean";
        }
        if (index == 1) {
            return "Gamma";
        }
        if (index == 2) {
            return "Cut";
        }
        throw new IllegalArgumentException("Not a parameter index: " + index);
    }

    @Override
    public int getNumParameters() {
        return 2;
    }

    @Override
    public String getName() {
        return "Breit Wigner";
    }
}

