/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util.dist;

import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.Distribution;

public class VonMises
implements Distribution {
    static final long serialVersionUID = 23L;
    private double freedom;

    public VonMises(double freedom) {
        this.freedom = freedom;
    }

    public static VonMises serializableInstance() {
        return new VonMises(1.0);
    }

    @Override
    public int getNumParameters() {
        return 1;
    }

    @Override
    public String getName() {
        return "Von Mises";
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0) {
            this.freedom = value;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double getParameter(int index) {
        if (index == 0) {
            return this.freedom;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getParameterName(int index) {
        return "Freedom";
    }

    @Override
    public double nextRandom() {
        return RandomUtil.getInstance().nextVonMises(this.freedom);
    }

    public String toString() {
        return "vonMises(" + this.freedom + ")";
    }
}

