/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp;

import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.app.TetradDesktop;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.ImageUtils;
import edu.cmu.tetradapp.util.SplashScreen;
import edu.cmu.tetradapp.util.Version;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.UIManager;

public final class Tetrad
implements PropertyChangeListener {
    private JFrame frame;
    private TetradDesktop desktop;
    private final String mainTitle = "Tetrad " + Version.currentViewableVersion().toString();

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("exitProgram".equals(e.getPropertyName())) {
            this.exitApplication();
        }
    }

    public static void main(String[] argv) {
        Tetrad.setLookAndFeel();
        new Tetrad().launchFrame();
    }

    private static void setLookAndFeel() {
        try {
            String os = System.getProperties().getProperty("os.name");
            if (os.equals("Windows XP")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void launchFrame() {
        this.desktop = new TetradDesktop();
        this.getDesktop().addPropertyChangeListener(this);
        JOptionUtils.setCenteringComp(this.getDesktop());
        DesktopController.setReference(this.getDesktop());
        this.frame = new JFrame(this.mainTitle){

            @Override
            public Dimension getPreferredSize() {
                return Toolkit.getDefaultToolkit().getScreenSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return Toolkit.getDefaultToolkit().getScreenSize();
            }
        };
        SplashScreen.show(this.getFrame(), "Loading Tetrad...", 1000);
        this.getFrame().setContentPane(this.getDesktop());
        this.getFrame().pack();
        this.getFrame().setExtendedState(6);
        Image image = ImageUtils.getImage(this.getFrame(), "tyler16.png");
        this.getFrame().setIconImage(image);
        this.getDesktop().newSessionEditor();
        this.getFrame().setVisible(true);
        this.getFrame().setDefaultCloseOperation(0);
        this.getFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Tetrad.this.exitApplication();
            }
        });
        SplashScreen.hide();
    }

    private void exitApplication() {
        boolean succeeded = this.getDesktop().closeAllSessions();
        if (!succeeded) {
            return;
        }
        this.getFrame().setVisible(false);
        this.getFrame().dispose();
        TetradLogger.getInstance().removeNextOutputStream();
        try {
            System.exit(0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JFrame getFrame() {
        return this.frame;
    }

    public TetradDesktop getDesktop() {
        return this.desktop;
    }
}

