/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.session.SessionNode;
import edu.cmu.tetradapp.app.ModelChooser;
import edu.cmu.tetradapp.app.SessionNodeModelConfig;
import edu.cmu.tetradapp.app.SessionUtils;
import edu.cmu.tetradapp.model.UnlistedSessionModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

class DefaultModelChooser
extends JComponent
implements ModelChooser {
    private JComboBox modelClassesBox;
    private String title;
    private String nodeName;
    private String id;
    private SessionNode sessionNode;

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Class getSelectedModel() {
        ClassWrapper wrapper = (ClassWrapper)this.modelClassesBox.getSelectedItem();
        return wrapper.getWrappedClass();
    }

    @Override
    public void setTitle(String title) {
        if (title == null) {
            throw new NullPointerException("The given title must not be null");
        }
        this.title = title;
    }

    @Override
    public void setModelConfigs(List<SessionNodeModelConfig> configs) {
        LinkedList<ClassWrapper> wrapperList = new LinkedList<ClassWrapper>();
        for (SessionNodeModelConfig config : configs) {
            Class modelClass = config.getModel();
            if (UnlistedSessionModel.class.isAssignableFrom(modelClass)) continue;
            wrapperList.add(new ClassWrapper(modelClass, config.getName()));
        }
        ClassWrapper[] wrappers = wrapperList.toArray(new ClassWrapper[0]);
        this.modelClassesBox = new JComboBox<ClassWrapper>(wrappers);
        this.modelClassesBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    int selectedIndex = DefaultModelChooser.this.modelClassesBox.getSelectedIndex();
                    String selectedModelType = DefaultModelChooser.this.modelClassesBox.getItemAt(selectedIndex).toString();
                    Preferences.userRoot().put(DefaultModelChooser.this.id, selectedModelType);
                }
            }
        });
        String storedModelType = Preferences.userRoot().get(this.id, "");
        for (int i = 0; i < this.modelClassesBox.getItemCount(); ++i) {
            String currModelType = this.modelClassesBox.getItemAt(i).toString();
            if (!storedModelType.equals(currModelType)) continue;
            this.modelClassesBox.setSelectedIndex(i);
        }
    }

    @Override
    public void setNodeId(String id) {
        if (id == null) {
            throw new NullPointerException("The given id must not be null");
        }
        this.id = id;
    }

    @Override
    public void setSessionNode(SessionNode sessionNode) {
        this.sessionNode = sessionNode;
        this.nodeName = sessionNode.getDisplayName();
    }

    @Override
    public void setup() {
        JButton info = new JButton("Help");
        info.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionUtils.showPermissibleParentsDialog(DefaultModelChooser.this.getSelectedModel(), DefaultModelChooser.this.modelClassesBox, false, false);
            }
        });
        JLabel l1 = new JLabel("Node name: " + this.nodeName);
        l1.setForeground(Color.black);
        this.setLayout(new BorderLayout());
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(l1);
        b2.add(Box.createHorizontalGlue());
        b1.add(b2);
        b1.add(Box.createVerticalStrut(5));
        Box b3 = Box.createHorizontalBox();
        b3.add(this.modelClassesBox);
        Font font = this.modelClassesBox.getFont();
        l1.setFont(font);
        b3.add(Box.createGlue());
        b3.add(info);
        b1.add(b3);
        this.add((Component)b1, "Center");
    }

    private static final class ClassWrapper {
        private final Class wrappedClass;
        private final String name;

        public ClassWrapper(Class wrappedClass, String name) {
            this.wrappedClass = wrappedClass;
            this.name = name;
        }

        public Class getWrappedClass() {
            return this.wrappedClass;
        }

        public String toString() {
            return this.name;
        }
    }
}

