/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.app.SessionEditor;
import edu.cmu.tetradapp.app.SessionEditorWorkbench;
import edu.cmu.tetradapp.app.TetFileFilter;
import edu.cmu.tetradapp.model.EditorUtils;
import edu.cmu.tetradapp.model.SessionWrapper;
import edu.cmu.tetradapp.model.TetradMetadata;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.Version;
import edu.cmu.tetradapp.util.WatchedProcess;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.ObjectInputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

final class LoadSessionAction
extends AbstractAction {
    public LoadSessionAction() {
        super("Open Session...");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Window owner = (Window)JOptionUtils.centeringComp().getTopLevelAncestor();
        new WatchedProcess(owner){

            @Override
            public void watch() {
                JFileChooser chooser = new JFileChooser();
                String sessionSaveLocation = Preferences.userRoot().get("fileSaveLocation", "");
                chooser.setCurrentDirectory(new File(sessionSaveLocation));
                chooser.addChoosableFileFilter(new TetFileFilter());
                chooser.setFileSelectionMode(0);
                int ret1 = chooser.showOpenDialog(JOptionUtils.centeringComp());
                if (ret1 != 0) {
                    return;
                }
                File file = chooser.getSelectedFile();
                if ((file = EditorUtils.ensureSuffix(file, "tet")) == null) {
                    return;
                }
                Preferences.userRoot().put("fileSaveLocation", file.getParent());
                if (DesktopController.getInstance().existsSessionByName(file.getName())) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Cannot open two sessions with the same name.");
                    return;
                }
                try {
                    FileInputStream in = new FileInputStream(file);
                    ObjectInputStream objIn = new ObjectInputStream(in);
                    Object o = objIn.readObject();
                    TetradMetadata metadata = null;
                    SessionWrapper sessionWrapper = null;
                    if (o instanceof TetradMetadata) {
                        metadata = (TetradMetadata)o;
                        try {
                            sessionWrapper = (SessionWrapper)objIn.readObject();
                        }
                        catch (ClassNotFoundException e) {
                            System.out.println("A2");
                            throw e;
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                            sessionWrapper = null;
                        }
                    } else if (o instanceof SessionWrapper) {
                        metadata = null;
                        sessionWrapper = (SessionWrapper)o;
                    }
                    in.close();
                    if (metadata == null) {
                        throw new NullPointerException("Could not read metadata.");
                    }
                    if (sessionWrapper == null) {
                        Version version = metadata.getVersion();
                        Date date = metadata.getDate();
                        SimpleDateFormat df = new SimpleDateFormat("MMM dd, yyyy");
                        JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Could not load session. The version of the session was \n" + version + "; it was saved on " + df.format(date) + ". You " + "\nmight try loading it with that version instead.");
                        return;
                    }
                    SessionEditorWorkbench graph = new SessionEditorWorkbench(sessionWrapper);
                    String name = file.getName();
                    sessionWrapper.setName(name);
                    SessionEditor editor = new SessionEditor(name, graph);
                    DesktopController.getInstance().addSessionEditor(editor);
                    DesktopController.getInstance().closeEmptySessions();
                    DesktopController.getInstance().putMetadata(sessionWrapper, metadata);
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "That file does not exist: " + file);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "An error occurred attempting to load the session.");
                }
            }
        };
    }
}

