/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class NumberFormatAction
extends AbstractAction
implements ClipboardOwner {
    private JTextField formatField = new JTextField(Preferences.userRoot().get("numberFormat", "0.0000"));

    public NumberFormatAction() {
        super("Number Format");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        double sample = 23.5;
        final JTextField renderFieldBasic = new JTextField(new DecimalFormat(this.constructSimpleFormatString()).format(23.5));
        renderFieldBasic.setMaximumSize(new Dimension(150, 50));
        renderFieldBasic.setEditable(false);
        renderFieldBasic.setBackground(Color.WHITE);
        JCheckBox scientific = new JCheckBox("Use scientific notation", Preferences.userRoot().getBoolean("scientificNotation", false));
        scientific.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                Preferences.userRoot().putBoolean("scientificNotation", checkBox.isSelected());
                renderFieldBasic.setText(new DecimalFormat(NumberFormatAction.this.constructSimpleFormatString()).format(23.5));
                NumberFormatAction.this.formatField.setText(NumberFormatAction.this.constructSimpleFormatString());
            }
        });
        SpinnerNumberModel model = new SpinnerNumberModel(Preferences.userRoot().getInt("numDecimals", 4), 0, 300, 1);
        JSpinner numDecimals = new JSpinner(model);
        numDecimals.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSpinner spinner = (JSpinner)e.getSource();
                SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
                int value = (Integer)model.getValue();
                Preferences.userRoot().putInt("numDecimals", value);
                renderFieldBasic.setText(new DecimalFormat(NumberFormatAction.this.constructSimpleFormatString()).format(23.5));
                NumberFormatAction.this.formatField.setText(NumberFormatAction.this.constructSimpleFormatString());
            }
        });
        numDecimals.setMaximumSize(numDecimals.getPreferredSize());
        boolean decimalsOptional = Preferences.userRoot().getBoolean("decimalsOptimal", false);
        JRadioButton optional = new JRadioButton("Optional", decimalsOptional);
        JRadioButton fixed = new JRadioButton("Fixed", !decimalsOptional);
        ButtonGroup group = new ButtonGroup();
        group.add(optional);
        group.add(fixed);
        optional.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.userRoot().putBoolean("decimalsOptional", true);
                renderFieldBasic.setText(new DecimalFormat(NumberFormatAction.this.constructSimpleFormatString()).format(23.5));
                NumberFormatAction.this.formatField.setText(NumberFormatAction.this.constructSimpleFormatString());
            }
        });
        fixed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.userRoot().putBoolean("decimalsOptional", false);
                renderFieldBasic.setText(new DecimalFormat(NumberFormatAction.this.constructSimpleFormatString()).format(23.5));
                NumberFormatAction.this.formatField.setText(NumberFormatAction.this.constructSimpleFormatString());
            }
        });
        if (!Preferences.userRoot().getBoolean("numFormatAdvanced", false)) {
            this.formatField.setText(this.constructSimpleFormatString());
        }
        Box a = Box.createVerticalBox();
        a.setBorder(new TitledBorder("Simple Formats"));
        Box a2 = Box.createHorizontalBox();
        a2.add(scientific);
        a2.add(Box.createHorizontalGlue());
        a.add(a2);
        Box a3 = Box.createHorizontalBox();
        a3.add(new JLabel("Number of decimal places = "));
        a3.add(numDecimals);
        a3.add(Box.createHorizontalGlue());
        a.add(a3);
        Box a4 = Box.createHorizontalBox();
        a4.add(Box.createRigidArea(new Dimension(20, 0)));
        a4.add(optional);
        a4.add(Box.createHorizontalGlue());
        a.add(a4);
        Box a5 = Box.createHorizontalBox();
        a5.add(Box.createRigidArea(new Dimension(20, 0)));
        a5.add(fixed);
        a5.add(Box.createHorizontalGlue());
        a.add(a5);
        a.add(Box.createVerticalStrut(20));
        Box a6 = Box.createHorizontalBox();
        a6.add(new JLabel("Renders as: "));
        a6.add(renderFieldBasic);
        a.add(a6);
        a.add(Box.createVerticalGlue());
        Box basic = Box.createVerticalBox();
        basic.add(a);
        final JPanel basicPanel = new JPanel();
        basicPanel.setLayout(new BorderLayout());
        basicPanel.add((Component)basic, "Center");
        final JTextField sampleFieldAdvanced = new JTextField("23.5");
        final JTextField renderFieldAdvanced = new JTextField(this.getNumberFormat().format(23.5));
        renderFieldAdvanced.setEditable(false);
        renderFieldAdvanced.setBackground(Color.WHITE);
        this.formatField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                NumberFormatAction.this.updateAdvancedFields(sampleFieldAdvanced, renderFieldAdvanced);
            }
        });
        sampleFieldAdvanced.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                NumberFormatAction.this.updateAdvancedFields(sampleFieldAdvanced, renderFieldAdvanced);
            }
        });
        Box z = Box.createVerticalBox();
        Box z1 = Box.createHorizontalBox();
        z1.add(new JLabel("Refer to DecimalFormat in the "));
        z1.add(Box.createHorizontalGlue());
        z.add(z1);
        Box z2 = Box.createHorizontalBox();
        z2.add(new JLabel("documentation for Java."));
        z2.add(Box.createHorizontalGlue());
        z.add(z2);
        z.add(Box.createVerticalStrut(10));
        Box advanced = Box.createVerticalBox();
        advanced.add(z);
        Box f = Box.createVerticalBox();
        f.setBorder(new TitledBorder("Format String"));
        Box f1 = Box.createHorizontalBox();
        f1.add(this.formatField);
        f.add(f1);
        advanced.add(f);
        Box c = Box.createVerticalBox();
        c.setBorder(new TitledBorder("Example"));
        Box c1 = Box.createHorizontalBox();
        c1.add(sampleFieldAdvanced);
        c.add(c1);
        Box c2 = Box.createHorizontalBox();
        c2.add(new JLabel("Renders as: "));
        c2.add(Box.createHorizontalGlue());
        c.add(c2);
        Box c3 = Box.createHorizontalBox();
        c3.add(renderFieldAdvanced);
        c.add(c3);
        advanced.add(c);
        final JPanel advancedPanel = new JPanel();
        advancedPanel.setLayout(new BorderLayout());
        advancedPanel.add((Component)advanced, "Center");
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Basic", basicPanel);
        tabbedPane.addTab("Advanced", advancedPanel);
        if (Preferences.userRoot().getBoolean("numFormatAdvanced", false)) {
            tabbedPane.setSelectedComponent(advancedPanel);
        }
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
                JPanel panel = (JPanel)tabbedPane.getSelectedComponent();
                Preferences.userRoot().putBoolean("numFormatAdvanced", panel == advancedPanel);
                if (panel == basicPanel) {
                    String format = NumberFormatAction.this.constructSimpleFormatString();
                    NumberFormatAction.this.formatField.setText(format);
                    renderFieldBasic.setText(new DecimalFormat(format).format(23.5));
                }
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)tabbedPane, "Center");
        JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), panel, "Formatting for All Real Numbers", 1);
        NumberFormatUtil.getInstance().setNumberFormat(this.getNumberFormat());
    }

    public NumberFormat getNumberFormat() throws IllegalStateException {
        return new DecimalFormat(this.getFormatString());
    }

    public String getFormatString() throws RuntimeException {
        String format = this.formatField.getText();
        try {
            new DecimalFormat(format);
        }
        catch (Exception e) {
            throw new RuntimeException("Illegal format string: " + format);
        }
        return format;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private void updateAdvancedFields(JTextField sampleFieldAdvanced, JTextField renderFieldAdvanced) {
        try {
            Double.parseDouble(sampleFieldAdvanced.getText());
        }
        catch (Exception e1) {
            sampleFieldAdvanced.setForeground(Color.RED);
            return;
        }
        String format = this.formatField.getText();
        try {
            new DecimalFormat(format);
        }
        catch (Exception e2) {
            this.formatField.setForeground(Color.RED);
            return;
        }
        double sample = Double.parseDouble(sampleFieldAdvanced.getText());
        DecimalFormat nf = new DecimalFormat(format);
        renderFieldAdvanced.setText(nf.format(sample));
        sampleFieldAdvanced.setForeground(Color.BLACK);
        this.formatField.setForeground(Color.BLACK);
        Preferences.userRoot().put("numberFormat", format);
    }

    private String constructSimpleFormatString() {
        int i;
        boolean scientificNotation = Preferences.userRoot().getBoolean("scientificNotation", false);
        int numDecimals = Preferences.userRoot().getInt("numDecimals", 4);
        boolean optional = Preferences.userRoot().getBoolean("decimalsOptional", false);
        StringBuilder buf = new StringBuilder();
        buf.append("0.");
        if (optional) {
            for (i = 0; i < numDecimals; ++i) {
                buf.append("#");
            }
        } else {
            for (i = 0; i < numDecimals; ++i) {
                buf.append("0");
            }
        }
        if (scientificNotation) {
            buf.append("E0");
        }
        String formatString = buf.toString();
        Preferences.userRoot().put("numberFormat", formatString);
        return formatString;
    }
}

