/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetradapp.app.SessionEditor;
import edu.cmu.tetradapp.app.SubsessionSelection;
import edu.cmu.tetradapp.model.EditorUtils;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.InternalClipboard;
import edu.cmu.tetradapp.util.SessionEditorIndirectRef;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;

final class PasteSubsessionAction
extends AbstractAction
implements ClipboardOwner {
    public PasteSubsessionAction() {
        super("Paste");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Transferable transferable = InternalClipboard.getInstance().getContents(null);
        if (!(transferable instanceof SubsessionSelection)) {
            return;
        }
        SubsessionSelection selection = (SubsessionSelection)transferable;
        DataFlavor flavor = new DataFlavor(SubsessionSelection.class, "Subsession Selection");
        try {
            List modelList = (List)selection.getTransferData(flavor);
            if (modelList != null) {
                SessionEditorIndirectRef sessionEditorRef = DesktopController.getInstance().getFrontmostSessionEditor();
                SessionEditor sessionEditor = (SessionEditor)sessionEditorRef;
                Point point = EditorUtils.getTopLeftPoint(modelList);
                int numPastes = selection.getNumPastes();
                point.translate(50 * numPastes, 50 * numPastes);
                sessionEditor.pasteSubsession(modelList, point);
            }
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

