/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.app.SaveSessionAsAction;
import edu.cmu.tetradapp.app.SessionEditor;
import edu.cmu.tetradapp.app.SessionEditorWorkbench;
import edu.cmu.tetradapp.model.SessionWrapper;
import edu.cmu.tetradapp.model.TetradMetadata;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.SessionEditorIndirectRef;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

final class SaveSessionAction
extends AbstractAction {
    private boolean saved = false;

    public SaveSessionAction() {
        super("Save Session");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int ret;
        SessionEditorIndirectRef sessionEditorRef = DesktopController.getInstance().getFrontmostSessionEditor();
        SessionEditor sessionEditor = (SessionEditor)sessionEditorRef;
        SessionEditorWorkbench workbench = sessionEditor.getSessionWorkbench();
        SessionWrapper sessionWrapper = workbench.getSessionWrapper();
        TetradMetadata metadata = new TetradMetadata();
        File file = new File(Preferences.userRoot().get("fileSaveLocation", Preferences.userRoot().absolutePath()), sessionWrapper.getName());
        if (!file.exists() || sessionWrapper.isNewSession()) {
            SaveSessionAsAction saveSessionAsAction = new SaveSessionAsAction();
            saveSessionAsAction.actionPerformed(e);
            this.saved = saveSessionAsAction.isSaved();
            return;
        }
        if (file.exists() && (ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "File already exists. Overwrite?", "Save", 0)) == 1) {
            SaveSessionAsAction saveSessionAsAction = new SaveSessionAsAction();
            saveSessionAsAction.actionPerformed(e);
            this.saved = saveSessionAsAction.isSaved();
            return;
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            ObjectOutputStream objOut = new ObjectOutputStream(out);
            sessionWrapper.setNewSession(false);
            objOut.writeObject(metadata);
            objOut.writeObject(sessionWrapper);
            out.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "An error occurred while attempting to save the session as " + file.getAbsolutePath() + ".");
        }
        sessionWrapper.setSessionChanged(false);
        DesktopController.getInstance().putMetadata(sessionWrapper, metadata);
    }

    public boolean isSaved() {
        return this.saved;
    }
}

