/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.model.Params;
import edu.cmu.tetrad.session.CouldNotCreateModelException;
import edu.cmu.tetrad.session.ModificationRegistery;
import edu.cmu.tetrad.session.SessionAdapter;
import edu.cmu.tetrad.session.SessionEvent;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.session.SessionNode;
import edu.cmu.tetrad.session.SimulationStudy;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NamingProtocol;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.TetradLoggerConfig;
import edu.cmu.tetradapp.app.ModelChooser;
import edu.cmu.tetradapp.app.NoteDisplayComp;
import edu.cmu.tetradapp.app.RunSimulationAction;
import edu.cmu.tetradapp.app.SessionDisplayComp;
import edu.cmu.tetradapp.app.SessionEditorWorkbench;
import edu.cmu.tetradapp.app.SessionNodeConfig;
import edu.cmu.tetradapp.app.SessionNodeModelConfig;
import edu.cmu.tetradapp.app.SessionUtils;
import edu.cmu.tetradapp.app.TetradApplicationConfig;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.FinalizingParameterEditor;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.model.BayesDataWrapper;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.DirichletBayesDataWrapper;
import edu.cmu.tetradapp.model.SemDataWrapper;
import edu.cmu.tetradapp.model.SemPmWrapper;
import edu.cmu.tetradapp.model.SessionAppModule;
import edu.cmu.tetradapp.model.SessionNodeWrapper;
import edu.cmu.tetradapp.model.SessionWrapper;
import edu.cmu.tetradapp.model.UnlistedSessionModel;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.IntTextField;
import edu.cmu.tetradapp.util.WatchedProcess;
import edu.cmu.tetradapp.workbench.DisplayNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public final class SessionEditorNode
extends DisplayNode {
    private EditorWindow spawnedEditor;
    private boolean rememberLastClass = false;
    private SimulationStudy simulationStudy;
    private SessionWrapper sessionWrapper;
    private SessionNodeConfig config;

    public SessionEditorNode(SessionNodeWrapper modelNode, SimulationStudy simulationStudy) {
        this.setModelNode(modelNode);
        TetradApplicationConfig appConfig = TetradApplicationConfig.getInstance();
        this.config = appConfig.getSessionNodeConfig(modelNode.getButtonType());
        if (this.config == null) {
            throw new NullPointerException("There is no configuration for node of type: " + modelNode.getButtonType());
        }
        if (simulationStudy == null) {
            throw new NullPointerException("Simulation study must not be null.");
        }
        SessionDisplayComp displayComp = this.config.getSessionDisplayCompInstance();
        String tooltip = this.config.getTooltipText();
        this.simulationStudy = simulationStudy;
        displayComp.setName(modelNode.getSessionName());
        if (displayComp instanceof NoteDisplayComp) {
            this.setDisplayComp(displayComp);
            this.setLayout(new BorderLayout());
            this.add((Component)((JComponent)((Object)this.getSessionDisplayComp())), "Center");
            this.setSelected(false);
            this.setToolTipText(tooltip);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                        toolTipManager.setInitialDelay(750);
                        SessionEditorNode.this.getNotePopup().show(SessionEditorNode.this, e.getX(), e.getY());
                    }
                    e.consume();
                }
            });
        } else {
            this.setDisplayComp(displayComp);
            this.setLayout(new BorderLayout());
            this.add((Component)((JComponent)((Object)this.getSessionDisplayComp())), "Center");
            this.setSelected(false);
            this.createParamObjects(this);
            this.setToolTipText(tooltip);
            SessionEditorNode.addListeners(this, modelNode);
        }
    }

    public final void adjustToModel() {
        String acronym = this.getAcronym();
        if ("No model".equals(acronym)) {
            this.getSessionDisplayComp().setHasModel(false);
        } else {
            this.getSessionDisplayComp().setHasModel(true);
        }
        this.getSessionDisplayComp().setAcronym(acronym);
        this.setSelected(false);
        Dimension size = this.getSize();
        Point location = this.getLocation();
        int centerX = (int)location.getX() + size.width / 2;
        int centerY = (int)location.getY() + size.height / 2;
        int newX = centerX - this.getPreferredSize().width / 2;
        int newY = centerY - this.getPreferredSize().height / 2;
        this.setLocation(newX, newY);
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    private String getAcronym() {
        SessionNodeWrapper modelNode = (SessionNodeWrapper)this.getModelNode();
        SessionNode sessionNode = modelNode.getSessionNode();
        SessionModel model = sessionNode.getModel();
        if (model == null) {
            return "No model";
        }
        Class<?> modelClass = model.getClass();
        SessionNodeModelConfig modelConfig = this.config.getModelConfig(modelClass);
        if (modelConfig == null) {
            System.out.println("Tried to load model config for " + modelClass);
        }
        return modelConfig.getAcronym();
    }

    @Override
    public void doDoubleClickAction() {
        this.doDoubleClickAction(null);
    }

    @Override
    public void doDoubleClickAction(Graph sessionWrapper) {
        this.sessionWrapper = (SessionWrapper)sessionWrapper;
        Window owner = (Window)this.getTopLevelAncestor();
        new WatchedProcess(owner){

            @Override
            public void watch() {
                TetradLogger.getInstance().setTetradLoggerConfig(SessionEditorNode.this.getSessionNode().getLoggerConfig());
                SessionEditorNode.this.launchEditorVisit();
            }
        };
    }

    private void launchEditorVisit() {
        try {
            JPanel editor;
            if (this.spawnedEditor() != null) {
                return;
            }
            boolean created = this.createModel(false);
            if (!created) {
                return;
            }
            boolean cloned = this.getSessionNode().useClonedModel();
            SessionModel model = this.getSessionNode().getModel();
            Class<?> modelClass = model.getClass();
            SessionNodeModelConfig modelConfig = this.config.getModelConfig(modelClass);
            if (model instanceof SessionAppModule) {
                editor = ((SessionAppModule)((Object)model)).newEditor();
            } else {
                Object[] arguments = new Object[]{model};
                editor = modelConfig.getEditorInstance(arguments);
                this.addEditorListener(editor);
            }
            ModificationRegistery.registerEditor(this.getSessionNode(), editor);
            String descrip = modelConfig.getName();
            editor.setName(this.getName() + " (" + descrip + ")");
            EditorWindow editorWindow = new EditorWindow(editor, editor.getName(), "Save", cloned, this);
            editorWindow.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent e) {
                    if (SessionEditorNode.this.getChildren().iterator().hasNext()) {
                        SessionEditorNode.this.finishedEditingDialog();
                    }
                    ModificationRegistery.unregisterSessionNode(SessionEditorNode.this.getSessionNode());
                    SessionEditorNode.this.setSpawnedEditor(null);
                    EditorWindow window = (EditorWindow)e.getSource();
                    if (window.isCanceled()) {
                        SessionEditorNode.this.getSessionNode().restoreOriginalModel();
                    }
                    SessionEditorNode.this.getSessionNode().forgetSavedModel();
                }
            });
            DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
            editorWindow.pack();
            editorWindow.setVisible(true);
            this.spawnedEditor = editorWindow;
            if (this.sessionWrapper != null) {
                this.sessionWrapper.setSessionChanged(true);
            }
        }
        catch (CouldNotCreateModelException e) {
            SessionUtils.showPermissibleParentsDialog(e.getModelClass(), this, true, true);
            e.printStackTrace();
        }
        catch (ClassCastException e) {
        }
        catch (Exception e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            SessionEditorNode centeringComp = this;
            String s = cause.getMessage();
            if (!"".equals(s)) {
                JOptionPane.showMessageDialog(centeringComp, s, null, 2);
            }
            e.printStackTrace();
        }
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.getSessionDisplayComp().setSelected(selected);
    }

    private static void addListeners(final SessionEditorNode sessionEditorNode, SessionNodeWrapper modelNode) {
        sessionEditorNode.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                    toolTipManager.setInitialDelay(750);
                    sessionEditorNode.getPopup().show(sessionEditorNode, e.getX(), e.getY());
                }
                e.consume();
            }
        });
        sessionEditorNode.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                sessionEditorNode.getSimulationStudy().getSession().setSessionChanged(true);
            }
        });
        SessionNode sessionNode = modelNode.getSessionNode();
        sessionNode.addSessionListener(new SessionAdapter(){

            @Override
            public void modelCreated(SessionEvent sessionEvent) {
                sessionEditorNode.adjustToModel();
                if (sessionEditorNode.spawnedEditor() != null) {
                    EditorWindow editorWindow = sessionEditorNode.spawnedEditor();
                    editorWindow.closeDialog();
                }
            }

            @Override
            public void modelDestroyed(SessionEvent sessionEvent) {
                sessionEditorNode.adjustToModel();
                if (sessionEditorNode.spawnedEditor() != null) {
                    EditorWindow editorWindow = sessionEditorNode.spawnedEditor();
                    editorWindow.closeDialog();
                }
            }

            @Override
            public void modelUnclear(SessionEvent sessionEvent) {
                try {
                    boolean created = sessionEditorNode.createModel(false);
                    if (!created) {
                        return;
                    }
                    sessionEditorNode.adjustToModel();
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    if (message == null || message.length() == 0) {
                        message = "Could not make a model for this box.";
                    }
                    JOptionPane.showMessageDialog(sessionEditorNode, message);
                    e.printStackTrace();
                }
            }
        });
    }

    private void addEditorListener(JPanel editor) {
        editor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("changeNodeLabel".equals(evt.getPropertyName())) {
                    SessionEditorNode.this.getDisplayComp().setName((String)evt.getNewValue());
                    SessionNodeWrapper wrapper = (SessionNodeWrapper)SessionEditorNode.this.getModelNode();
                    wrapper.setSessionName((String)evt.getNewValue());
                    SessionEditorNode.this.adjustToModel();
                }
            }
        });
    }

    private JPopupMenu getNotePopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem renameBox = new JMenuItem("Rename note");
        renameBox.setToolTipText("<html>Renames this note.</html>");
        renameBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionEditorNode centeringComp = SessionEditorNode.this;
                String name = JOptionPane.showInputDialog(centeringComp, (Object)"New name:");
                if (!NamingProtocol.isLegalName(name)) {
                    JOptionPane.showMessageDialog(centeringComp, NamingProtocol.getProtocolDescription());
                    return;
                }
                SessionNodeWrapper wrapper = (SessionNodeWrapper)SessionEditorNode.this.getModelNode();
                wrapper.setSessionName(name);
                SessionEditorNode.this.getSessionDisplayComp().setName(name);
                SessionEditorNode.this.adjustToModel();
            }
        });
        JMenuItem cloneBox = new JMenuItem("Clone Note");
        cloneBox.setToolTipText("<html>Makes a copy of this session note and its contents. To clone<br>a whole subgraph, or to paste into a different sessions, select<br>the subgraph and use the Copy/Paste gadgets in the Edit menu.</html>");
        cloneBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionEditorNode.this.firePropertyChange("cloneMe", null, SessionEditorNode.this);
            }
        });
        JMenuItem deleteBox = new JMenuItem("Delete Note");
        deleteBox.setToolTipText("<html>Deletes this note from the workbench</html>");
        deleteBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionEditorNode centeringComp;
                int ret;
                if (SessionEditorNode.this.getSessionNode().getModel() == null ? (ret = JOptionPane.showConfirmDialog(centeringComp = SessionEditorNode.this, "Really delete note?")) != 0 : (ret = JOptionPane.showConfirmDialog(centeringComp = SessionEditorNode.this, "<html>Really delete note? Any information it contains will<br>be destroyed.</html>")) != 0) {
                    return;
                }
                SessionEditorNode.this.firePropertyChange("deleteNode", null, null);
            }
        });
        JMenuItem help = new JMenuItem("Help");
        deleteBox.setToolTipText("<html>Shows help for this box.</html>");
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionNodeWrapper sessionNodeWrapper = (SessionNodeWrapper)SessionEditorNode.this.getModelNode();
                SessionNode sessionNode = sessionNodeWrapper.getSessionNode();
                SessionEditorNode.this.showInfoBoxForModel(sessionNode, sessionNode.getModelClasses());
            }
        });
        popup.add(renameBox);
        popup.add(cloneBox);
        popup.add(deleteBox);
        popup.addSeparator();
        popup.add(help);
        return popup;
    }

    private JPopupMenu getPopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem createModel = new JMenuItem("Create Model");
        createModel.setToolTipText("<html>Creates a new model for this node<br>of the type selected.</html>");
        createModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (SessionEditorNode.this.getSessionNode().getModel() == null) {
                        SessionEditorNode.this.createModel(false);
                    } else {
                        SessionEditorNode centeringComp = SessionEditorNode.this;
                        JOptionPane.showMessageDialog(centeringComp, "Please destroy the current model first.");
                    }
                }
                catch (Exception e1) {
                    SessionEditorNode centeringComp = SessionEditorNode.this;
                    JOptionPane.showMessageDialog(centeringComp, "Could not create a model for this box.");
                    e1.printStackTrace();
                }
            }
        });
        JMenuItem editModel = new JMenuItem("Edit Model");
        editModel.setToolTipText("<html>Edits the model in this node.</html>");
        editModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (SessionEditorNode.this.getSessionNode().getModel() == null) {
                        SessionEditorNode centeringComp = SessionEditorNode.this;
                        JOptionPane.showMessageDialog(centeringComp, "No model has been created yet.");
                    } else {
                        SessionEditorNode.this.doDoubleClickAction();
                    }
                }
                catch (Exception e1) {
                    SessionEditorNode centeringComp = SessionEditorNode.this;
                    JOptionPane.showMessageDialog(centeringComp, "Double click failed. See console for exception.");
                    e1.printStackTrace();
                }
            }
        });
        JMenuItem destroyModel = new JMenuItem("Destroy Model");
        destroyModel.setToolTipText("<html>Destroys the model for this node, <br>if it has one, destroying any <br>downstream models as well.</html>");
        destroyModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionEditorNode centeringComp = SessionEditorNode.this;
                if (SessionEditorNode.this.getSessionNode().getModel() == null) {
                    JOptionPane.showMessageDialog(centeringComp, "This box does not contain a model.");
                    return;
                }
                int ret = JOptionPane.showConfirmDialog(centeringComp, "Really destroy model in box? This will destroy models downstream as well.", "Confirm", 2, 2);
                if (ret != 0) {
                    return;
                }
                SessionEditorNode.this.destroyModel();
            }
        });
        JMenuItem propagateDownstream = new JMenuItem("Propagate changes downstream");
        propagateDownstream.setToolTipText("<html>Fills in this box and downstream boxes with models,<br>overwriting any models that already exist.</html>");
        propagateDownstream.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionEditorNode centeringComp = SessionEditorNode.this;
                if (SessionEditorNode.this.getSessionNode().getModel() != null && !SessionEditorNode.this.getSessionNode().getChildren().isEmpty()) {
                    int ret = JOptionPane.showConfirmDialog(centeringComp, "You will be rewriting all downstream models. Is that OK?", "Confirm", 2, 2);
                    if (ret != 0) {
                        return;
                    }
                    ret = JOptionPane.showConfirmDialog(centeringComp, "Please confirm once more.", "Confirm", 2, 2);
                    if (ret != 0) {
                        return;
                    }
                }
                try {
                    SessionEditorNode.this.createDescendantModels(true);
                }
                catch (RuntimeException e1) {
                    JOptionPane.showMessageDialog(centeringComp, "Could not complete the creation of descendant models.");
                    e1.printStackTrace();
                }
            }
        });
        JMenuItem renameBox = new JMenuItem("Rename Box");
        renameBox.setToolTipText("<html>Renames this session box.</html>");
        renameBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionEditorNode centeringComp = SessionEditorNode.this;
                String name = JOptionPane.showInputDialog(centeringComp, (Object)"New name:");
                if (!NamingProtocol.isLegalName(name)) {
                    JOptionPane.showMessageDialog(centeringComp, NamingProtocol.getProtocolDescription());
                    return;
                }
                SessionNodeWrapper wrapper = (SessionNodeWrapper)SessionEditorNode.this.getModelNode();
                wrapper.setSessionName(name);
                SessionEditorNode.this.getSessionDisplayComp().setName(name);
                SessionEditorNode.this.adjustToModel();
            }
        });
        JMenuItem cloneBox = new JMenuItem("Clone Box");
        cloneBox.setToolTipText("<html>Makes a copy of this session box and its contents. To clone<br>a whole subgraph, or to paste into a different sessions, select<br>the subgraph and use the Copy/Paste gadgets in the Edit menu.</html>");
        cloneBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionEditorNode.this.firePropertyChange("cloneMe", null, SessionEditorNode.this);
            }
        });
        JMenuItem deleteBox = new JMenuItem("Delete Box");
        deleteBox.setToolTipText("<html>Deletes this box from the workbench</html>");
        deleteBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionEditorNode centeringComp;
                int ret;
                if (SessionEditorNode.this.getSessionNode().getModel() == null ? (ret = JOptionPane.showConfirmDialog(centeringComp = SessionEditorNode.this, "Really delete box?")) != 0 : (ret = JOptionPane.showConfirmDialog(centeringComp = SessionEditorNode.this, "<html>Really delete box? Any information it contains will<br>be destroyed.</html>")) != 0) {
                    return;
                }
                SessionEditorNode.this.firePropertyChange("deleteNode", null, null);
            }
        });
        JMenuItem help = new JMenuItem("Help");
        deleteBox.setToolTipText("<html>Shows help for this box.</html>");
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionNodeWrapper sessionNodeWrapper = (SessionNodeWrapper)SessionEditorNode.this.getModelNode();
                SessionNode sessionNode = sessionNodeWrapper.getSessionNode();
                SessionEditorNode.this.showInfoBoxForModel(sessionNode, sessionNode.getModelClasses());
            }
        });
        JMenuItem setRepetition = new JMenuItem("Set Repeat...");
        setRepetition.setToolTipText("<html>Sets the number of times this node <br>will be repeated when executing,<br>at each depth first traversal of the<br>node. Useful for simulation studies.</html>");
        setRepetition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionEditorNode.this.editRepetition();
            }
        });
        JMenuItem editSimulationParameters = new JMenuItem("Edit Default Parameters...");
        editSimulationParameters.setToolTipText("<html>");
        editSimulationParameters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionModel model = SessionEditorNode.this.getSessionNode().getModel();
                Class modelClass = model == null ? SessionEditorNode.this.determineTheModelClass(SessionEditorNode.this.getSessionNode()) : model.getClass();
                if (!SessionEditorNode.this.getSessionNode().existsParameterizedConstructor(modelClass)) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "There is no parameterization for this model.");
                    return;
                }
                Params param = SessionEditorNode.this.getSessionNode().getParam(modelClass);
                Object[] arguments = SessionEditorNode.this.getSessionNode().getModelConstructorArguments(modelClass);
                if (param != null) {
                    try {
                        SessionEditorNode.this.editParameters(modelClass, param, arguments);
                        SessionEditorNode.this.getSessionNode().destroyModel();
                        SessionEditorNode.this.getSessionNode().createModel(modelClass, true);
                        SessionEditorNode.this.doDoubleClickAction(SessionEditorNode.this.getSessionWrapper());
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        JMenuItem simulate = new JMenuItem(new RunSimulationAction(this));
        simulate.setToolTipText("<html>Runs a simulation study, visiting <br>nodes downstream recursively in depth first<br>order (with repetitions as noted), writing<br>output to a log file.</html>");
        popup.add(createModel);
        popup.add(editModel);
        popup.add(destroyModel);
        popup.addSeparator();
        popup.add(renameBox);
        popup.add(cloneBox);
        popup.add(deleteBox);
        popup.addSeparator();
        popup.add(editSimulationParameters);
        this.addEditLoggerSettings(popup);
        popup.add(propagateDownstream);
        popup.addSeparator();
        popup.add(setRepetition);
        popup.add(simulate);
        popup.addSeparator();
        popup.add(help);
        return popup;
    }

    private void addEditLoggerSettings(JPopupMenu menu) {
        SessionNodeWrapper modelNode = (SessionNodeWrapper)this.getModelNode();
        SessionNode sessionNode = modelNode.getSessionNode();
        SessionModel model = sessionNode.getModel();
        final TetradLoggerConfig config = sessionNode.getLoggerConfig();
        if (config != null) {
            JMenuItem item = new JMenuItem("Edit Logger Settings ...");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionEditorNode.this.showLogConfig(config);
                }
            });
            menu.add(item);
        }
    }

    private void showLogConfig(final TetradLoggerConfig config) {
        List<TetradLoggerConfig.Event> events = config.getSupportedEvents();
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(3, events.size() / 3));
        for (TetradLoggerConfig.Event event : events) {
            final String id = event.getId();
            JCheckBox checkBox = new JCheckBox(event.getDescription());
            checkBox.setHorizontalTextPosition(4);
            checkBox.setSelected(config.isEventActive(id));
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBox box = (JCheckBox)e.getSource();
                    config.setEventActive(id, box.isSelected());
                }
            });
            panel.add(checkBox);
        }
        panel.setBorder(new TitledBorder("Select Events to Log"));
        JOptionPane.showMessageDialog(this, panel, "Edit Events to Log", -1);
    }

    private void executeSessionNode(final SessionNode sessionNode, final boolean overwrite) {
        Window owner = (Window)this.getTopLevelAncestor();
        new WatchedProcess(owner){

            @Override
            public void watch() {
                Class<SessionEditorWorkbench> c = SessionEditorWorkbench.class;
                Container container = SwingUtilities.getAncestorOfClass(c, SessionEditorNode.this);
                SessionEditorWorkbench workbench = (SessionEditorWorkbench)container;
                System.out.println("Executing" + sessionNode);
                workbench.getSimulationStudy().execute(sessionNode, overwrite);
            }
        };
    }

    private void createDescendantModels(final boolean overwrite) {
        Window owner = (Window)this.getTopLevelAncestor();
        new WatchedProcess(owner){

            @Override
            public void watch() {
                Class<SessionEditorWorkbench> clazz = SessionEditorWorkbench.class;
                Container container = SwingUtilities.getAncestorOfClass(clazz, SessionEditorNode.this);
                SessionEditorWorkbench workbench = (SessionEditorWorkbench)container;
                if (workbench != null) {
                    workbench.getSimulationStudy().createDescendantModels(SessionEditorNode.this.getSessionNode(), overwrite);
                }
            }
        };
    }

    private void finishedEditingDialog() {
        block6: {
            int selection;
            block5: {
                if (!ModificationRegistery.modelHasChanged(this.getSessionNode())) {
                    return;
                }
                for (SessionNode child : this.getChildren()) {
                    if (child.getModel() != null) continue;
                    return;
                }
                SessionEditorNode centeringComp = this;
                Object[] options = new Object[]{"Execute", "Break Edges"};
                selection = JOptionPane.showOptionDialog(centeringComp, "Changing this node will affect its children.\nClick on \"Execute\" to percolate changes down.\nClick on \"Break Edges\" to leave the children the same.", "Warning", -1, 2, null, options, options[0]);
                if (selection != 0) break block5;
                for (SessionNode child : this.getChildren()) {
                    boolean overwrite = true;
                    this.executeSessionNode(child, overwrite);
                }
                break block6;
            }
            if (selection != 1) break block6;
            for (Edge edge : this.sessionWrapper.getEdges(this.getModelNode())) {
                SessionNode other;
                SessionNodeWrapper otherWrapper;
                if (edge.getNode2() == this.getModelNode()) {
                    otherWrapper = (SessionNodeWrapper)edge.getNode1();
                    other = otherWrapper.getSessionNode();
                    if (!this.getChildren().contains(other)) continue;
                    this.sessionWrapper.removeEdge(edge);
                    continue;
                }
                otherWrapper = (SessionNodeWrapper)edge.getNode2();
                other = otherWrapper.getSessionNode();
                if (!this.getChildren().contains(other)) continue;
                this.sessionWrapper.removeEdge(edge);
            }
        }
    }

    private void editRepetition() {
        SessionNodeWrapper wrapper = (SessionNodeWrapper)this.getModelNode();
        RepetitionEditor repetitionEditor = new RepetitionEditor(this, wrapper);
        SessionEditorNode centeringComp = this;
        JOptionPane.showOptionDialog(centeringComp, repetitionEditor, "Repetition Editor", 0, 3, null, new String[]{"OK", "Cancel"}, "OK");
    }

    private boolean createModel(boolean simulation) throws Exception {
        if (this.getSessionNode().getModel() != null) {
            return true;
        }
        SessionNode sessionNode = this.getSessionNode();
        Class modelClass = this.determineTheModelClass(sessionNode);
        if (modelClass == null) {
            return false;
        }
        if (sessionNode.existsParameterizedConstructor(modelClass)) {
            boolean edited;
            Params params = sessionNode.getParam(modelClass);
            Object[] arguments = sessionNode.getModelConstructorArguments(modelClass);
            if (params != null && !(edited = this.editParameters(modelClass, params, arguments))) {
                return false;
            }
        }
        sessionNode.createModel(modelClass, simulation);
        return true;
    }

    private Class determineTheModelClass(SessionNode sessionNode) {
        Class[] modelClasses;
        Class[] classArray;
        SessionEditorNode.loadModelClassesFromConfig(sessionNode);
        if (this.rememberLastClass) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = sessionNode.getLastModelClass();
        } else {
            classArray = modelClasses = sessionNode.getConsistentModelClasses();
        }
        if (modelClasses == null || modelClasses.length == 0) {
            return null;
        }
        return modelClasses.length > 1 ? this.getModelClassFromUser(modelClasses, true) : modelClasses[0];
    }

    private Class getModelClassFromUser(Class[] modelClasses, boolean cancelable) {
        LinkedList<Class> reducedList = new LinkedList<Class>();
        for (Class modelClass : modelClasses) {
            if (UnlistedSessionModel.class.isAssignableFrom(modelClass)) continue;
            reducedList.add(modelClass);
        }
        if (reducedList.size() == 0) {
            throw new RuntimeException("There is no model to choose.");
        }
        SessionNodeWrapper sessionNodeWrapper = (SessionNodeWrapper)this.getModelNode();
        SessionNode sessionNode = sessionNodeWrapper.getSessionNode();
        ModelChooser chooser = this.config.getModelChooserInstance(sessionNode);
        SessionEditorNode centeringComp = this;
        if (cancelable) {
            int selection = JOptionPane.showOptionDialog(centeringComp, chooser, chooser.getTitle(), 2, -1, null, new String[]{"OK", "Cancel"}, "OK");
            if (selection == 0) {
                return chooser.getSelectedModel();
            }
            return null;
        }
        JOptionPane.showOptionDialog(centeringComp, chooser, chooser.getTitle(), 0, 3, null, new String[]{"OK"}, "OK");
        return chooser.getSelectedModel();
    }

    private Class showInfoBoxForModel(SessionNode sessionNode, Class[] modelClasses) {
        LinkedList<Class> reducedList = new LinkedList<Class>();
        for (Class modelClass : modelClasses) {
            if (UnlistedSessionModel.class.isAssignableFrom(modelClass)) continue;
            reducedList.add(modelClass);
        }
        if (reducedList.size() == 0) {
            throw new RuntimeException("There is no model to choose.");
        }
        SessionNodeWrapper nodeWrapper = (SessionNodeWrapper)this.getModelNode();
        String buttonType = nodeWrapper.getButtonType();
        ModelChooser chooser = this.config.getModelChooserInstance(sessionNode);
        SessionEditorNode centeringComp = this;
        JOptionPane.showMessageDialog(centeringComp, chooser, "Choose Model for Help...", 3);
        return chooser.getSelectedModel();
    }

    private String missingParentsMessage() {
        Set<SessionNode> parents = this.getParents();
        for (SessionNode parent3 : parents) {
            SessionNode parent = parent3;
            if (parent.getModel() != null) continue;
            return "Please fill in all the parent boxes first.";
        }
        if (parents.size() == 2) {
            Iterator<SessionNode> i = parents.iterator();
            SessionModel parent1 = i.next().getModel();
            SessionModel parent2 = i.next().getModel();
            if (parent1 instanceof SemPmWrapper && parent2 instanceof BayesDataWrapper || parent2 instanceof SemPmWrapper && parent1 instanceof BayesDataWrapper || parent2 instanceof SemPmWrapper && parent1 instanceof DirichletBayesDataWrapper) {
                return "Sem PM incompatible with discrete data.";
            }
            if (parent1 instanceof BayesPmWrapper && parent2 instanceof SemDataWrapper || parent2 instanceof BayesPmWrapper && parent1 instanceof SemDataWrapper) {
                return "Bayes PM incompatible with continuous data.";
            }
        }
        return "There are no consistent models for that set of parents.";
    }

    private Set<SessionNode> getParents() {
        SessionNodeWrapper _sessionNodeWrapper = (SessionNodeWrapper)this.getModelNode();
        SessionNode _sessionNode = _sessionNodeWrapper.getSessionNode();
        return _sessionNode.getParents();
    }

    public Set<SessionNode> getChildren() {
        SessionNodeWrapper _sessionNodeWrapper = (SessionNodeWrapper)this.getModelNode();
        SessionNode _sessionNode = _sessionNodeWrapper.getSessionNode();
        return _sessionNode.getChildren();
    }

    private static void loadModelClassesFromConfig(SessionNode sessionNode) {
        String nodeName = sessionNode.getBoxType();
        if (nodeName != null) {
            String baseName = SessionEditorNode.extractBase(nodeName);
            Class[] newModelClasses = SessionEditorNode.modelClasses(baseName);
            if (newModelClasses != null) {
                sessionNode.setModelClasses(newModelClasses);
            } else {
                throw new RuntimeException("Model classes for this session node were not set in the configuration.");
            }
        }
    }

    private void destroyModel() {
        this.getSessionNode().destroyModel();
        this.getSessionNode().forgetOldModel();
    }

    private boolean editParameters(Class modelClass, Params params, Object[] parentModels) throws Exception {
        if (parentModels == null) {
            throw new NullPointerException("Parent models array is null.");
        }
        if (params == null) {
            throw new NullPointerException("Params cannot be null.");
        }
        SessionNodeModelConfig modelConfig = this.config.getModelConfig(modelClass);
        ParameterEditor paramEditor = modelConfig.getParameterEditorInstance();
        if (paramEditor == null) {
            return true;
        }
        paramEditor.setParams(params);
        paramEditor.setParentModels(parentModels);
        if (paramEditor instanceof FinalizingParameterEditor && paramEditor instanceof JDialog) {
            FinalizingParameterEditor e = (FinalizingParameterEditor)paramEditor;
            e.setup();
            return e.finalizeEdit();
        }
        paramEditor.setup();
        JComponent editor = (JComponent)((Object)paramEditor);
        SessionNodeWrapper nodeWrapper = (SessionNodeWrapper)this.getModelNode();
        String buttonType = nodeWrapper.getButtonType();
        editor.setName(buttonType + " Structure Editor");
        SessionEditorNode centeringComp = this;
        int ret = JOptionPane.showOptionDialog(centeringComp, editor, editor.getName(), 2, -1, null, null, null);
        if (ret == 0) {
            if (paramEditor instanceof FinalizingParameterEditor) {
                return ((FinalizingParameterEditor)paramEditor).finalizeEdit();
            }
            return true;
        }
        return false;
    }

    public SessionNode getSessionNode() {
        SessionNodeWrapper wrapper = (SessionNodeWrapper)super.getModelNode();
        return wrapper.getSessionNode();
    }

    private void setSpawnedEditor(EditorWindow editorWindow) {
        this.spawnedEditor = editorWindow;
    }

    private EditorWindow spawnedEditor() {
        return this.spawnedEditor;
    }

    private void createParamObjects(SessionEditorNode sessionEditorNode) {
        Class[] modelClasses;
        SessionNode sessionNode = sessionEditorNode.getSessionNode();
        for (Class clazz : modelClasses = sessionNode.getModelClasses()) {
            Params param;
            SessionNodeModelConfig modelConfig;
            if (sessionNode.getParam(clazz) != null || (modelConfig = this.config.getModelConfig(clazz)) == null || (param = modelConfig.getParametersInstance()) == null) continue;
            sessionNode.putParam(clazz, param);
        }
    }

    private static String extractBase(String name) {
        if (name == null) {
            throw new NullPointerException("Name must not be null.");
        }
        StringBuilder buffer = new StringBuilder(name);
        for (int i = buffer.length() - 1; i >= 0; --i) {
            if (Character.isDigit(buffer.charAt(i))) continue;
            return buffer.substring(0, i + 1);
        }
        return "Node";
    }

    private static Class[] modelClasses(String boxType) {
        TetradApplicationConfig config = TetradApplicationConfig.getInstance();
        SessionNodeConfig nodeConfig = config.getSessionNodeConfig(boxType);
        if (nodeConfig == null) {
            throw new NullPointerException("THere is no configuration for " + boxType);
        }
        return nodeConfig.getModels();
    }

    private SimulationStudy getSimulationStudy() {
        return this.simulationStudy;
    }

    private SessionWrapper getSessionWrapper() {
        return this.sessionWrapper;
    }

    public SessionDisplayComp getSessionDisplayComp() {
        return (SessionDisplayComp)this.getDisplayComp();
    }

    private static final class RepetitionEditor
    extends JComponent {
        private final SessionEditorNode editorNode;
        private final SessionNodeWrapper wrapper;

        public RepetitionEditor(SessionEditorNode editorNode, SessionNodeWrapper wrapper) {
            this.editorNode = editorNode;
            this.wrapper = wrapper;
            IntTextField repetitionField = new IntTextField(this.getRepetition(), 6);
            repetitionField.setFilter(new IntTextField.Filter(){

                @Override
                public int filter(int value, int oldValue) {
                    try {
                        RepetitionEditor.this.setRepetition(value);
                        return value;
                    }
                    catch (Exception e) {
                        return oldValue;
                    }
                }
            });
            this.setLayout(new BorderLayout());
            Box b0 = Box.createVerticalBox();
            Box b1 = Box.createHorizontalBox();
            b1.add(new JLabel("Set the number of times this node should be"));
            b1.add(Box.createHorizontalGlue());
            b0.add(b1);
            Box b2 = Box.createHorizontalBox();
            b2.add(new JLabel("repeated each time it is encounted in a depth first"));
            b2.add(Box.createHorizontalGlue());
            b0.add(b2);
            Box b3 = Box.createHorizontalBox();
            b3.add(new JLabel("traversal of the nodes:"));
            b3.add(Box.createHorizontalGlue());
            b3.add(repetitionField);
            b0.add(b3);
            this.add((Component)b0, "Center");
        }

        private void setRepetition(int value) {
            this.simulationStudy().setRepetition(this.getSessionNode(), value);
        }

        private int getRepetition() {
            this.simulationStudy();
            return SimulationStudy.getRepetition(this.getSessionNode());
        }

        public SessionNodeWrapper getWrapper() {
            return this.wrapper;
        }

        public SessionEditorNode getEditorNode() {
            return this.editorNode;
        }

        public SessionNode getSessionNode() {
            return this.wrapper.getSessionNode();
        }

        private SimulationStudy simulationStudy() {
            return this.editorNode.getSimulationStudy();
        }
    }
}

