/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

final class WindowMenuListener
implements MenuListener,
ActionListener {
    private JMenu windowMenu;
    private JDesktopPane desktopPane;
    private Hashtable itemsToFrames;

    public WindowMenuListener(JMenu windowMenu, JDesktopPane desktopPane) {
        if (windowMenu == null) {
            throw new NullPointerException("Window menu must not be null.");
        }
        if (desktopPane == null) {
            throw new NullPointerException("Desktop pane must not be null.");
        }
        this.windowMenu = windowMenu;
        this.desktopPane = desktopPane;
        this.itemsToFrames = new Hashtable();
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this.windowMenu.removeAll();
        this.itemsToFrames.clear();
        JInternalFrame[] layer0Frames = this.desktopPane.getAllFramesInLayer(0);
        ArrayList<String> titles = new ArrayList<String>();
        HashMap<String, JInternalFrame> titlesToFrames = new HashMap<String, JInternalFrame>();
        for (JInternalFrame layer0Frame : layer0Frames) {
            String title = layer0Frame.getTitle();
            title = title == null || title.equals("") ? "[untitled]" : title;
            titles.add(title);
            titlesToFrames.put(title, layer0Frame);
        }
        Collections.sort(titles);
        for (Object e2 : titles) {
            String title = (String)e2;
            JMenuItem item = new JMenuItem(title);
            this.windowMenu.add(item);
            item.addActionListener(this);
            this.itemsToFrames.put(item, titlesToFrames.get(title));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        System.out.println(e.getActionCommand());
        Object item = e.getSource();
        JInternalFrame frame = (JInternalFrame)this.itemsToFrames.get(item);
        frame.moveToFront();
    }

    public String toString() {
        return "Some WindowMenuListener.";
    }
}

