/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.model.Params;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.model.BayesDataParams;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public final class BayesDataParamsEditor
extends JPanel
implements ParameterEditor {
    private BayesDataParams params;

    @Override
    public void setParams(Params params) {
        this.params = (BayesDataParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
    }

    @Override
    public void setup() {
        IntTextField sampleSizeField = new IntTextField(this.getParams().getSampleSize(), 8);
        sampleSizeField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    BayesDataParamsEditor.this.getParams().setSampleSize(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        JCheckBox latentDataSaved = new JCheckBox("Include Latent Variables", this.getParams().isLatentDataSaved());
        latentDataSaved.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                BayesDataParamsEditor.this.params.setLatentDataSaved(checkBox.isSelected());
                Preferences.userRoot().putBoolean("latentDataSaved", checkBox.isSelected());
            }
        });
        this.setLayout(new BorderLayout());
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Sample size:  "));
        b1.add(Box.createHorizontalGlue());
        b1.add(sampleSizeField);
        b.add(b1);
        Box b2 = Box.createHorizontalBox();
        b2.add(latentDataSaved);
        b.add(b2);
        this.add((Component)b, "Center");
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    @Override
    public boolean mustBeShown() {
        return true;
    }

    private synchronized BayesDataParams getParams() {
        return this.params;
    }
}

