/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.session.DelegatesEditing;
import edu.cmu.tetradapp.editor.BayesPmEditorWizard;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class BayesPmEditor
extends JPanel
implements PropertyChangeListener,
DelegatesEditing {
    private boolean editingMeasuredVariablesAllowed = true;
    private boolean editingLatentVariablesAllowed = true;
    private BayesPmEditorWizard wizard;

    public BayesPmEditor(BayesPmWrapper bayesPmWrapper) {
        this(bayesPmWrapper.getBayesPm());
    }

    public BayesPmEditor(BayesPm bayesPm) {
        this.setLayout(new BorderLayout());
        Dag graph = bayesPm.getDag();
        GraphWorkbench workbench = new GraphWorkbench(graph);
        BayesPmEditorWizard wizard = new BayesPmEditorWizard(bayesPm, workbench);
        JScrollPane workbenchScroll = new JScrollPane(workbench);
        JScrollPane wizardScroll = new JScrollPane(wizard);
        workbenchScroll.setPreferredSize(new Dimension(450, 450));
        wizardScroll.setPreferredSize(new Dimension(450, 450));
        JSplitPane splitPane = new JSplitPane(1, workbenchScroll, wizardScroll);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(workbenchScroll.getPreferredSize().width);
        this.add((Component)splitPane, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        file.add(new SaveComponentImage(workbench, "Save Graph Image..."));
        this.add((Component)menuBar, "North");
        this.setName("Bayes PM Editor");
        wizard.addPropertyChangeListener(this);
        wizard.setEditingLatentVariablesAllowed(this.isEditingLatentVariablesAllowed());
        wizard.setEditingMeasuredVariablesAllowed(this.isEditingMeasuredVariablesAllowed());
        this.wizard = wizard;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("editorClosing".equals(e.getPropertyName())) {
            this.firePropertyChange("editorClosing", null, this.getName());
        }
        if ("closeFrame".equals(e.getPropertyName())) {
            this.firePropertyChange("closeFrame", null, null);
        }
        if ("modelChanged".equals(e.getPropertyName())) {
            this.firePropertyChange("modelChanged", e.getOldValue(), e.getNewValue());
        }
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    @Override
    public JComponent getEditDelegate() {
        return this.wizard;
    }

    public boolean isEditingMeasuredVariablesAllowed() {
        return this.editingMeasuredVariablesAllowed;
    }

    public void setEditingMeasuredVariablesAllowed(boolean editingMeasuredVariablesAllowed) {
        this.editingMeasuredVariablesAllowed = editingMeasuredVariablesAllowed;
        this.wizard.setEditingMeasuredVariablesAllowed(this.isEditingMeasuredVariablesAllowed());
    }

    public boolean isEditingLatentVariablesAllowed() {
        return this.editingLatentVariablesAllowed;
    }

    public void setEditingLatentVariablesAllowed(boolean editingLatentVariablesAllowed) {
        this.editingLatentVariablesAllowed = editingLatentVariablesAllowed;
        this.wizard.setEditingLatentVariablesAllowed(this.isEditingLatentVariablesAllowed());
    }
}

