/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.search.TestType;
import edu.cmu.tetradapp.model.BuildPureClustersIndTestParams;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

class BuildPureClustersIndTestParamsEditor
extends JComponent {
    private BuildPureClustersIndTestParams paramsPureClusters;

    public BuildPureClustersIndTestParamsEditor(BuildPureClustersIndTestParams paramsPureClusters, boolean discreteData) {
        this.paramsPureClusters = paramsPureClusters;
        DoubleTextField alphaField = new DoubleTextField(this.getParams().getAlpha(), 8, new DecimalFormat("0.0########"));
        alphaField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    BuildPureClustersIndTestParamsEditor.this.getParams().setAlpha(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        JComboBox<TestType> testSelector = null;
        JComboBox<TestType> purifySelector = null;
        if (!discreteData) {
            TestType[] descriptions = TestType.getTestDescriptions();
            testSelector = new JComboBox<TestType>(descriptions);
            testSelector.setSelectedItem(this.getParams().getTetradTestType());
            testSelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComboBox combo = (JComboBox)e.getSource();
                    TestType index = (TestType)combo.getSelectedItem();
                    BuildPureClustersIndTestParamsEditor.this.getParams().setTetradTestType(index);
                }
            });
            TestType[] purifyDescriptions = TestType.getPurifyTestDescriptions();
            purifySelector = new JComboBox<TestType>(purifyDescriptions);
            purifySelector.setSelectedItem(this.getParams().getPurifyTestType());
            purifySelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComboBox combo = (JComboBox)e.getSource();
                    TestType index = (TestType)combo.getSelectedItem();
                    BuildPureClustersIndTestParamsEditor.this.getParams().setPurifyTestType(index);
                }
            });
        }
        this.setLayout(new BoxLayout(this, 1));
        if (!discreteData) {
            Box b1 = Box.createHorizontalBox();
            b1.add(new JLabel("Test:"));
            b1.add(Box.createHorizontalGlue());
            b1.add(testSelector);
            this.add(b1);
            this.add(Box.createHorizontalGlue());
            Box b2 = Box.createHorizontalBox();
            b2.add(new JLabel("Purify:"));
            b2.add(Box.createHorizontalGlue());
            b2.add(purifySelector);
            this.add(b2);
            this.add(Box.createHorizontalGlue());
        }
        Box b3 = Box.createHorizontalBox();
        b3.add(new JLabel("Alpha:"));
        b3.add(Box.createHorizontalGlue());
        b3.add(alphaField);
        this.add(b3);
        this.add(Box.createHorizontalGlue());
    }

    private BuildPureClustersIndTestParams getParams() {
        return this.paramsPureClusters;
    }
}

