/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.VariableSource;
import edu.cmu.tetrad.model.Params;
import edu.cmu.tetrad.search.TestType;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.model.BuildPureClustersParams;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.MimParams;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BuildPureClustersParamsEditor
extends JPanel
implements ParameterEditor {
    private BuildPureClustersParams params;
    private Object[] parentModels;

    @Override
    public void setParams(Params params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = (BuildPureClustersParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
        if (parentModels == null) {
            throw new NullPointerException();
        }
        this.parentModels = parentModels;
    }

    @Override
    public void setup() {
        boolean isDiscreteModel;
        DoubleTextField alphaField = new DoubleTextField(this.params.getAlpha(), 4, NumberFormatUtil.getInstance().getNumberFormat());
        alphaField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    BuildPureClustersParamsEditor.this.getParams().setAlpha(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        TestType[] descriptions = TestType.getTestDescriptions();
        JComboBox<TestType> testSelector = new JComboBox<TestType>(descriptions);
        testSelector.setSelectedItem(this.getParams().getTetradTestType());
        testSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                TestType testType = (TestType)combo.getSelectedItem();
                BuildPureClustersParamsEditor.this.getParams().setTetradTestType(testType);
            }
        });
        TestType[] purifyDescriptions = TestType.getPurifyTestDescriptions();
        JComboBox<TestType> purifySelector = new JComboBox<TestType>(purifyDescriptions);
        purifySelector.setSelectedItem(this.getParams().getPurifyTestType());
        purifySelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                TestType testType = (TestType)combo.getSelectedItem();
                BuildPureClustersParamsEditor.this.getParams().setPurifyTestType(testType);
            }
        });
        VariableSource dataModel = null;
        for (Object parentModel : this.parentModels) {
            if (!(parentModel instanceof DataWrapper)) continue;
            DataWrapper dataWrapper = (DataWrapper)parentModel;
            dataModel = dataWrapper.getSelectedDataModel();
        }
        if (dataModel == null) {
            throw new IllegalStateException("Null data model.");
        }
        ArrayList<String> varNames = new ArrayList<String>(dataModel.getVariableNames());
        if (dataModel instanceof CovarianceMatrix) {
            isDiscreteModel = false;
        } else {
            DataSet dataSet = (DataSet)dataModel;
            isDiscreteModel = dataSet.isDiscrete();
        }
        this.params.setVarNames(varNames);
        alphaField.setValue(this.params.getAlpha());
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Alpha:"));
        b1.add(Box.createHorizontalGlue());
        b1.add(alphaField);
        b.add(b1);
        if (!isDiscreteModel) {
            Box b2 = Box.createHorizontalBox();
            b2.add(new JLabel("Statistical Test:"));
            b2.add(Box.createHorizontalGlue());
            b2.add(testSelector);
            b.add(b2);
            Box b3 = Box.createHorizontalBox();
            b3.add(new JLabel("Purify Test:"));
            b3.add(Box.createHorizontalGlue());
            b3.add(purifySelector);
            b.add(b3);
        } else {
            this.params.setPurifyTestType(TestType.DISCRETE_LRT);
            this.params.setTetradTestType(TestType.DISCRETE);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)b, "Center");
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    private MimParams getParams() {
        return this.params;
    }
}

