/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.util.JOptionUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;

final class ClusterRenderer
extends JPanel {
    private List<String> varNames;
    private Clusters clusters;
    private int numClusters;

    public ClusterRenderer(Clusters clusters, List<String> varNames) {
        if (clusters == null) {
            throw new NullPointerException();
        }
        if (varNames == null) {
            throw new NullPointerException();
        }
        this.clusters = clusters;
        this.varNames = varNames;
        this.numClusters = clusters.getNumClusters();
        this.setLayout(new BorderLayout());
        this.add((Component)this.clusterDisplay(), "Center");
    }

    private Box clusterDisplay() {
        Box b = Box.createVerticalBox();
        b.setBorder(new EmptyBorder(5, 5, 5, 5));
        Box b1 = Box.createHorizontalBox();
        b1.add(Box.createHorizontalGlue());
        b1.add(new JLabel("# Clusters = " + this.getNumClusters()));
        b.add(b1);
        JPanel clustersPanel = new JPanel();
        clustersPanel.setLayout(new BorderLayout());
        clustersPanel.add((Component)this.getClusterBoxes(this.getNumClusters()), "Center");
        b.add(clustersPanel);
        return b;
    }

    private Box getClusterBoxes(int numClusters) {
        Box c = Box.createVerticalBox();
        c.add(Box.createVerticalStrut(5));
        Box d = Box.createHorizontalBox();
        d.add(Box.createHorizontalGlue());
        for (int cluster = 0; cluster < numClusters; ++cluster) {
            Box d1 = Box.createVerticalBox();
            Box d2 = Box.createHorizontalBox();
            d2.add(Box.createHorizontalGlue());
            d2.add(new JLabel(this.getClusters().getClusterName(cluster)));
            d2.add(Box.createHorizontalGlue());
            d1.add(d2);
            d.add(d1);
            List<String> clusterNames = this.getClusters().getCluster(cluster);
            DragDropList clusterList = new DragDropList(clusterNames, cluster, 1);
            JScrollPane scrollPane2 = new JScrollPane(clusterList);
            scrollPane2.setPreferredSize(new Dimension(50, 275));
            scrollPane2.setMaximumSize(new Dimension(200, 275));
            d1.add(scrollPane2);
            d.add(d1);
            d.add(Box.createHorizontalGlue());
        }
        JScrollPane scroll = new JScrollPane(d);
        scroll.setPreferredSize(new Dimension(400, 300));
        c.add(scroll);
        List<String> varsNotInCluster = this.getClusters().getVarsNotInCluster(this.getVarNames());
        DragDropList l1 = new DragDropList(varsNotInCluster, -1, 2);
        l1.setBorder(null);
        Box b4 = Box.createHorizontalBox();
        b4.add(new JLabel("Variables not yet clustered:"));
        b4.add(Box.createHorizontalGlue());
        c.add(b4);
        Box b2 = Box.createHorizontalBox();
        JScrollPane scrollPane = new JScrollPane(l1);
        scrollPane.setPreferredSize(new Dimension(400, 50));
        b2.add(scrollPane);
        c.add(b2);
        return c;
    }

    private Clusters getClusters() {
        return this.clusters;
    }

    private List<String> getVarNames() {
        return this.varNames;
    }

    private int getNumClusters() {
        return this.numClusters;
    }

    public static class ListSelection
    implements Transferable {
        private List<Object> list;
        private DataFlavor[] dataFlavors = new DataFlavor[]{new DataFlavor(ListSelection.class, "String List Selection")};

        public ListSelection(List<Object> list) {
            if (list == null) {
                throw new NullPointerException("List of list must not be null.");
            }
            this.list = list;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.list;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(this.getTransferDataFlavors()[0]);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.dataFlavors;
        }
    }

    public class DragDropList
    extends JList
    implements DropTargetListener,
    DragSourceListener,
    DragGestureListener {
        private List<Object> movedList;
        private int cluster;

        public DragDropList(List items, int cluster, int orientation) {
            if (cluster < -1) {
                throw new IllegalArgumentException();
            }
            this.cluster = cluster;
            this.setLayoutOrientation(orientation);
            this.setVisibleRowCount(0);
            this.setCellRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Color fillColor = new Color(153, 204, 204);
                    Color selectedFillColor = new Color(255, 204, 102);
                    JLabel comp = new JLabel(" " + value + " ");
                    comp.setOpaque(true);
                    if (isSelected) {
                        comp.setForeground(Color.BLACK);
                        comp.setBackground(selectedFillColor);
                    } else {
                        comp.setForeground(Color.BLACK);
                        comp.setBackground(fillColor);
                    }
                    comp.setHorizontalAlignment(0);
                    comp.setBorder(new CompoundBorder(new MatteBorder(2, 2, 2, 2, Color.WHITE), new LineBorder(Color.BLACK)));
                    return comp;
                }
            });
            new DropTarget(this, 2, this, true);
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer(this, 2, this);
            this.setModel(new DefaultListModel());
            for (Object item : items) {
                ((DefaultListModel)this.getModel()).addElement(item);
            }
        }

        public int getCluster() {
            return this.cluster;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (this.getSelectedIndex() == -1) {
                return;
            }
            Object[] selectedValues = this.getSelectedValues();
            List<Object> list = Arrays.asList(selectedValues);
            if (list == null) {
                this.getToolkit().beep();
            } else {
                this.movedList = list;
                ListSelection transferable = new ListSelection(list);
                dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, transferable, this);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                Transferable tr = dropTargetDropEvent.getTransferable();
                DataFlavor flavor = tr.getTransferDataFlavors()[0];
                List list = (List)tr.getTransferData(flavor);
                for (String name : list) {
                    DefaultListModel model;
                    if (this.getCluster() >= 0) {
                        try {
                            ClusterRenderer.this.getClusters().addToCluster(this.getCluster(), name);
                            model = (DefaultListModel)this.getModel();
                            model.addElement(name);
                            this.sort(model);
                            dropTargetDropEvent.dropComplete(true);
                        }
                        catch (IllegalStateException e) {
                            String s = e.getMessage();
                            if (!"".equals(s)) {
                                s = "Drop could not be completed properly.";
                            }
                            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), s);
                            dropTargetDropEvent.dropComplete(false);
                        }
                        continue;
                    }
                    ClusterRenderer.this.getClusters().removeFromClusters(name);
                    model = (DefaultListModel)this.getModel();
                    model.addElement(name);
                    this.sort(model);
                    dropTargetDropEvent.dropComplete(true);
                }
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (!dsde.getDropSuccess()) {
                return;
            }
            if (this.movedList != null) {
                for (Object e : this.movedList) {
                    ((DefaultListModel)this.getModel()).removeElement(e);
                }
                this.movedList = null;
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        private void sort(DefaultListModel model) {
            Object[] elements = model.toArray();
            Arrays.sort(elements);
            model.clear();
            for (Object element : elements) {
                model.addElement(element);
            }
        }
    }
}

