/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.model.LogisticRegressionParams;
import edu.cmu.tetradapp.model.StandardRegressionParams;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.LayoutUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;

public class ConditionalIndependenceParamsPanel
extends JPanel {
    private StandardRegressionParams params;
    private static JList PREDICTORS_LIST;
    private static JList SOURCE_LIST;
    private static JTextField X_FIELD;
    private static JTextField Y_FIELD;
    private static Map<String, Integer> VAR_MAP;
    private static Font FONT;

    public ConditionalIndependenceParamsPanel(StandardRegressionParams params, DataModel model) {
        this.setLayout(new BoxLayout(this, 1));
        if (params == null) {
            throw new NullPointerException("The given params must not be null");
        }
        this.params = params;
        List<String> variableNames = params.getVarNames();
        if (variableNames == null) {
            if (model == null) {
                throw new NullPointerException("Data model must not be null");
            }
            variableNames = model.getVariableNames();
            if (variableNames == null) {
                throw new IllegalStateException("Could not load variables.");
            }
            params.setVarNames(variableNames);
        }
        PREDICTORS_LIST = ConditionalIndependenceParamsPanel.createList();
        VariableListModel predictorsModel = (VariableListModel)ConditionalIndependenceParamsPanel.getPredictorsList().getModel();
        SOURCE_LIST = ConditionalIndependenceParamsPanel.createList();
        if (params instanceof LogisticRegressionParams && model instanceof DataSet) {
            this.buildMap((DataSet)model);
            ConditionalIndependenceParamsPanel.getSourceList().setCellRenderer(new LogisticRegRenderer());
        }
        VariableListModel variableModel = (VariableListModel)ConditionalIndependenceParamsPanel.getSourceList().getModel();
        X_FIELD = this.createResponse(ConditionalIndependenceParamsPanel.getSourceList(), 100);
        Y_FIELD = this.createResponse(ConditionalIndependenceParamsPanel.getSourceList(), 100);
        String[] regressors = params.getRegressorNames();
        if (regressors != null) {
            List<String> elements = Arrays.asList(regressors);
            predictorsModel.addAll(elements);
            ArrayList<String> initVars = new ArrayList<String>(variableNames);
            initVars.removeAll(elements);
            variableModel.addAll(initVars);
        } else {
            variableModel.addAll(variableNames);
        }
        String target = params.getTargetName();
        if (target != null) {
            variableModel.remove((Comparable)((Object)target));
        }
        new DropTarget(ConditionalIndependenceParamsPanel.getSourceList(), 2, new TargetListener(), true);
        new DropTarget(ConditionalIndependenceParamsPanel.getXField(), 2, new TargetListener(), true);
        new DropTarget(ConditionalIndependenceParamsPanel.getPredictorsList(), 2, new TargetListener(), true);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(ConditionalIndependenceParamsPanel.getXField(), 2, new SourceListener());
        dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(ConditionalIndependenceParamsPanel.getSourceList(), 2, new SourceListener());
        dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(ConditionalIndependenceParamsPanel.getPredictorsList(), 2, new SourceListener());
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(10));
        Box label = ConditionalIndependenceParamsPanel.createLabel("Variables:");
        int height = label.getPreferredSize().height + ConditionalIndependenceParamsPanel.getXField().getPreferredSize().height + 10;
        Box vBox1 = Box.createVerticalBox();
        vBox1.add(label);
        JScrollPane pane = ConditionalIndependenceParamsPanel.createScrollPane(ConditionalIndependenceParamsPanel.getSourceList(), new Dimension(100, 350 + height));
        vBox1.add(pane);
        vBox1.add(Box.createVerticalStrut(10));
        vBox1.add(this.buildAlphaArea(params.getAlpha()));
        vBox1.add(Box.createVerticalStrut(10));
        vBox1.add(this.buildSortButton());
        vBox1.add(Box.createVerticalGlue());
        box.add(vBox1);
        box.add(Box.createHorizontalStrut(4));
        box.add(this.buildSelectorArea(label.getPreferredSize().height));
        box.add(Box.createHorizontalStrut(4));
        Box vBox = Box.createVerticalBox();
        vBox.add(ConditionalIndependenceParamsPanel.createLabel("X:"));
        vBox.add(ConditionalIndependenceParamsPanel.getXField());
        vBox.add(Box.createVerticalStrut(10));
        vBox.add(ConditionalIndependenceParamsPanel.createLabel("Y:"));
        vBox.add(ConditionalIndependenceParamsPanel.getYField());
        vBox.add(Box.createVerticalStrut(10));
        vBox.add(ConditionalIndependenceParamsPanel.createLabel("Conditioning Set:"));
        vBox.add(ConditionalIndependenceParamsPanel.createScrollPane(ConditionalIndependenceParamsPanel.getPredictorsList(), new Dimension(100, 350)));
        vBox.add(Box.createVerticalGlue());
        box.add(vBox);
        box.add(Box.createHorizontalStrut(10));
        box.add(Box.createHorizontalGlue());
        this.add(Box.createVerticalStrut(20));
        this.add(box);
    }

    private static List<Comparable> getSelected(JList list) {
        Object[] selected = list.getSelectedValues();
        ArrayList<Comparable> selectedList = new ArrayList<Comparable>(selected == null ? 0 : selected.length);
        if (selected != null) {
            for (Object o : selected) {
                selectedList.add((Comparable)o);
            }
        }
        return selectedList;
    }

    private Box buildSelectorArea(int startHeight) {
        Box box = Box.createVerticalBox();
        JButton moveToX = new JButton(">");
        JButton moveToY = new JButton(">");
        JButton moveToPredictor = new JButton(">");
        JButton moveToSource = new JButton("<");
        moveToX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariableListModel sourceModel = (VariableListModel)ConditionalIndependenceParamsPanel.getSourceList().getModel();
                String target = ConditionalIndependenceParamsPanel.getXField().getText();
                List selected = ConditionalIndependenceParamsPanel.getSelected(ConditionalIndependenceParamsPanel.getSourceList());
                if (selected.isEmpty()) {
                    return;
                }
                if (1 < selected.size()) {
                    JOptionPane.showMessageDialog(ConditionalIndependenceParamsPanel.this, "Cannot have more than one response variable");
                    return;
                }
                if (ConditionalIndependenceParamsPanel.this.params instanceof LogisticRegressionParams && !ConditionalIndependenceParamsPanel.this.isBinary((String)selected.get(0))) {
                    JOptionPane.showMessageDialog(ConditionalIndependenceParamsPanel.this, "Response variable must be binary.");
                    return;
                }
                sourceModel.removeAll(selected);
                ConditionalIndependenceParamsPanel.getXField().setText((String)selected.get(0));
                ConditionalIndependenceParamsPanel.getXField().setCaretPosition(0);
                ConditionalIndependenceParamsPanel.this.params.setTargetName((String)selected.get(0));
                if (target != null && target.length() != 0) {
                    sourceModel.add((Comparable)((Object)target));
                }
            }
        });
        moveToY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariableListModel sourceModel = (VariableListModel)ConditionalIndependenceParamsPanel.getSourceList().getModel();
                String target = ConditionalIndependenceParamsPanel.getYField().getText();
                List selected = ConditionalIndependenceParamsPanel.getSelected(ConditionalIndependenceParamsPanel.getSourceList());
                if (selected.isEmpty()) {
                    return;
                }
                if (1 < selected.size()) {
                    JOptionPane.showMessageDialog(ConditionalIndependenceParamsPanel.this, "Cannot have more than one response variable");
                    return;
                }
                if (ConditionalIndependenceParamsPanel.this.params instanceof LogisticRegressionParams && !ConditionalIndependenceParamsPanel.this.isBinary((String)selected.get(0))) {
                    JOptionPane.showMessageDialog(ConditionalIndependenceParamsPanel.this, "Response variable must be binary.");
                    return;
                }
                sourceModel.removeAll(selected);
                ConditionalIndependenceParamsPanel.getYField().setText((String)selected.get(0));
                ConditionalIndependenceParamsPanel.getYField().setCaretPosition(0);
                if (target != null && target.length() != 0) {
                    sourceModel.add((Comparable)((Object)target));
                }
            }
        });
        moveToPredictor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariableListModel predictorsModel = (VariableListModel)ConditionalIndependenceParamsPanel.getPredictorsList().getModel();
                VariableListModel sourceModel = (VariableListModel)ConditionalIndependenceParamsPanel.getSourceList().getModel();
                List selected = ConditionalIndependenceParamsPanel.getSelected(ConditionalIndependenceParamsPanel.getSourceList());
                sourceModel.removeAll(selected);
                predictorsModel.addAll(selected);
                ConditionalIndependenceParamsPanel.this.params.setRegressorNames(ConditionalIndependenceParamsPanel.this.getPredictors());
            }
        });
        moveToSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariableListModel predictorsModel = (VariableListModel)ConditionalIndependenceParamsPanel.getPredictorsList().getModel();
                VariableListModel sourceModel = (VariableListModel)ConditionalIndependenceParamsPanel.getSourceList().getModel();
                List selected = ConditionalIndependenceParamsPanel.getSelected(ConditionalIndependenceParamsPanel.getPredictorsList());
                if (!selected.isEmpty()) {
                    predictorsModel.removeAll(selected);
                    sourceModel.addAll(selected);
                    ConditionalIndependenceParamsPanel.this.params.setRegressorNames(ConditionalIndependenceParamsPanel.this.getPredictors());
                } else if (ConditionalIndependenceParamsPanel.getXField().getText() != null && ConditionalIndependenceParamsPanel.getXField().getText().length() != 0) {
                    String text = ConditionalIndependenceParamsPanel.getXField().getText();
                    ConditionalIndependenceParamsPanel.this.params.setTargetName(null);
                    ConditionalIndependenceParamsPanel.getXField().setText(null);
                    sourceModel.addAll(Collections.singletonList(text));
                }
            }
        });
        box.add(Box.createVerticalStrut(startHeight));
        box.add(moveToX);
        box.add(Box.createVerticalStrut(10));
        box.add(moveToY);
        box.add(Box.createVerticalStrut(150));
        box.add(moveToPredictor);
        box.add(Box.createVerticalStrut(10));
        box.add(moveToSource);
        box.add(Box.createVerticalGlue());
        return box;
    }

    private Box buildSortButton() {
        JButton sort = new JButton("Sort Variables");
        sort.setFont(sort.getFont().deriveFont(11.0f));
        sort.setMargin(new Insets(3, 3, 3, 3));
        sort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariableListModel predictorsModel = (VariableListModel)ConditionalIndependenceParamsPanel.getPredictorsList().getModel();
                VariableListModel sourceModel = (VariableListModel)ConditionalIndependenceParamsPanel.getSourceList().getModel();
                predictorsModel.sort();
                sourceModel.sort();
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(sort);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private Box buildAlphaArea(double alpha) {
        DoubleTextField field = new DoubleTextField(alpha, 4, NumberFormatUtil.getInstance().getNumberFormat());
        field.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                if (0.0 <= value && value <= 1.0) {
                    ConditionalIndependenceParamsPanel.this.params.setAlpha(value);
                    ConditionalIndependenceParamsPanel.this.firePropertyChange("significanceChanged", oldValue, value);
                    return value;
                }
                return oldValue;
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Alpha: "));
        box.add(field);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private void buildMap(DataSet model) {
        for (Node node : model.getVariables()) {
            if (DataUtils.isBinary(model, model.getColumn(node))) {
                ConditionalIndependenceParamsPanel.getVarMap().put(node.getName(), 1);
                continue;
            }
            if (node instanceof DiscreteVariable) {
                ConditionalIndependenceParamsPanel.getVarMap().put(node.getName(), 2);
                continue;
            }
            ConditionalIndependenceParamsPanel.getVarMap().put(node.getName(), 3);
        }
    }

    private static JScrollPane createScrollPane(JList comp, Dimension dim) {
        JScrollPane pane = new JScrollPane(comp);
        LayoutUtils.setAllSizes(pane, dim);
        return pane;
    }

    private static Box createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setAlignmentX(0.0f);
        Box box = Box.createHorizontalBox();
        box.add(label);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private JTextField createResponse(JList list, int width) {
        JTextField pane = new JTextField();
        pane.setFont(ConditionalIndependenceParamsPanel.getFONT());
        pane.setFocusable(true);
        pane.setEditable(false);
        pane.setBackground(list.getBackground());
        String target = this.params.getTargetName();
        if (target != null) {
            pane.setText(target);
        } else {
            pane.setText("Hello");
        }
        pane.setCaretPosition(0);
        LayoutUtils.setAllSizes(pane, new Dimension(width, pane.getPreferredSize().height));
        if (target == null) {
            pane.setText(null);
        }
        pane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ConditionalIndependenceParamsPanel.getPredictorsList().clearSelection();
            }
        });
        return pane;
    }

    private static JList createList() {
        JList list = new JList(new VariableListModel());
        list.setFont(ConditionalIndependenceParamsPanel.getFONT());
        list.setSelectionMode(2);
        list.setVisibleRowCount(10);
        return list;
    }

    private static DataFlavor getListDataFlavor() {
        try {
            return new DataFlavor("application/x-java-jvm-local-objectref; class=java.lang.Object", "Local Variable List");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String[] getPredictors() {
        ListModel model = ConditionalIndependenceParamsPanel.getPredictorsList().getModel();
        String[] predictors = new String[model.getSize()];
        for (int i = 0; i < model.getSize(); ++i) {
            predictors[i] = (String)model.getElementAt(i);
        }
        return predictors;
    }

    private void addToSource(String var) {
        VariableListModel model = (VariableListModel)ConditionalIndependenceParamsPanel.getSourceList().getModel();
        model.add((Comparable)((Object)var));
    }

    private boolean isBinary(String node) {
        int i = ConditionalIndependenceParamsPanel.getVarMap().get(node);
        return i == 1;
    }

    private static Map<String, Integer> getVarMap() {
        return VAR_MAP;
    }

    public static JList getPredictorsList() {
        return PREDICTORS_LIST;
    }

    private static JList getSourceList() {
        return SOURCE_LIST;
    }

    public static JTextField getXField() {
        return X_FIELD;
    }

    public static JTextField getYField() {
        return Y_FIELD;
    }

    public static Font getFONT() {
        return FONT;
    }

    static /* synthetic */ DataFlavor access$1200() {
        return ConditionalIndependenceParamsPanel.getListDataFlavor();
    }

    static {
        VAR_MAP = new HashMap<String, Integer>();
        FONT = new Font("Dialog", 0, 12);
    }

    private static class ListTransferable
    implements Transferable {
        private static final DataFlavor FLAVOR = ConditionalIndependenceParamsPanel.access$1200();
        private List object;

        public ListTransferable(List object) {
            if (object == null) {
                throw new NullPointerException();
            }
            this.object = object;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == FLAVOR;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (FLAVOR != flavor) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.object;
        }
    }

    private static class VariableListModel
    extends AbstractListModel {
        private Vector<Comparable> delegate = new Vector();

        private VariableListModel() {
        }

        @Override
        public int getSize() {
            return this.delegate.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.delegate.get(index);
        }

        public void remove(Comparable element) {
            int index = this.delegate.indexOf(element);
            if (0 <= index) {
                this.delegate.remove(index);
                this.fireIntervalRemoved(this, index, index);
            }
        }

        public void add(Comparable element) {
            this.delegate.add(element);
            this.fireIntervalAdded(this, this.delegate.size(), this.delegate.size());
        }

        public void removeFirst(Comparable element) {
            this.delegate.removeElement(element);
            this.fireContentsChanged(this, 0, this.delegate.size());
        }

        public void removeAll(List<? extends Comparable> elements) {
            this.delegate.removeAll(elements);
            this.fireContentsChanged(this, 0, this.delegate.size());
        }

        public void addAll(List<? extends Comparable> elements) {
            this.delegate.addAll(elements);
            this.fireContentsChanged(this, 0, this.delegate.size());
        }

        public void removeAll() {
            this.delegate.clear();
            this.fireContentsChanged(this, 0, 0);
        }

        public void sort() {
            Collections.sort(this.delegate);
            this.fireContentsChanged(this, 0, this.delegate.size());
        }
    }

    private class SourceListener
    extends DragSourceAdapter
    implements DragGestureListener {
        private SourceListener() {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent evt) {
            if (evt.getDropSuccess()) {
                Component comp = evt.getDragSourceContext().getComponent();
                Transferable t = evt.getDragSourceContext().getTransferable();
                if (t instanceof ListTransferable) {
                    try {
                        List o = (List)t.getTransferData(ListTransferable.FLAVOR);
                        if (comp instanceof JList) {
                            JList list = (JList)comp;
                            VariableListModel model = (VariableListModel)list.getModel();
                            for (Comparable c : o) {
                                model.removeFirst(c);
                            }
                        } else {
                            JTextField pane = (JTextField)comp;
                            pane.setText(null);
                        }
                        ConditionalIndependenceParamsPanel.this.params.setTargetName(ConditionalIndependenceParamsPanel.getXField().getText());
                        ConditionalIndependenceParamsPanel.this.params.setRegressorNames(ConditionalIndependenceParamsPanel.this.getPredictors());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            Component comp = dge.getComponent();
            Object[] selected = null;
            if (comp instanceof JList) {
                JList list = (JList)comp;
                selected = list.getSelectedValues();
            } else {
                JTextField pane = (JTextField)comp;
                String text = pane.getText();
                if (text != null && text.length() != 0) {
                    selected = new Object[]{text};
                }
            }
            if (selected != null) {
                ListTransferable t = new ListTransferable(Arrays.asList(selected));
                dge.startDrag(DragSource.DefaultMoveDrop, t, this);
            }
        }
    }

    private class TargetListener
    extends DropTargetAdapter {
        private TargetListener() {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Transferable t = dtde.getTransferable();
            Component comp = dtde.getDropTargetContext().getComponent();
            if (comp instanceof JList || comp instanceof JTextField) {
                try {
                    if (comp == ConditionalIndependenceParamsPanel.getXField()) {
                        List vars;
                        String var = ConditionalIndependenceParamsPanel.getXField().getText();
                        if (var != null && var.length() != 0) {
                            ConditionalIndependenceParamsPanel.this.addToSource(var);
                        }
                        if ((vars = (List)t.getTransferData(ListTransferable.FLAVOR)).isEmpty()) {
                            dtde.rejectDrop();
                            return;
                        }
                        if (1 < vars.size()) {
                            JOptionPane.showMessageDialog(ConditionalIndependenceParamsPanel.this, "There can only be one response variable.");
                            dtde.rejectDrop();
                            return;
                        }
                        if (ConditionalIndependenceParamsPanel.this.params instanceof LogisticRegressionParams && !ConditionalIndependenceParamsPanel.this.isBinary((String)vars.get(0))) {
                            JOptionPane.showMessageDialog(ConditionalIndependenceParamsPanel.this, "The response variable must be binary");
                            dtde.rejectDrop();
                            return;
                        }
                        ConditionalIndependenceParamsPanel.getXField().setText((String)vars.get(0));
                        ConditionalIndependenceParamsPanel.getXField().setCaretPosition(0);
                    } else {
                        JList list = (JList)comp;
                        VariableListModel model = (VariableListModel)list.getModel();
                        List vars = (List)t.getTransferData(ListTransferable.FLAVOR);
                        model.addAll(vars);
                    }
                    ConditionalIndependenceParamsPanel.this.params.setTargetName(ConditionalIndependenceParamsPanel.getXField().getText());
                    ConditionalIndependenceParamsPanel.this.params.setRegressorNames(ConditionalIndependenceParamsPanel.this.getPredictors());
                    dtde.getDropTargetContext().dropComplete(true);
                }
                catch (Exception ex) {
                    dtde.rejectDrop();
                    ex.printStackTrace();
                }
            } else {
                dtde.rejectDrop();
            }
        }
    }

    private static class LogisticRegRenderer
    extends DefaultListCellRenderer {
        private LogisticRegRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String var = (String)value;
            if (var == null) {
                this.setText(" ");
                return this;
            }
            int binary = (Integer)ConditionalIndependenceParamsPanel.getVarMap().get(var);
            if (binary == 1) {
                var = var + " (Binary)";
            } else if (binary == 2) {
                var = var + " (Discrete)";
            } else if (binary == 3) {
                var = var + " (Continuous)";
            }
            this.setText(var);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

