/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetradapp.editor.CovMatrixJTable;
import edu.cmu.tetradapp.editor.DataModelContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CovMatrixDisplay
extends JPanel
implements DataModelContainer {
    private final CovMatrixJTable covMatrixJTable;
    private final JLabel label;
    private final JButton restoreButton;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public CovMatrixDisplay(CovarianceMatrix covMatrix) {
        this.covMatrixJTable = new CovMatrixJTable(covMatrix);
        this.label = new JLabel(" ");
        this.restoreButton = new JButton("Restore");
        this.restoreButton.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.getCovMatrixJTable()), "Center");
        Box b1 = Box.createHorizontalBox();
        if (covMatrix instanceof CorrelationMatrix) {
            b1.add(new JLabel("Correlation Matrix"));
        } else {
            b1.add(new JLabel("Covariance Matrix"));
        }
        b1.add(Box.createHorizontalGlue());
        this.add((Component)b1, "North");
        Box b2 = Box.createHorizontalBox();
        b2.add(this.label);
        b2.add(Box.createHorizontalGlue());
        b2.add(this.restoreButton);
        this.add((Component)b2, "South");
        if (!this.covMatrixJTable.isEditingMatrixPositiveDefinite()) {
            this.label.setText("Matrix not positive definite.");
            this.restoreButton.setEnabled(true);
        } else {
            this.label.setText(" ");
            this.restoreButton.setEnabled(false);
        }
        this.getCovMatrixJTable().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("modelChanged".equals(evt.getPropertyName())) {
                    CovMatrixDisplay.this.firePropertyChange("modelChanged", null, null);
                }
                if ("tableChanged".equals(evt.getPropertyName())) {
                    CovMatrixJTable source = (CovMatrixJTable)evt.getSource();
                    if (!source.isEditingMatrixPositiveDefinite()) {
                        CovMatrixDisplay.this.label.setText("Matrix not positive definite.");
                        CovMatrixDisplay.this.restoreButton.setEnabled(true);
                    } else {
                        CovMatrixDisplay.this.label.setText(" ");
                        CovMatrixDisplay.this.restoreButton.setEnabled(false);
                    }
                }
            }
        });
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CovMatrixDisplay.this.getCovMatrixJTable().restore();
            }
        });
    }

    @Override
    public DataModel getDataModel() {
        return this.getCovMatrixJTable().getDataModel();
    }

    public CovMatrixJTable getCovMatrixJTable() {
        return this.covMatrixJTable;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.pcs.firePropertyChange(evt);
    }
}

