/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.TimeSeriesData;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.model.Params;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.BayesDataParamsEditor;
import edu.cmu.tetradapp.editor.CalculatorAction;
import edu.cmu.tetradapp.editor.CovMatrixDisplay;
import edu.cmu.tetradapp.editor.DataDisplay;
import edu.cmu.tetradapp.editor.DataModelContainer;
import edu.cmu.tetradapp.editor.DescriptiveStatsAction;
import edu.cmu.tetradapp.editor.HistogramAction;
import edu.cmu.tetradapp.editor.LoadDataAction;
import edu.cmu.tetradapp.editor.NormalityTestAction;
import edu.cmu.tetradapp.editor.QQPlotAction;
import edu.cmu.tetradapp.editor.SaveDataAction;
import edu.cmu.tetradapp.editor.ScatterPlotAction;
import edu.cmu.tetradapp.editor.SemDataParamsEditor;
import edu.cmu.tetradapp.editor.TabularDataJTable;
import edu.cmu.tetradapp.editor.TabularDataTable;
import edu.cmu.tetradapp.editor.TimeSeriesDataDisplay;
import edu.cmu.tetradapp.model.BayesDataParams;
import edu.cmu.tetradapp.model.BayesDataWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.KnowledgeEditable;
import edu.cmu.tetradapp.model.SemDataParams;
import edu.cmu.tetradapp.model.SemDataWrapper;
import edu.cmu.tetradapp.model.TabularComparison;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class DataEditor
extends JPanel
implements KnowledgeEditable,
PropertyChangeListener {
    private DataWrapper dataWrapper;
    private JTabbedPane tabbedPane = new JTabbedPane();

    public DataEditor() {
    }

    public DataEditor(TabularComparison comparison) {
        this(new DataWrapper(comparison.getDataSet()));
    }

    public DataEditor(DataWrapper dataWrapper) {
        if (dataWrapper == null) {
            throw new NullPointerException("Data wrapper must not be null.");
        }
        this.dataWrapper = dataWrapper;
        this.setLayout(new BorderLayout());
        this.reset();
        this.tabbedPane().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (SwingUtilities.isRightMouseButton(e)) {
                    Point point = e.getPoint();
                    int index = DataEditor.this.tabbedPane().indexAtLocation(point.x, point.y);
                    if (index == -1) {
                        return;
                    }
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem close = new JMenuItem("Close Tab");
                    menu.add(close);
                    menu.show(DataEditor.this, point.x, point.y);
                    close.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DataEditor.this.closeTab();
                            DataEditor.this.grabFocus();
                            DataEditor.this.firePropertyChange("modelChanged", null, null);
                        }
                    });
                } else if (SwingUtilities.isLeftMouseButton(e)) {
                    DataModel selectedModel = DataEditor.this.getSelectedDataModel();
                    DataEditor.this.getDataWrapper().getDataModelList().setSelectedModel(selectedModel);
                    DataEditor.this.firePropertyChange("modelChanged", null, null);
                }
            }
        });
    }

    public final void replace(DataModel model) {
        if (model == null) {
            throw new NullPointerException("The given model must not be null");
        }
        this.tabbedPane.removeAll();
        this.setPreferredSize(new Dimension(600, 400));
        DataModelList dataModelList = this.dataWrapper.getDataModelList();
        dataModelList.clear();
        if (model instanceof DataModelList) {
            for (DataModel dataModel : (DataModelList)model) {
                dataModelList.add(dataModel);
            }
        } else {
            dataModelList.add(model);
        }
        this.removeAll();
        if (model instanceof DataModelList) {
            for (int i = 0; i < ((DataModelList)model).size(); ++i) {
                DataModel _model = ((DataModelList)model).get(i);
                this.tabbedPane.addTab(DataEditor.tabName(_model, 1), this.dataDisplay(_model));
            }
            this.add((Component)this.tabbedPane, "Center");
            this.add((Component)this.menuBar(), "North");
        } else {
            this.tabbedPane.addTab(DataEditor.tabName(model, 1), this.dataDisplay(model));
            this.add((Component)this.tabbedPane, "Center");
            this.add((Component)this.menuBar(), "North");
            this.validate();
        }
        this.dataWrapper.setDataModelList(dataModelList);
    }

    public final void reset() {
        this.tabbedPane().removeAll();
        this.setPreferredSize(new Dimension(600, 400));
        DataModelList dataModelList = this.dataWrapper.getDataModelList();
        DataModel selectedModel = this.dataWrapper.getSelectedDataModel();
        this.removeAll();
        DataEditor.removeEmptyModels(dataModelList);
        int selectedIndex = -1;
        for (int i = 0; i < dataModelList.size(); ++i) {
            DataModel dataModel = dataModelList.get(i);
            this.tabbedPane().addTab(DataEditor.tabName(dataModel, i + 1), this.dataDisplay(dataModel));
            if (selectedModel != dataModel) continue;
            selectedIndex = i;
        }
        this.tabbedPane().setSelectedIndex(selectedIndex);
        this.tabbedPane().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DataModel selectedModel = DataEditor.this.getSelectedDataModel();
                if (selectedModel == null) {
                    return;
                }
                DataEditor.this.getDataWrapper().getDataModelList().setSelectedModel(selectedModel);
            }
        });
        this.add((Component)this.tabbedPane(), "Center");
        this.add((Component)this.menuBar(), "North");
        this.validate();
    }

    public final void reset(DataModelList extraModels) {
        this.tabbedPane().removeAll();
        this.setPreferredSize(new Dimension(600, 400));
        DataModelList dataModelList = this.dataWrapper.getDataModelList();
        dataModelList.addAll(extraModels);
        this.removeAll();
        this.tabbedPane().removeAll();
        DataEditor.removeEmptyModels(dataModelList);
        int tabIndex = 0;
        for (DataModel dataModel : dataModelList) {
            this.tabbedPane().addTab(DataEditor.tabName(dataModel, ++tabIndex), this.dataDisplay(dataModel));
        }
        this.add((Component)this.tabbedPane(), "Center");
        this.add((Component)this.menuBar(), "North");
        this.validate();
        this.firePropertyChange("modelChanged", null, null);
    }

    public final void reset(DataModel dataModel) {
        this.tabbedPane().removeAll();
        this.setPreferredSize(new Dimension(600, 400));
        DataModelList dataModelList = this.dataWrapper.getDataModelList();
        dataModelList.clear();
        dataModelList.add(dataModel);
        DataEditor.removeEmptyModels(dataModelList);
        this.tabbedPane().removeAll();
        for (int i = 0; i < dataModelList.size(); ++i) {
            DataModel _dataModel = dataModelList.get(i);
            this.tabbedPane().addTab(DataEditor.tabName(dataModel, i + 1), this.dataDisplay(_dataModel));
        }
        this.add((Component)this.tabbedPane(), "Center");
        this.add((Component)this.menuBar(), "North");
        this.validate();
        this.firePropertyChange("modelChanged", null, null);
    }

    public DataModel getSelectedDataModel() {
        Component selectedComponent = this.tabbedPane().getSelectedComponent();
        DataModelContainer scrollPane = (DataModelContainer)((Object)selectedComponent);
        if (scrollPane == null) {
            return null;
        }
        return scrollPane.getDataModel();
    }

    public void selectFirstTab() {
        this.tabbedPane().setSelectedIndex(0);
        DataModel selectedModel = this.getSelectedDataModel();
        if (selectedModel == null) {
            return;
        }
        DataModel dataModel = this.dataWrapper.getSelectedDataModel();
        if (dataModel instanceof DataModelList) {
            DataModelList dataModelList = (DataModelList)dataModel;
            dataModelList.setSelectedModel(selectedModel);
            this.firePropertyChange("modelChanged", null, null);
        }
    }

    public int getTabCount() {
        return this.tabbedPane().getTabCount();
    }

    public List<Node> getKnownVariables() {
        return this.dataWrapper.getKnownVariables();
    }

    @Override
    public List<String> getVarNames() {
        return this.dataWrapper.getVarNames();
    }

    @Override
    public Graph getSourceGraph() {
        return this.dataWrapper.getSourceGraph();
    }

    public DataWrapper getDataWrapper() {
        return this.dataWrapper;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.dataWrapper.getKnowledge();
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.dataWrapper.setKnowledge(knowledge);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("modelChanged".equals(evt.getPropertyName())) {
            this.firePropertyChange("modelChanged", null, null);
        }
    }

    private static void removeEmptyModels(DataModelList dataModelList) {
        for (int i = dataModelList.size() - 1; i >= 0; --i) {
            DataModel dataModel = dataModelList.get(i);
            if (!(dataModel instanceof DataSet) || ((DataSet)dataModel).getNumColumns() != 0 || dataModelList.size() <= 1) continue;
            dataModelList.remove(dataModel);
        }
    }

    private JTable getSelectedJTable() {
        Component display = this.tabbedPane().getSelectedComponent();
        if (display instanceof DataDisplay) {
            return ((DataDisplay)display).getDataDisplayJTable();
        }
        if (display instanceof CovMatrixDisplay) {
            return ((CovMatrixDisplay)display).getCovMatrixJTable();
        }
        return null;
    }

    private JTable getJTableAt(int index) {
        Component display = this.tabbedPane().getComponentAt(index);
        if (display instanceof DataDisplay) {
            return ((DataDisplay)display).getDataDisplayJTable();
        }
        if (display instanceof CovMatrixDisplay) {
            return ((CovMatrixDisplay)display).getCovMatrixJTable();
        }
        return null;
    }

    private int getNumJTables() {
        return this.tabbedPane.getTabCount();
    }

    private JMenuBar menuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        JMenuItem fileItem = new JMenuItem(new LoadDataAction(this));
        file.add(fileItem);
        JMenuItem saveItem = new JMenuItem(new SaveDataAction(this));
        file.add(saveItem);
        fileItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        JMenu editMenu = new JMenu("Edit");
        JMenuItem clearCells = new JMenuItem("Clear Cells");
        JMenuItem deleteSelectedRowsOrColumns = new JMenuItem("Delete Selected Rows or Columns");
        JMenuItem deleteNamedColumns = new JMenuItem("Delete named columns");
        JMenuItem copyCells = new JMenuItem("Copy Cells");
        JMenuItem cutCells = new JMenuItem("Cut Cells");
        JMenuItem pasteCells = new JMenuItem("Paste Cells");
        JMenuItem setToMissingCells = new JMenuItem("Set Constants Col To Missing");
        clearCells.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        deleteSelectedRowsOrColumns.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        copyCells.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        cutCells.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        pasteCells.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        clearCells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularDataJTable table = (TabularDataJTable)DataEditor.this.getSelectedJTable();
                table.clearSelected();
            }
        });
        final ActionListener deleteActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularDataJTable tableTabular = (TabularDataJTable)DataEditor.this.getSelectedJTable();
                if (!tableTabular.getRowSelectionAllowed() || !tableTabular.getColumnSelectionAllowed()) {
                    tableTabular.deleteSelected();
                }
            }
        };
        deleteSelectedRowsOrColumns.addActionListener(deleteActionListener);
        ActionListener removeNamedColumnsActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String variables = JOptionPane.showInputDialog(JOptionUtils.getCenteringFrame(), (Object)"Type a space-separated list of variable names.");
                String[] tokens = variables.split(" ");
                for (int i = 0; i < DataEditor.this.getNumJTables(); ++i) {
                    System.out.println(i);
                    JTable jTable = DataEditor.this.getJTableAt(i);
                    if (!(jTable instanceof TabularDataJTable)) continue;
                    TabularDataJTable tableTabular = (TabularDataJTable)DataEditor.this.getJTableAt(i);
                    DataSet dataSet = tableTabular.getDataSet();
                    for (Node node : dataSet.getVariables()) {
                        for (String token : tokens) {
                            if (!token.equals(node.getName())) continue;
                            dataSet.removeColumn(node);
                        }
                    }
                    TabularDataTable model = (TabularDataTable)jTable.getModel();
                    model.fireTableDataChanged();
                }
            }
        };
        deleteNamedColumns.addActionListener(removeNamedColumnsActionListener);
        copyCells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTable table = DataEditor.this.getSelectedJTable();
                Action copyAction = TransferHandler.getCopyAction();
                ActionEvent actionEvent = new ActionEvent(table, 1001, "copy");
                copyAction.actionPerformed(actionEvent);
            }
        });
        cutCells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTable table = DataEditor.this.getSelectedJTable();
                Action cutAction = TransferHandler.getCutAction();
                ActionEvent actionEvent = new ActionEvent(table, 1001, "cut");
                cutAction.actionPerformed(actionEvent);
            }
        });
        pasteCells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTable table = DataEditor.this.getSelectedJTable();
                Action pasteAction = TransferHandler.getPasteAction();
                ActionEvent actionEvent = new ActionEvent(table, 1001, "paste");
                pasteAction.actionPerformed(actionEvent);
            }
        });
        setToMissingCells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                for (int i = 0; i < DataEditor.this.getNumJTables(); ++i) {
                    System.out.println(i);
                    JTable jTable = DataEditor.this.getJTableAt(i);
                    if (!(jTable instanceof TabularDataJTable)) continue;
                    TabularDataJTable tableTabular = (TabularDataJTable)DataEditor.this.getJTableAt(i);
                    DataSet dataSet = tableTabular.getDataSet();
                    block1: for (int j = 0; j < dataSet.getNumColumns(); ++j) {
                        int k;
                        double first = dataSet.getDouble(0, j);
                        for (k = 1; k < dataSet.getNumRows(); ++k) {
                            if (dataSet.getDouble(k, j) != first) continue block1;
                        }
                        for (k = 0; k < dataSet.getNumRows(); ++k) {
                            dataSet.setDouble(k, j, Double.NaN);
                        }
                    }
                    TabularDataTable model = (TabularDataTable)jTable.getModel();
                    model.fireTableDataChanged();
                }
            }
        });
        JCheckBoxMenuItem categoryNames = new JCheckBoxMenuItem("Show Category Names");
        JTable selectedJTable = this.getSelectedJTable();
        if (selectedJTable != null && selectedJTable instanceof TabularDataJTable) {
            TabularDataJTable tableTabular = (TabularDataJTable)selectedJTable;
            categoryNames.setSelected(tableTabular.isShowCategoryNames());
        }
        categoryNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTable selectedJTable = DataEditor.this.getSelectedJTable();
                TabularDataJTable tableTabular = (TabularDataJTable)selectedJTable;
                JCheckBoxMenuItem source = (JCheckBoxMenuItem)e.getSource();
                tableTabular.setShowCategoryNames(source.isSelected());
            }
        });
        editMenu.add(clearCells);
        editMenu.add(deleteSelectedRowsOrColumns);
        editMenu.add(deleteNamedColumns);
        editMenu.add(copyCells);
        editMenu.add(cutCells);
        editMenu.add(pasteCells);
        editMenu.addSeparator();
        editMenu.add(categoryNames);
        editMenu.add(setToMissingCells);
        menuBar.add(editMenu);
        JMenu tools = new JMenu("Tools");
        menuBar.add(tools);
        tools.add(new CalculatorAction(this));
        tools.add(new HistogramAction(this));
        tools.add(new ScatterPlotAction(this));
        tools.add(new QQPlotAction(this));
        tools.add(new NormalityTestAction(this));
        tools.add(new DescriptiveStatsAction(this));
        final Params _params = this.dataWrapper.getParams();
        if (_params instanceof BayesDataParams || _params instanceof SemDataParams) {
            JMenuItem drawSample = new JMenuItem("Draw New Sample");
            tools.add(drawSample);
            drawSample.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (_params instanceof BayesDataParams) {
                        BayesDataParams params = (BayesDataParams)_params;
                        BayesDataParamsEditor paramsEditor = new BayesDataParamsEditor();
                        paramsEditor.setParams(params);
                        paramsEditor.setup();
                        int ret = JOptionPane.showConfirmDialog(DataEditor.this, paramsEditor, "Draw New Sample", 2);
                        if (ret == 2) {
                            return;
                        }
                        BayesDataWrapper wrapper = (BayesDataWrapper)DataEditor.this.dataWrapper;
                        int sampleSize = params.getSampleSize();
                        boolean latentDataSaved = params.isLatentDataSaved();
                        DataSet dataSet = wrapper.getBayesIm().simulateData(sampleSize, latentDataSaved);
                        wrapper.setDataModel(dataSet);
                        wrapper.setSourceGraph(wrapper.getBayesIm().getDag());
                        DataEditor.this.replace(wrapper.getDataModelList());
                        DataEditor.this.selectFirstTab();
                        DataEditor.this.firePropertyChange("modelChanged", null, null);
                    } else if (_params instanceof SemDataParams) {
                        SemDataParams params = (SemDataParams)_params;
                        SemDataWrapper wrapper = (SemDataWrapper)DataEditor.this.dataWrapper;
                        SemDataParamsEditor paramsEditor = new SemDataParamsEditor();
                        paramsEditor.setParams(params);
                        paramsEditor.setup();
                        int ret = JOptionPane.showConfirmDialog(DataEditor.this, paramsEditor, "Draw New Sample", 2);
                        if (ret == 2) {
                            return;
                        }
                        int sampleSize = params.getSampleSize();
                        boolean latentDataSaved = params.isIncludeLatents();
                        DataSet dataSet = wrapper.getSemIm().simulateData(sampleSize, latentDataSaved);
                        wrapper.setDataModel(dataSet);
                        wrapper.setSourceGraph(wrapper.getSemIm().getSemPm().getGraph());
                        DataEditor.this.replace(wrapper.getDataModelList());
                        DataEditor.this.selectFirstTab();
                        DataEditor.this.firePropertyChange("modelChanged", null, null);
                    } else {
                        throw new IllegalStateException("Someone added a new type of data simulation parameter withouut modifying this bit of code It's in DataEditor, in the menuBar() method.");
                    }
                }
            });
        }
        int vkBackSpace = 8;
        int vkDelete = 127;
        KeyStroke backspaceKeystroke = KeyStroke.getKeyStroke(vkBackSpace, 0);
        KeyStroke deleteKeystroke = KeyStroke.getKeyStroke(vkDelete, 0);
        this.getInputMap(2).put(backspaceKeystroke, "DELETE");
        this.getInputMap(2).put(deleteKeystroke, "DELETE");
        AbstractAction deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                deleteActionListener.actionPerformed(null);
            }
        };
        this.getActionMap().put("DELETE", deleteAction);
        return menuBar;
    }

    private void closeTab() {
        int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "Closing this tab will remove the data it contains. Continue?", "Confirm", 2, 2);
        if (ret == 0) {
            DataModel dataModel = this.getSelectedDataModel();
            this.setPreferredSize(new Dimension(600, 400));
            DataModelList dataModelList = this.dataWrapper.getDataModelList();
            dataModelList.remove(dataModel);
            this.dataWrapper.setDataModel(dataModelList);
            this.tabbedPane.removeAll();
            for (int i = 0; i < dataModelList.size(); ++i) {
                DataModel _dataModel = dataModelList.get(i);
                this.tabbedPane().addTab(DataEditor.tabName(_dataModel, i + 1), this.dataDisplay(_dataModel));
            }
            this.add((Component)this.tabbedPane(), "Center");
            this.add((Component)this.menuBar(), "North");
            this.validate();
        }
    }

    private static String tabName(Object dataModel, int i) {
        String tabName = ((DataModel)dataModel).getName();
        if (tabName == null) {
            tabName = "Data Set " + i;
        }
        return tabName;
    }

    private JComponent dataDisplay(Object model) {
        if (model instanceof DataSet) {
            DataDisplay dataDisplay = new DataDisplay((DataSet)model);
            dataDisplay.addPropertyChangeListener(this);
            return dataDisplay;
        }
        if (model instanceof CovarianceMatrix) {
            CovMatrixDisplay covMatrixDisplay = new CovMatrixDisplay((CovarianceMatrix)model);
            covMatrixDisplay.addPropertyChangeListener(this);
            return covMatrixDisplay;
        }
        if (model instanceof TimeSeriesData) {
            return new TimeSeriesDataDisplay((TimeSeriesData)model);
        }
        throw new IllegalArgumentException("Unrecognized data type.");
    }

    private JTabbedPane tabbedPane() {
        return this.tabbedPane;
    }

    public DataModelList getDataModelList() {
        return this.dataWrapper.getDataModelList();
    }
}

