/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.DirichletBayesIm;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.NumberCellEditor;
import edu.cmu.tetradapp.editor.NumberCellRenderer;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.NumberFormat;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DirichletBayesImNodeProbsTable
extends JTable {
    private int focusRow = 0;
    private int focusCol = 0;
    private int lastX;
    private int lastY;

    public DirichletBayesImNodeProbsTable(Node node, DirichletBayesIm dirichletBayesIm) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (dirichletBayesIm == null) {
            throw new NullPointerException();
        }
        if (dirichletBayesIm.getNodeIndex(node) < 0) {
            throw new IllegalArgumentException("Node " + node + " is not a node" + " in this DirichletBayesIm.");
        }
        this.resetModel(node, dirichletBayesIm);
        this.setDefaultEditor(Number.class, new NumberCellEditor(NumberFormatUtil.getInstance().getNumberFormat()));
        this.setDefaultRenderer(Number.class, new NumberCellRenderer(NumberFormatUtil.getInstance().getNumberFormat()));
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(true);
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        ListSelectionModel rowSelectionModel = this.getSelectionModel();
        rowSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel m = (ListSelectionModel)e.getSource();
                DirichletBayesImNodeProbsTable.this.setFocusRow(m.getAnchorSelectionIndex());
            }
        });
        ListSelectionModel columnSelectionModel = this.getColumnModel().getSelectionModel();
        columnSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel m = (ListSelectionModel)e.getSource();
                DirichletBayesImNodeProbsTable.this.setFocusColumn(m.getAnchorSelectionIndex());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    DirichletBayesImNodeProbsTable.this.showPopup(e);
                }
            }
        });
        this.setFocusRow(0);
        this.setFocusColumn(0);
    }

    private void resetModel(Node node, DirichletBayesIm dirichletBayesIm) {
        Model model = new Model(node, dirichletBayesIm, this);
        model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("editorValueChanged".equals(evt.getPropertyName())) {
                    DirichletBayesImNodeProbsTable.this.firePropertyChange("editorValueChanged", null, null);
                }
            }
        });
        this.setModel(model);
    }

    @Override
    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        if (this.getModel() instanceof Model) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            Model model = (Model)this.getModel();
            for (int i = 0; i < model.getColumnCount(); ++i) {
                int minimumWidth;
                TableColumn column = this.getColumnModel().getColumn(i);
                String columnName = model.getColumnName(i);
                int currentWidth = column.getPreferredWidth();
                if (columnName == null || (minimumWidth = fontMetrics.stringWidth(columnName) + 8) <= currentWidth) continue;
                column.setPreferredWidth(minimumWidth);
            }
        }
    }

    private void showPopup(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem randomizeRow = new JMenuItem("Randomize this row");
        JMenuItem randomizeIncompleteRows = new JMenuItem("Randomize incomplete rows in table");
        JMenuItem randomizeEntireTable = new JMenuItem("Randomize entire table");
        JMenuItem randomizeAllTables = new JMenuItem("Randomize all tables");
        JMenuItem clearRow = new JMenuItem("Clear this row");
        JMenuItem clearEntireTable = new JMenuItem("Clear entire table");
        randomizeRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int nodeIndex = DirichletBayesImNodeProbsTable.this.getEditingTableModel().getNodeIndex();
                DirichletBayesImNodeProbsTable editingTable = DirichletBayesImNodeProbsTable.this;
                TableCellEditor cellEditor = editingTable.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.cancelCellEditing();
                }
                Point point = new Point(DirichletBayesImNodeProbsTable.this.getLastX(), DirichletBayesImNodeProbsTable.this.getLastY());
                int rowIndex = editingTable.rowAtPoint(point);
                DirichletBayesIm dirichletBayesIm = DirichletBayesImNodeProbsTable.this.getDirichletBayesIm();
                dirichletBayesIm.randomizeRow(nodeIndex, rowIndex);
                DirichletBayesImNodeProbsTable.this.getEditingTableModel().fireTableDataChanged();
            }
        });
        randomizeIncompleteRows.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int nodeIndex = DirichletBayesImNodeProbsTable.this.getEditingTableModel().getNodeIndex();
                DirichletBayesIm dirichletBayesIm = DirichletBayesImNodeProbsTable.this.getDirichletBayesIm();
                if (!DirichletBayesImNodeProbsTable.this.existsIncompleteRow(dirichletBayesIm, nodeIndex)) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "There are no incomplete rows in this table.");
                    return;
                }
                DirichletBayesImNodeProbsTable editingTable = DirichletBayesImNodeProbsTable.this;
                TableCellEditor cellEditor = editingTable.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.cancelCellEditing();
                }
                dirichletBayesIm.randomizeIncompleteRows(nodeIndex);
                DirichletBayesImNodeProbsTable.this.getEditingTableModel().fireTableDataChanged();
            }
        });
        randomizeEntireTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ret;
                int nodeIndex = DirichletBayesImNodeProbsTable.this.getEditingTableModel().getNodeIndex();
                DirichletBayesIm dirichletBayesIm = DirichletBayesImNodeProbsTable.this.getDirichletBayesIm();
                if (DirichletBayesImNodeProbsTable.this.existsCompleteRow(dirichletBayesIm, nodeIndex) && (ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This will modify all values in the table. Continue?", "Warning", 0)) == 1) {
                    return;
                }
                DirichletBayesImNodeProbsTable editingTable = DirichletBayesImNodeProbsTable.this;
                TableCellEditor cellEditor = editingTable.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.cancelCellEditing();
                }
                dirichletBayesIm.randomizeTable(nodeIndex);
                DirichletBayesImNodeProbsTable.this.getEditingTableModel().fireTableDataChanged();
            }
        });
        randomizeAllTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This will modify all values in the entire Dirichlet model! Continue?", "Warning", 0);
                if (ret == 1) {
                    return;
                }
                DirichletBayesIm dirichletBayesIm = DirichletBayesImNodeProbsTable.this.getDirichletBayesIm();
                for (int nodeIndex = 0; nodeIndex < dirichletBayesIm.getNumNodes(); ++nodeIndex) {
                    DirichletBayesImNodeProbsTable editingTable = DirichletBayesImNodeProbsTable.this;
                    TableCellEditor cellEditor = editingTable.getCellEditor();
                    if (cellEditor != null) {
                        cellEditor.cancelCellEditing();
                    }
                    dirichletBayesIm.randomizeTable(nodeIndex);
                    DirichletBayesImNodeProbsTable.this.getEditingTableModel().fireTableDataChanged();
                }
            }
        });
        clearRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int nodeIndex = DirichletBayesImNodeProbsTable.this.getEditingTableModel().getNodeIndex();
                DirichletBayesImNodeProbsTable editingTable = DirichletBayesImNodeProbsTable.this;
                TableCellEditor cellEditor = editingTable.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.cancelCellEditing();
                }
                Point point = new Point(DirichletBayesImNodeProbsTable.this.getLastX(), DirichletBayesImNodeProbsTable.this.getLastY());
                int rowIndex = editingTable.rowAtPoint(point);
                DirichletBayesIm dirichletBayesIm = DirichletBayesImNodeProbsTable.this.getDirichletBayesIm();
                dirichletBayesIm.clearRow(nodeIndex, rowIndex);
                DirichletBayesImNodeProbsTable.this.getEditingTableModel().fireTableRowsUpdated(rowIndex, rowIndex);
            }
        });
        clearEntireTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ret;
                int nodeIndex = DirichletBayesImNodeProbsTable.this.getEditingTableModel().getNodeIndex();
                DirichletBayesIm dirichletBayesIm = DirichletBayesImNodeProbsTable.this.getDirichletBayesIm();
                if (DirichletBayesImNodeProbsTable.this.existsCompleteRow(dirichletBayesIm, nodeIndex) && (ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This will delete all values in the table. Continue?", "Warning", 0)) == 1) {
                    return;
                }
                DirichletBayesImNodeProbsTable editingTable = DirichletBayesImNodeProbsTable.this;
                TableCellEditor cellEditor = editingTable.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.cancelCellEditing();
                }
                dirichletBayesIm.clearTable(nodeIndex);
                DirichletBayesImNodeProbsTable.this.getEditingTableModel().fireTableDataChanged();
            }
        });
        popup.add(randomizeRow);
        popup.add(randomizeIncompleteRows);
        popup.add(randomizeEntireTable);
        popup.add(randomizeAllTables);
        popup.addSeparator();
        popup.add(clearRow);
        popup.add(clearEntireTable);
        this.lastX = e.getX();
        this.lastY = e.getY();
        popup.show((Component)e.getSource(), e.getX(), e.getY());
    }

    private boolean existsCompleteRow(DirichletBayesIm dirichletBayesIm, int nodeIndex) {
        boolean existsCompleteRow = false;
        for (int rowIndex = 0; rowIndex < dirichletBayesIm.getNumRows(nodeIndex); ++rowIndex) {
            if (dirichletBayesIm.isIncomplete(nodeIndex, rowIndex)) continue;
            existsCompleteRow = true;
            break;
        }
        return existsCompleteRow;
    }

    private boolean existsIncompleteRow(DirichletBayesIm dirichletBayesIm, int nodeIndex) {
        boolean existsCompleteRow = false;
        for (int rowIndex = 0; rowIndex < dirichletBayesIm.getNumRows(nodeIndex); ++rowIndex) {
            if (!dirichletBayesIm.isIncomplete(nodeIndex, rowIndex)) continue;
            existsCompleteRow = true;
            break;
        }
        return existsCompleteRow;
    }

    @Override
    public void setModel(TableModel model) {
        super.setModel(model);
    }

    private void setFocusRow(int row) {
        Model editingTableModel = (Model)this.getModel();
        int failedRow = editingTableModel.getFailedRow();
        if (failedRow != -1) {
            row = failedRow;
            editingTableModel.resetFailedRow();
        }
        this.focusRow = row;
        if (this.focusCol < this.getRowCount()) {
            this.setRowSelectionInterval(this.focusRow, this.focusRow);
            this.editCellAt(this.focusRow, this.focusCol);
        }
    }

    private void setFocusColumn(int col) {
        Model editingTableModel = (Model)this.getModel();
        int failedCol = editingTableModel.getFailedCol();
        if (failedCol != -1) {
            col = failedCol;
            editingTableModel.resetFailedCol();
        }
        if (col < this.getNumParents()) {
            col = this.getNumParents();
        }
        int n = this.focusCol = col < this.getNumParents() ? this.getNumParents() : col;
        if (this.focusCol >= this.getNumParents() && this.focusCol < this.getColumnCount()) {
            this.setColumnSelectionInterval(this.focusCol, this.focusCol);
            this.editCellAt(this.focusRow, this.focusCol);
        }
    }

    private int getNumParents() {
        Model editingTableModel = (Model)this.getModel();
        DirichletBayesIm dirichletBayesIm = editingTableModel.getDirichletBayesIm();
        int nodeIndex = editingTableModel.getNodeIndex();
        return dirichletBayesIm.getNumParents(nodeIndex);
    }

    private Model getEditingTableModel() {
        return (Model)this.getModel();
    }

    private DirichletBayesIm getDirichletBayesIm() {
        return this.getEditingTableModel().getDirichletBayesIm();
    }

    private int getLastX() {
        return this.lastX;
    }

    private int getLastY() {
        return this.lastY;
    }

    static final class Model
    extends AbstractTableModel {
        private DirichletBayesIm bayesIm;
        private int nodeIndex;
        private JComponent messageAnchor;
        private int failedRow = -1;
        private int failedCol = -1;
        private PropertyChangeSupport pcs;
        int currentRow = -1;
        double[] currentRowProbs;
        double currentRowTotal;

        public Model(Node node, DirichletBayesIm bayesIm, JComponent messageAnchor) {
            if (node == null) {
                throw new NullPointerException("Node must not be null.");
            }
            if (bayesIm == null) {
                throw new NullPointerException("Bayes IM must not be null.");
            }
            if (messageAnchor == null) {
                throw new NullPointerException("Message anchor must not be null.");
            }
            this.bayesIm = bayesIm;
            this.nodeIndex = bayesIm.getNodeIndex(node);
            this.messageAnchor = messageAnchor;
        }

        @Override
        public String getColumnName(int col) {
            Node node = this.getDirichletBayesIm().getNode(this.getNodeIndex());
            int numParents = this.getDirichletBayesIm().getNumParents(this.getNodeIndex());
            int numColumns = this.getDirichletBayesIm().getNumColumns(this.getNodeIndex());
            int totalsColumn = numParents + numColumns;
            if (col < numParents) {
                int parent = this.getDirichletBayesIm().getParent(this.getNodeIndex(), col);
                return this.getDirichletBayesIm().getNode(parent).getName();
            }
            if (col < numParents + numColumns) {
                int valIndex = col - numParents;
                String value = this.getDirichletBayesIm().getBayesPm().getCategory(node, valIndex);
                return node.getName() + "=" + value;
            }
            if (col == totalsColumn) {
                return "TOTAL COUNT";
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.getDirichletBayesIm().getNumRows(this.getNodeIndex());
        }

        @Override
        public int getColumnCount() {
            int numParents = this.getDirichletBayesIm().getNumParents(this.getNodeIndex());
            int numColumns = this.getDirichletBayesIm().getNumColumns(this.getNodeIndex());
            return numParents + numColumns + 1;
        }

        @Override
        public Object getValueAt(int tableRow, int tableCol) {
            if (tableRow != this.currentRow) {
                this.closeCurrentRow();
                this.openNewRow(tableRow);
            }
            int numParents = this.getDirichletBayesIm().getNumParents(this.getNodeIndex());
            int numColumns = this.getDirichletBayesIm().getNumColumns(this.getNodeIndex());
            int totalsColumn = numParents + numColumns;
            int[] parentVals = this.getDirichletBayesIm().getParentValues(this.getNodeIndex(), tableRow);
            if (tableCol < numParents) {
                int parent = this.getDirichletBayesIm().getParent(this.getNodeIndex(), tableCol);
                Node columnNode = this.getDirichletBayesIm().getNode(parent);
                BayesPm bayesPm = this.getDirichletBayesIm().getBayesPm();
                return bayesPm.getCategory(columnNode, parentVals[tableCol]);
            }
            if (tableCol < numParents + numColumns) {
                int colIndex = tableCol - numParents;
                if (this.currentRowProbs != null && this.currentRow == tableRow) {
                    return this.currentRowProbs[colIndex];
                }
                double value = this.getDirichletBayesIm().getPseudocount(this.getNodeIndex(), tableRow, colIndex);
                double prob = this.getDirichletBayesIm().getProbability(this.getNodeIndex(), tableRow, colIndex);
                if (value == -1.0) {
                    return null;
                }
                return prob;
            }
            if (tableCol == totalsColumn) {
                if (this.currentRowProbs == null) {
                    return this.getDirichletBayesIm().getRowPseudocount(this.getNodeIndex(), tableRow);
                }
                return this.currentRowTotal;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            int numParents = this.getDirichletBayesIm().getNumParents(this.getNodeIndex());
            int numColumns = this.getDirichletBayesIm().getNumColumns(this.getNodeIndex());
            return col >= numParents && col < numParents + numColumns + 1;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            int numColumns;
            int numParents = this.getDirichletBayesIm().getNumParents(this.getNodeIndex());
            if (col == numParents + (numColumns = this.getDirichletBayesIm().getNumColumns(this.getNodeIndex()))) {
                this.setTotal(row, aValue);
            } else {
                this.setProbability(row, col, aValue);
            }
        }

        private void setTotal(int row, Object aValue) {
            if ("".equals(aValue) || aValue == null) {
                return;
            }
            if (row != this.currentRow) {
                this.closeCurrentRow();
                this.openNewRow(row);
            }
            try {
                double total = Double.parseDouble((String)aValue);
                if (total < 0.0) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Total must be nonnegative.");
                    this.failedRow = row;
                } else {
                    this.currentRowTotal = total;
                    this.fireTableRowsUpdated(row, row);
                    this.getPcs().firePropertyChange("editorValueChanged", null, null);
                    this.saveCurrentRow();
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Could not interpret '" + aValue + "'");
                this.failedRow = row;
            }
        }

        private void setProbability(int row, int col, Object aValue) {
            if (row != this.currentRow) {
                this.closeCurrentRow();
                this.openNewRow(row);
            }
            int numParents = this.getDirichletBayesIm().getNumParents(this.getNodeIndex());
            int colIndex = col - numParents;
            if ("".equals(aValue) || aValue == null) {
                this.currentRowProbs[colIndex] = Double.NaN;
                this.fireTableRowsUpdated(row, row);
                return;
            }
            try {
                NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
                double probability = Double.parseDouble((String)aValue);
                probability = Double.parseDouble(nf.format(probability));
                double oldProbability = this.getDirichletBayesIm().getProbability(this.nodeIndex, row, colIndex);
                if (!Double.isNaN(oldProbability)) {
                    oldProbability = Double.parseDouble(nf.format(oldProbability));
                }
                if (probability == oldProbability) {
                    return;
                }
                double sumInRow = this.sumInRow(colIndex) + probability;
                if (this.probabilityOutOfRange(probability)) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Probabilities must be in range [0.0, 1.0].");
                    this.failedRow = row;
                    this.failedCol = col;
                } else if (this.rowIsFull()) {
                    if (sumInRow < 0.99995 || sumInRow > 1.00005) {
                        this.emptyRow();
                        this.currentRowProbs[colIndex] = probability;
                        if (this.currentRowProbs.length == 2) {
                            this.fillInSingleRemainingColumn();
                        }
                        this.fixZeroRowTotalProblem();
                        this.fireTableRowsUpdated(row, row);
                        this.getPcs().firePropertyChange("editorValueChanged", null, null);
                    }
                } else if (sumInRow > 1.00005) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Sum of probabilities in row must not exceed 1.0.");
                    this.failedRow = row;
                    this.failedCol = col;
                } else {
                    this.currentRowProbs[colIndex] = probability;
                    this.fillInSingleRemainingColumn();
                    this.fixZeroRowTotalProblem();
                    this.fireTableRowsUpdated(row, row);
                    this.getPcs().firePropertyChange("editorValueChanged", null, null);
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Could not interpret '" + aValue + "'");
                this.failedRow = row;
                this.failedCol = col;
            }
            this.saveCurrentRow();
        }

        private void fixZeroRowTotalProblem() {
            if (this.currentRowTotal == 0.0) {
                this.currentRowTotal = 1.0;
            }
        }

        private void openNewRow(int row) {
            int numCols = this.getDirichletBayesIm().getNumColumns(this.nodeIndex);
            this.currentRow = row;
            this.currentRowProbs = new double[numCols];
            this.currentRowTotal = this.getDirichletBayesIm().getRowPseudocount(this.nodeIndex, row);
            for (int i = 0; i < numCols; ++i) {
                this.currentRowProbs[i] = this.getDirichletBayesIm().getProbability(this.nodeIndex, row, i);
            }
        }

        private void closeCurrentRow() {
            if (this.currentRow == -1) {
                return;
            }
            for (double currentRowProb : this.currentRowProbs) {
                if (!Double.isNaN(currentRowProb)) continue;
                Arrays.fill(this.currentRowProbs, Double.NaN);
                break;
            }
            for (int i = 0; i < this.currentRowProbs.length; ++i) {
                double pseudocount = this.currentRowProbs[i] * this.currentRowTotal;
                this.getDirichletBayesIm().setPseudocount(this.getNodeIndex(), this.currentRow, i, pseudocount);
            }
            this.currentRow = -1;
            this.currentRowProbs = null;
            this.currentRowTotal = Double.NaN;
        }

        private void saveCurrentRow() {
            if (this.currentRow == -1) {
                return;
            }
            for (double currentRowProb : this.currentRowProbs) {
                if (!Double.isNaN(currentRowProb)) continue;
                return;
            }
            for (int i = 0; i < this.currentRowProbs.length; ++i) {
                double pseudocount = this.currentRowProbs[i] * this.currentRowTotal;
                this.getDirichletBayesIm().setPseudocount(this.getNodeIndex(), this.currentRow, i, pseudocount);
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.getPcs().addPropertyChangeListener(l);
        }

        private PropertyChangeSupport getPcs() {
            if (this.pcs == null) {
                this.pcs = new PropertyChangeSupport(this);
            }
            return this.pcs;
        }

        private void fillInSingleRemainingColumn() {
            int leftOverColumn = this.uniqueNanCol();
            if (leftOverColumn != -1) {
                this.currentRowProbs[leftOverColumn] = 1.0 - this.sumInRow(leftOverColumn);
            }
        }

        private boolean probabilityOutOfRange(double value) {
            return value < 0.0 || value > 1.0;
        }

        private int uniqueNanCol() {
            int numNanCols = 0;
            int lastNanCol = -1;
            for (int i = 0; i < this.currentRowProbs.length; ++i) {
                if (!Double.isNaN(this.currentRowProbs[i])) continue;
                ++numNanCols;
                lastNanCol = i;
            }
            return numNanCols == 1 ? lastNanCol : -1;
        }

        private boolean rowIsFull() {
            int numNanCols = 0;
            for (double currentRowProb : this.currentRowProbs) {
                if (!Double.isNaN(currentRowProb)) continue;
                ++numNanCols;
            }
            return numNanCols == 0;
        }

        private void emptyRow() {
            for (int i = 0; i < this.currentRowProbs.length; ++i) {
                this.currentRowProbs[i] = Double.NaN;
            }
        }

        private double sumInRow(int skipCol) {
            double sum = 0.0;
            for (int i = 0; i < this.getDirichletBayesIm().getNumColumns(this.getNodeIndex()); ++i) {
                double probability = this.currentRowProbs[i];
                if (i == skipCol || Double.isNaN(probability)) continue;
                NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
                probability = Double.parseDouble(nf.format(probability));
                sum += probability;
            }
            return sum;
        }

        public Class getColumnClass(int col) {
            boolean isParent = col < this.getDirichletBayesIm().getNumParents(this.getNodeIndex());
            return isParent ? Object.class : Number.class;
        }

        public DirichletBayesIm getDirichletBayesIm() {
            return this.bayesIm;
        }

        public int getNodeIndex() {
            return this.nodeIndex;
        }

        public JComponent getMessageAnchor() {
            return this.messageAnchor;
        }

        public int getFailedRow() {
            return this.failedRow;
        }

        public int getFailedCol() {
            return this.failedCol;
        }

        public void resetFailedRow() {
            this.failedRow = -1;
        }

        public void resetFailedCol() {
            this.failedCol = -1;
        }

        public void finishEditing() {
            this.closeCurrentRow();
        }

        public void startEditing() {
            this.fireTableDataChanged();
            this.currentRow = -1;
            this.currentRowProbs = null;
            this.currentRowTotal = Double.NaN;
        }
    }
}

