/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.model.DiscDetIndepParams;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.IntTextField;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;

class DiscDetIndepParamsEditor
extends JComponent {
    private DiscDetIndepParams params = null;
    private DoubleTextField alphaField;
    private IntTextField depthField;
    private DoubleTextField discDetLb;

    public DiscDetIndepParamsEditor(DiscDetIndepParams params) {
        this.params = params;
        this.alphaField = new DoubleTextField(this.indTestParams().getAlpha(), 5, NumberFormatUtil.getInstance().getNumberFormat());
        this.alphaField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    DiscDetIndepParamsEditor.this.indTestParams().setAlpha(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        this.depthField = new IntTextField(this.indTestParams().getDepth(), 5);
        this.depthField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    DiscDetIndepParamsEditor.this.indTestParams().setDepth(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        this.discDetLb = new DoubleTextField(this.indTestParams().getDiscDetLb(), 5, NumberFormatUtil.getInstance().getNumberFormat());
        this.discDetLb.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    DiscDetIndepParamsEditor.this.indTestParams().setDiscDetLb(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        this.buildGui();
    }

    private void buildGui() {
        this.setLayout(new BoxLayout(this, 1));
        if (this.alphaField != null) {
            Box b1 = Box.createHorizontalBox();
            b1.add(new JLabel("Alpha:"));
            b1.add(Box.createHorizontalGlue());
            b1.add(this.alphaField);
            this.add(b1);
        }
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Depth:"));
        b2.add(Box.createHorizontalGlue());
        b2.add(this.depthField);
        this.add(b2);
        Box b3 = Box.createHorizontalBox();
        b3.add(new JLabel("Deterministic Lower Bound:"));
        b3.add(Box.createHorizontalGlue());
        b3.add(this.discDetLb);
        this.add(b3);
        this.add(Box.createHorizontalGlue());
    }

    private DiscDetIndepParams indTestParams() {
        return this.params;
    }
}

