/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.session.ModificationRegistery;
import edu.cmu.tetradapp.util.EditorWindowIndirectRef;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class EditorWindow
extends JInternalFrame
implements EditorWindowIndirectRef {
    private JPanel editor;
    private boolean canceled = false;
    private String buttonName;
    private Component centeringComp;

    public EditorWindow(JPanel editor, String title, String buttonName, boolean cancellable, Component centeringComp) {
        super(title, true, true, true, false);
        if (editor == null) {
            throw new NullPointerException("Editor must not be null.");
        }
        if (buttonName == null) {
            throw new NullPointerException("Button name must not be null.");
        }
        this.buttonName = buttonName;
        this.doSetup(editor, cancellable);
        this.centeringComp = centeringComp;
    }

    private void doSetup(JPanel editor, boolean cancellable) {
        this.editor = editor;
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void InternalFrameClosing(InternalFrameEvent evt) {
                EditorWindow.this.canceled = true;
                EditorWindow.this.closeDialog();
            }
        });
        JButton okButton = new JButton(this.buttonName);
        JButton cancelButton = new JButton("Cancel");
        okButton.setPreferredSize(new Dimension(70, 50));
        cancelButton.setPreferredSize(new Dimension(80, 50));
        okButton.addActionListener(new OkListener());
        cancelButton.addActionListener(new CancelListener());
        Box b0 = Box.createVerticalBox();
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        b.add(okButton);
        b.add(Box.createHorizontalStrut(5));
        if (cancellable) {
            b.add(cancelButton);
        }
        b.add(Box.createHorizontalGlue());
        b0.add(editor);
        b0.add(b);
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        JScrollPane scroll = new JScrollPane(b0);
        int width = Math.min(b0.getPreferredSize().width + 50, screensize.width);
        int height = Math.min(b0.getPreferredSize().height + 50, screensize.height - 100);
        scroll.setPreferredSize(new Dimension(width, height));
        if (b0.getPreferredSize().width > width || b0.getPreferredSize().height > height) {
            this.getContentPane().add(scroll);
        } else {
            this.getContentPane().add(b0);
        }
        JRootPane root = SwingUtilities.getRootPane(this);
        if (root != null) {
            root.setDefaultButton(okButton);
        }
        this.pack();
    }

    public void closeDialog() {
        this.setVisible(false);
        ModificationRegistery.unregisterEditor(this.getEditor());
        this.doDefaultCloseAction();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public JComponent getEditor() {
        return this.editor;
    }

    public Component getCenteringComp() {
        return this.centeringComp;
    }

    class CancelListener
    implements ActionListener {
        CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditorWindow.this.canceled = true;
            EditorWindow.this.closeDialog();
        }
    }

    class OkListener
    implements ActionListener {
        OkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditorWindow.this.closeDialog();
        }
    }
}

