/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.EvidenceEditor;
import edu.cmu.tetradapp.model.UpdaterWrapper;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.MatteBorder;

public class EvidenceWizardMultiple
extends JPanel {
    private UpdaterWrapper updaterWrapper;
    private GraphWorkbench workbench;
    private final EvidenceEditor evidenceEditor;
    private JTextArea textArea = new JTextArea("Nothing to display");

    public EvidenceWizardMultiple(UpdaterWrapper updaterWrapper, GraphWorkbench workbench) {
        if (updaterWrapper == null) {
            throw new NullPointerException();
        }
        if (workbench == null) {
            throw new NullPointerException();
        }
        this.updaterWrapper = updaterWrapper;
        this.workbench = workbench;
        workbench.setAllowDoubleClickActions(false);
        this.setBorder(new MatteBorder(10, 10, 10, 10, this.getBackground()));
        this.setLayout(new BoxLayout(this, 1));
        JButton calcMarginalsAndJointButton = new JButton("Calculate Marginals and Joint");
        Box b0 = Box.createHorizontalBox();
        b0.add(new JLabel("<html>Select a set of nodes (by holding down the shift key) whose<br>marginals you would like to see given the evidence indicated<br>above.  Click the 'Calculate Marginals' button to view<br>marginals and log odds results."));
        b0.add(Box.createHorizontalGlue());
        this.add(b0);
        this.add(Box.createVerticalStrut(10));
        this.evidenceEditor = new EvidenceEditor(updaterWrapper.getBayesUpdater().getEvidence());
        this.getUpdaterWrapper().getParams().setEvidence(this.evidenceEditor.getEvidence());
        this.add(this.evidenceEditor);
        this.add(Box.createVerticalStrut(10));
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createHorizontalGlue());
        b2.add(calcMarginalsAndJointButton);
        this.add(b2);
        this.add(Box.createVerticalGlue());
        calcMarginalsAndJointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<DisplayNode> selectedGraphNodes = EvidenceWizardMultiple.this.getWorkbench().getSelectedNodes();
                EvidenceWizardMultiple.this.getUpdaterWrapper().getBayesUpdater().setEvidence(EvidenceWizardMultiple.this.evidenceEditor.getEvidence());
                Graph updatedGraph = EvidenceWizardMultiple.this.getUpdaterWrapper().getBayesUpdater().getManipulatedGraph();
                EvidenceWizardMultiple.this.getWorkbench().setGraph(updatedGraph);
                BayesIm manipulatedIm = EvidenceWizardMultiple.this.getUpdaterWrapper().getBayesUpdater().getManipulatedBayesIm();
                LinkedList<Node> selectedNodes = new LinkedList<Node>();
                for (DisplayNode selectedGraphNode : selectedGraphNodes) {
                    Node tetradNode = selectedGraphNode.getModelNode();
                    String selectedNodeName = tetradNode.getName();
                    Node selectedNode = updatedGraph.getNode(selectedNodeName);
                    selectedNodes.add(selectedNode);
                }
                for (Node node : selectedNodes) {
                    EvidenceWizardMultiple.this.getWorkbench().selectNode(node);
                }
                Collections.sort(selectedNodes, new Comparator<Node>(){

                    @Override
                    public int compare(Node o1, Node o2) {
                        String name1 = o1.getName();
                        String name2 = o2.getName();
                        return name1.compareTo(name2);
                    }
                });
                JTextArea marginalsArea = new JTextArea();
                marginalsArea.setEditable(false);
                NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
                if (selectedNodes.size() == 0) {
                    marginalsArea.append("\nNo nodes selected.");
                } else {
                    EvidenceWizardMultiple.this.appendMarginals(selectedNodes, marginalsArea, manipulatedIm, nf);
                    EvidenceWizardMultiple.this.appendJoint(selectedNodes, marginalsArea, manipulatedIm, nf);
                }
                EvidenceWizardMultiple.this.textArea = marginalsArea;
                EvidenceWizardMultiple.this.firePropertyChange("updateButtonPressed", null, null);
            }
        });
    }

    private void appendMarginals(List<Node> selectedNodes, JTextArea marginalsArea, BayesIm manipulatedIm, NumberFormat nf) {
        BayesPm bayesPm = manipulatedIm.getBayesPm();
        marginalsArea.append("MARGINALS FOR SELECTED VARIABLES:\n");
        for (Node selectedNode : selectedNodes) {
            marginalsArea.append("\nVariable " + selectedNode.getName() + ":\n");
            int nodeIndex = manipulatedIm.getNodeIndex(selectedNode);
            for (int j = 0; j < bayesPm.getNumCategories(selectedNode); ++j) {
                double prob = this.getUpdaterWrapper().getBayesUpdater().getMarginal(nodeIndex, j);
                double logOdds = Math.log(prob / (1.0 - prob));
                marginalsArea.append("Category " + bayesPm.getCategory(selectedNode, j) + ": p = " + nf.format(prob) + ",  log odds = " + nf.format(logOdds) + "\n");
            }
        }
    }

    private void appendJoint(List<Node> selectedNodes, JTextArea marginalsArea, BayesIm manipulatedIm, NumberFormat nf) {
        int i;
        if (!this.getUpdaterWrapper().getBayesUpdater().isJointMarginalSupported()) {
            marginalsArea.append("\n\n(Calculation of joint not supported for this updater.)");
            return;
        }
        BayesPm bayesPm = manipulatedIm.getBayesPm();
        int numNodes = selectedNodes.size();
        int[] dims = new int[numNodes];
        int[] variables = new int[numNodes];
        int numRows = 1;
        for (i = 0; i < numNodes; ++i) {
            Node node = selectedNodes.get(i);
            int numCategories = bayesPm.getNumCategories(node);
            variables[i] = manipulatedIm.getNodeIndex(node);
            dims[i] = numCategories;
            numRows *= numCategories;
        }
        marginalsArea.append("\n\nJOINT OVER SELECTED VARIABLES:\n\n");
        for (i = 0; i < numNodes; ++i) {
            marginalsArea.append(selectedNodes.get(i) + "\t");
        }
        marginalsArea.append("Joint\tLog odds\n");
        for (int row = 0; row < numRows; ++row) {
            int[] values = this.getCategories(row, dims);
            double prob = this.getUpdaterWrapper().getBayesUpdater().getJointMarginal(variables, values);
            double logOdds = Math.log(prob / (1.0 - prob));
            marginalsArea.append("\n");
            for (int j = 0; j < numNodes; ++j) {
                Node node = selectedNodes.get(j);
                marginalsArea.append(bayesPm.getCategory(node, values[j]));
                marginalsArea.append("\t");
            }
            marginalsArea.append(nf.format(prob) + "\t");
            marginalsArea.append(nf.format(logOdds));
        }
    }

    private int[] getCategories(int row, int[] dims) {
        int[] values = new int[dims.length];
        for (int i = dims.length - 1; i >= 0; --i) {
            values[i] = row % dims[i];
            row /= dims[i];
        }
        return values;
    }

    public BayesIm getBayesIM() {
        return this.getUpdaterWrapper().getBayesUpdater().getUpdatedBayesIm();
    }

    private UpdaterWrapper getUpdaterWrapper() {
        return this.updaterWrapper;
    }

    private GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }
}

