/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import java.util.Vector;

public class FactorAnalysis {
    public CovarianceMatrix covarianceMatrix;
    public CorrelationMatrix correlationMatrix;
    public Vector<Double> dValues;
    public Vector<DoubleMatrix2D> factorLoadingVectors;
    public Vector<DoubleMatrix2D> residualMatrices;

    public FactorAnalysis(CovarianceMatrix covarianceMatrix) {
        this.covarianceMatrix = covarianceMatrix;
        this.correlationMatrix = new CorrelationMatrix(covarianceMatrix);
    }

    public FactorAnalysis(DataSet dataSet) {
        this.covarianceMatrix = new CovarianceMatrix(dataSet);
        this.correlationMatrix = new CorrelationMatrix(dataSet);
    }

    public void unity(CorrelationMatrix r) {
        DoubleMatrix2D residual = r.getMatrix();
        for (int i = 0; i < residual.columns(); ++i) {
            residual.set(i, i, 1.0);
        }
    }

    public void largestNonDiagonalMagnitude(CorrelationMatrix r) {
        DoubleMatrix2D residual = r.getMatrix();
        for (int i = 0; i < residual.columns(); ++i) {
            double max = 0.0;
            for (int j = 0; j < residual.columns(); ++j) {
                double temp;
                if (i == j || !((temp = Math.abs(residual.get(j, i))) > max)) continue;
                max = temp;
            }
            residual.set(i, i, max);
        }
    }

    public DenseDoubleMatrix2D successiveResidual() {
        this.factorLoadingVectors = new Vector();
        this.residualMatrices = new Vector();
        this.dValues = new Vector();
        this.residualMatrices.add((DenseDoubleMatrix2D)this.correlationMatrix.getMatrix());
        DenseDoubleMatrix2D unitVector = new DenseDoubleMatrix2D(this.correlationMatrix.getMatrix().rows(), 1);
        for (int i = 0; i < unitVector.rows(); ++i) {
            unitVector.set(i, 0, 1.0);
        }
        this.successiveResidualHelper(this.residualMatrices.lastElement(), unitVector);
        int failSafe = 0;
        while (FactorAnalysis.vectorSum(this.dValues) / FactorAnalysis.trace((DenseDoubleMatrix2D)this.correlationMatrix.getMatrix()) < 0.99) {
            DoubleMatrix2D residual = FactorAnalysis.matrixSubtract(this.residualMatrices.lastElement(), FactorAnalysis.matrixMult(this.factorLoadingVectors.lastElement(), FactorAnalysis.transpose(this.factorLoadingVectors.lastElement())));
            this.residualMatrices.add(residual);
            if (this.successiveResidualHelper(this.residualMatrices.lastElement(), unitVector) && ++failSafe <= 500) continue;
            break;
        }
        DenseDoubleMatrix2D result = new DenseDoubleMatrix2D(this.correlationMatrix.getMatrix().rows(), this.factorLoadingVectors.size());
        for (int i = 0; i < result.rows(); ++i) {
            for (int j = 0; j < result.columns(); ++j) {
                result.set(i, j, this.factorLoadingVectors.get(j).get(i, 0));
            }
        }
        return result;
    }

    public boolean successiveResidualHelper(DoubleMatrix2D residual, DoubleMatrix2D approximationVector) {
        DoubleMatrix2D uVector = FactorAnalysis.matrixMult(residual, approximationVector);
        DoubleMatrix2D lVector = FactorAnalysis.matrixMult(FactorAnalysis.transpose(approximationVector), uVector);
        double dScalar = Math.sqrt(lVector.get(0, 0));
        DenseDoubleMatrix2D aVector = FactorAnalysis.matrixDiv(dScalar, uVector);
        Vector<DenseDoubleMatrix2D> factorLoadings = new Vector<DenseDoubleMatrix2D>();
        Vector<DoubleMatrix2D> uVectors = new Vector<DoubleMatrix2D>();
        Vector<Double> dScalars = new Vector<Double>();
        factorLoadings.add(aVector);
        uVectors.add(uVector);
        dScalars.add(dScalar);
        for (int i = 0; i < 100; ++i) {
            DenseDoubleMatrix2D oldFactorLoading = (DenseDoubleMatrix2D)factorLoadings.lastElement();
            DoubleMatrix2D newUVector = FactorAnalysis.matrixMult(residual, (DoubleMatrix2D)((DenseDoubleMatrix2D)factorLoadings.lastElement()));
            uVectors.add(newUVector);
            DoubleMatrix2D newLScalar = FactorAnalysis.matrixMult(FactorAnalysis.transpose(oldFactorLoading), newUVector);
            double newDScalar = Math.sqrt(newLScalar.get(0, 0));
            dScalars.add(newDScalar);
            DenseDoubleMatrix2D newFactorLoading = FactorAnalysis.matrixDiv(newDScalar, newUVector);
            factorLoadings.add(newFactorLoading);
            if (Math.abs(newDScalar / (Double)dScalars.get(dScalars.size() - 2) - 1.0) < 1.0E-5) break;
        }
        if ((Double)dScalars.lastElement() < 1.0) {
            return false;
        }
        this.dValues.add((Double)dScalars.lastElement());
        this.factorLoadingVectors.add((DenseDoubleMatrix2D)factorLoadings.lastElement());
        return true;
    }

    public static DenseDoubleMatrix2D diag(DoubleMatrix2D matrix) {
        DenseDoubleMatrix2D diagonal = new DenseDoubleMatrix2D(matrix.columns(), matrix.columns());
        for (int i = 0; i < matrix.columns(); ++i) {
            for (int j = 0; j < matrix.columns(); ++j) {
                if (i == j) {
                    diagonal.set(j, i, matrix.get(i, i));
                    continue;
                }
                diagonal.set(j, i, 0.0);
            }
        }
        return diagonal;
    }

    public static DenseDoubleMatrix2D diag(DataSet dataSet) {
        return FactorAnalysis.diag(dataSet.getDoubleData());
    }

    public static DenseDoubleMatrix2D diag(CovarianceMatrix covMatrix) {
        return FactorAnalysis.diag(covMatrix.getMatrix());
    }

    public static DenseDoubleMatrix2D diag(CorrelationMatrix corMatrix) {
        return FactorAnalysis.diag(corMatrix.getMatrix());
    }

    public static DoubleMatrix2D matrixSubtract(DoubleMatrix2D a, DoubleMatrix2D b) {
        if (a.columns() != b.columns() || a.rows() != b.rows()) {
            return null;
        }
        DenseDoubleMatrix2D result = new DenseDoubleMatrix2D(a.rows(), a.columns());
        for (int i = 0; i < result.rows(); ++i) {
            for (int j = 0; j < result.columns(); ++j) {
                result.set(i, j, a.get(i, j) - b.get(i, j));
            }
        }
        return result;
    }

    public static DoubleMatrix2D matrixMult(DoubleMatrix2D a, DoubleMatrix2D b) {
        if (a.columns() != b.rows()) {
            return null;
        }
        DenseDoubleMatrix2D result = new DenseDoubleMatrix2D(a.rows(), b.columns());
        for (int i = 0; i < a.rows(); ++i) {
            for (int j = 0; j < b.columns(); ++j) {
                double value = 0.0;
                for (int k = 0; k < b.rows(); ++k) {
                    value += a.get(i, k) * b.get(k, j);
                }
                result.set(i, j, value);
            }
        }
        return result;
    }

    public static DenseDoubleMatrix2D matrixMult(double scalar, DoubleMatrix2D a) {
        DenseDoubleMatrix2D result = new DenseDoubleMatrix2D(a.rows(), a.columns());
        for (int i = 0; i < a.rows(); ++i) {
            for (int j = 0; j < a.columns(); ++j) {
                result.set(i, j, scalar * a.get(i, j));
            }
        }
        return result;
    }

    public static DenseDoubleMatrix2D matrixAdd(DenseDoubleMatrix2D a, DenseDoubleMatrix2D b) {
        if (a.rows() != b.rows() || a.columns() != b.columns()) {
            return null;
        }
        DenseDoubleMatrix2D result = new DenseDoubleMatrix2D(a.rows(), a.columns());
        for (int i = 0; i < a.rows(); ++i) {
            for (int j = 0; j < a.columns(); ++j) {
                result.set(j, i, a.get(j, i) + b.get(j, i));
            }
        }
        return result;
    }

    public static DenseDoubleMatrix2D matrixDiv(double scalar, DoubleMatrix2D a) {
        DenseDoubleMatrix2D result = new DenseDoubleMatrix2D(a.rows(), a.columns());
        for (int i = 0; i < a.rows(); ++i) {
            for (int j = 0; j < a.columns(); ++j) {
                result.set(i, j, a.get(i, j) / scalar);
            }
        }
        return result;
    }

    public static DoubleMatrix2D transpose(DoubleMatrix2D a) {
        DenseDoubleMatrix2D result = new DenseDoubleMatrix2D(a.columns(), a.rows());
        for (int i = 0; i < a.columns(); ++i) {
            for (int j = 0; j < a.rows(); ++j) {
                result.set(i, j, a.get(j, i));
            }
        }
        return result;
    }

    public static double trace(DoubleMatrix2D a) {
        double result = 0.0;
        for (int i = 0; i < a.columns(); ++i) {
            result += a.get(i, i);
        }
        return result;
    }

    public static double vectorSum(Vector<Double> vector) {
        double sum = 0.0;
        for (int i = 0; i < vector.size(); ++i) {
            sum += vector.get(i).doubleValue();
        }
        return sum;
    }

    public static DoubleMatrix2D normalizeRows(DoubleMatrix2D matrix) {
        int j;
        Vector<DoubleMatrix2D> normalizedRows = new Vector<DoubleMatrix2D>();
        for (int i = 0; i < matrix.rows(); ++i) {
            DoubleMatrix1D vector = matrix.viewRow(i);
            DenseDoubleMatrix2D colVector = new DenseDoubleMatrix2D(matrix.columns(), 1);
            for (j = 0; j < matrix.columns(); ++j) {
                colVector.set(j, 0, vector.get(j));
            }
            normalizedRows.add(FactorAnalysis.normalizeVector(colVector));
        }
        DenseDoubleMatrix2D result = new DenseDoubleMatrix2D(matrix.rows(), matrix.columns());
        for (int i = 0; i < matrix.rows(); ++i) {
            DoubleMatrix2D normalizedRow = (DoubleMatrix2D)normalizedRows.get(i);
            for (j = 0; j < matrix.columns(); ++j) {
                result.set(i, j, normalizedRow.get(j, 0));
            }
        }
        return result;
    }

    public static DoubleMatrix2D normalizeVector(DoubleMatrix2D vector) {
        double scalar = Math.sqrt(FactorAnalysis.matrixMult(FactorAnalysis.transpose(vector), vector).get(0, 0));
        return FactorAnalysis.matrixDiv(scalar, vector);
    }

    public static DoubleMatrix2D matrixExp(DoubleMatrix2D matrix, double exponent) {
        DenseDoubleMatrix2D result = new DenseDoubleMatrix2D(matrix.rows(), matrix.columns());
        for (int i = 0; i < matrix.rows(); ++i) {
            for (int j = 0; j < matrix.columns(); ++j) {
                result.set(i, j, Math.pow(matrix.get(i, j), exponent));
            }
        }
        return result;
    }

    public static DoubleMatrix2D successiveFactorVarimax(DoubleMatrix2D factorLoadingMatrix) {
        if (factorLoadingMatrix.columns() == 1) {
            return factorLoadingMatrix;
        }
        Vector<DoubleMatrix2D> residuals = new Vector<DoubleMatrix2D>();
        Vector rotatedFactorVectors = new Vector();
        Vector<DoubleMatrix2D> vVectors = new Vector<DoubleMatrix2D>();
        DoubleMatrix2D normalizedFactorLoadings = FactorAnalysis.normalizeRows(factorLoadingMatrix);
        residuals.add(normalizedFactorLoadings);
        DenseDoubleMatrix2D unitColumn = new DenseDoubleMatrix2D(factorLoadingMatrix.rows(), 1);
        for (int i = 0; i < factorLoadingMatrix.rows(); ++i) {
            unitColumn.set(i, 0, 1.0);
        }
        DoubleMatrix2D sumCols = FactorAnalysis.matrixMult(FactorAnalysis.transpose((DoubleMatrix2D)residuals.lastElement()), (DoubleMatrix2D)unitColumn);
        DenseDoubleMatrix2D wVector = FactorAnalysis.matrixDiv(Math.sqrt(FactorAnalysis.matrixMult(FactorAnalysis.matrixMult(FactorAnalysis.transpose(unitColumn), (DoubleMatrix2D)residuals.lastElement()), sumCols).get(0, 0)), sumCols);
        DoubleMatrix2D vVector = FactorAnalysis.matrixMult((DoubleMatrix2D)residuals.lastElement(), (DoubleMatrix2D)wVector);
        vVectors.add(vVector);
        for (int k = 0; k < normalizedFactorLoadings.columns(); ++k) {
            int lIndex = 0;
            double minValue = 1.0E9;
            for (int i = 0; i < vVector.rows(); ++i) {
                if (!(vVector.get(i, 0) < minValue)) continue;
                minValue = vVector.get(i, 0);
                lIndex = i;
            }
            Vector<DenseDoubleMatrix2D> hVectors = new Vector<DenseDoubleMatrix2D>();
            Vector<DoubleMatrix2D> bVectors = new Vector<DoubleMatrix2D>();
            Vector<Double> alphas = new Vector<Double>();
            hVectors.add(new DenseDoubleMatrix2D(((DoubleMatrix2D)residuals.lastElement()).columns(), 1));
            DoubleMatrix1D rowFromFactorLoading = ((DoubleMatrix2D)residuals.lastElement()).viewRow(lIndex);
            for (int j = 0; j < ((DoubleMatrix2D)hVectors.lastElement()).rows(); ++j) {
                ((DoubleMatrix2D)hVectors.lastElement()).set(j, 0, rowFromFactorLoading.get(j));
            }
            boolean firstRun = true;
            for (int i = 0; i < 50; ++i) {
                DoubleMatrix2D bVector = FactorAnalysis.matrixMult((DoubleMatrix2D)residuals.lastElement(), (DoubleMatrix2D)hVectors.get(i));
                double averageSumSquaresBVector = FactorAnalysis.matrixDiv(bVector.rows(), FactorAnalysis.matrixMult(FactorAnalysis.transpose(unitColumn), FactorAnalysis.matrixExp(bVector, 2.0))).get(0, 0);
                DoubleMatrix2D betaVector = FactorAnalysis.matrixSubtract(FactorAnalysis.matrixExp(bVector, 3.0), FactorAnalysis.matrixMult(averageSumSquaresBVector, bVector));
                DoubleMatrix2D uVector = FactorAnalysis.matrixMult(FactorAnalysis.transpose((DoubleMatrix2D)residuals.lastElement()), betaVector);
                alphas.add(Math.sqrt(FactorAnalysis.matrixMult(FactorAnalysis.transpose(uVector), uVector).get(0, 0)));
                bVectors.add(bVector);
                hVectors.add(FactorAnalysis.matrixDiv((Double)alphas.lastElement(), uVector));
                if (!firstRun && Math.abs((Double)alphas.lastElement() / (Double)alphas.get(alphas.size() - 2) - 1.0) < 1.0E-4) break;
                firstRun = false;
            }
            rotatedFactorVectors.add(bVectors.lastElement());
            residuals.add(FactorAnalysis.matrixSubtract((DoubleMatrix2D)residuals.lastElement(), FactorAnalysis.matrixMult((DoubleMatrix2D)bVectors.lastElement(), FactorAnalysis.transpose((DoubleMatrix2D)hVectors.lastElement()))));
        }
        DenseDoubleMatrix2D result = new DenseDoubleMatrix2D(factorLoadingMatrix.rows(), factorLoadingMatrix.columns());
        for (int i = 0; i < ((DoubleMatrix2D)rotatedFactorVectors.get(0)).rows(); ++i) {
            for (int j = 0; j < rotatedFactorVectors.size(); ++j) {
                result.set(i, j, ((DoubleMatrix2D)rotatedFactorVectors.get(j)).get(i, 0));
            }
        }
        return result;
    }
}

