/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.DataEditor;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.FactorAnalysis;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.TextTable;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class FactorAnalysisAction
extends AbstractAction {
    private DataEditor dataEditor;

    public FactorAnalysisAction(DataEditor editor) {
        super("Factor Analysis...");
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataSet dataSet = (DataSet)this.dataEditor.getSelectedDataModel();
        if (dataSet == null || dataSet.getNumColumns() == 0) {
            JOptionPane.showMessageDialog(this.findOwner(), "Cannot perform factor analysis on an empty data set.");
            return;
        }
        FactorAnalysis factorAnalysis = new FactorAnalysis(dataSet);
        JPanel panel = this.createDialog(factorAnalysis);
        EditorWindow window = new EditorWindow(panel, "Factor Loading Matrices", "Close", false, this.dataEditor);
        DesktopController.getInstance().addEditorWindow(window, JLayeredPane.PALETTE_LAYER);
        window.setVisible(true);
    }

    public JPanel createDialog(FactorAnalysis analysis) {
        int i;
        double threshold = 0.2;
        DenseDoubleMatrix2D unrotatedSolution = analysis.successiveResidual();
        DoubleMatrix2D rotatedSolution = FactorAnalysis.successiveFactorVarimax(unrotatedSolution);
        DataSet dataSet = (DataSet)this.dataEditor.getSelectedDataModel();
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        String output = "Unrotated Factor Loading Matrix:\n";
        output = output + this.tableString(unrotatedSolution, nf, Double.POSITIVE_INFINITY);
        if (unrotatedSolution.columns() != 1) {
            output = output + "\n\nRotated Matrix (using sequential varimax):\n";
            output = output + this.tableString(rotatedSolution, nf, threshold);
        }
        JTextArea display = new JTextArea(output);
        JScrollPane scrollPane = new JScrollPane(display);
        scrollPane.setPreferredSize(new Dimension(500, 400));
        display.setEditable(false);
        display.setFont(new Font("Monospaced", 0, 12));
        SemGraph graph = new SemGraph();
        Vector<Node> observedVariables = new Vector<Node>();
        for (Node a : dataSet.getVariables()) {
            graph.addNode(a);
            observedVariables.add(a);
        }
        Vector<ContinuousVariable> factors = new Vector<ContinuousVariable>();
        for (i = 0; i < rotatedSolution.columns(); ++i) {
            ContinuousVariable factor = new ContinuousVariable("Factor" + (i + 1));
            factor.setNodeType(NodeType.LATENT);
            graph.addNode(factor);
            factors.add(factor);
        }
        for (i = 0; i < rotatedSolution.rows(); ++i) {
            for (int j = 0; j < rotatedSolution.columns(); ++j) {
                if (!(Math.abs(rotatedSolution.get(i, j)) > threshold)) continue;
                graph.addDirectedEdge((Node)factors.get(j), (Node)observedVariables.get(i));
            }
        }
        GraphUtils.arrangeInCircle(graph, 225, 200, 150);
        GraphUtils.fruchtermanReingoldLayout(graph);
        GraphWorkbench workbench = new GraphWorkbench(graph);
        JScrollPane graphPane = new JScrollPane(workbench);
        graphPane.setPreferredSize(new Dimension(500, 400));
        Box box = Box.createHorizontalBox();
        box.add(scrollPane);
        box.add(Box.createHorizontalStrut(3));
        box.add(Box.createHorizontalStrut(5));
        box.add(Box.createHorizontalGlue());
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(15));
        vBox.add(box);
        vBox.add(Box.createVerticalStrut(5));
        box.add(graphPane);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)vBox, "Center");
        return panel;
    }

    private String tableString(DoubleMatrix2D matrix, NumberFormat nf, double threshold) {
        TextTable table = new TextTable(matrix.rows() + 1, matrix.columns() + 1);
        for (int i = 0; i < matrix.rows() + 1; ++i) {
            for (int j = 0; j < matrix.columns() + 1; ++j) {
                if (i > 0 && j == 0) {
                    table.setToken(i, j, "X" + i);
                    continue;
                }
                if (i == 0 && j > 0) {
                    table.setToken(i, j, "Factor " + j);
                    continue;
                }
                if (i <= 0 || j <= 0) continue;
                double coefficient = matrix.get(i - 1, j - 1);
                String token = !Double.isNaN(coefficient) ? nf.format(coefficient) : "Undefined";
                token = token + (Math.abs(coefficient) > threshold ? "*" : " ");
                table.setToken(i, j, token);
            }
        }
        return table.toString();
    }

    private JFrame findOwner() {
        return (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.dataEditor);
    }

    public static void main(String[] args) {
        Dag graph = GraphUtils.randomDag(9, 9, false);
        SemPm pm = new SemPm(graph);
        SemIm im = new SemIm(pm);
        DataSet data = im.simulateData(500, false);
        CovarianceMatrix cov = new CovarianceMatrix(data);
        FactorAnalysis factorAnalysis = new FactorAnalysis(cov);
        factorAnalysis.successiveResidual();
    }
}

