/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.ScoredGraph;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.editor.GraphEditable;
import edu.cmu.tetradapp.editor.Indexable;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GesDisplay
extends JPanel
implements GraphEditable {
    private GraphWorkbench workbench;
    private List<ScoredGraph> topGraphs;
    private JSpinner spinner = new JSpinner();
    private JLabel totalLabel;
    private NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private JLabel scoreLabel;
    private Indexable indexable;

    public GesDisplay(List<ScoredGraph> topGraphs, Indexable indexable) {
        this.indexable = indexable;
        this.topGraphs = topGraphs;
        int numPatterns = topGraphs.size();
        this.workbench = topGraphs.size() == 0 ? new GraphWorkbench() : new GraphWorkbench(topGraphs.get(indexable.getIndex()).getGraph());
        this.scoreLabel = new JLabel();
        this.setPattern();
        final SpinnerNumberModel model = new SpinnerNumberModel(numPatterns == 0 ? 1 : indexable.getIndex() + 1, 1, numPatterns, 1);
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GesDisplay.this.getIndexable().setIndex((Integer)model.getValue() - 1);
                GesDisplay.this.setPattern();
            }
        });
        this.spinner.setModel(model);
        this.totalLabel = new JLabel(" of " + numPatterns);
        this.spinner.setPreferredSize(new Dimension(50, 20));
        this.spinner.setMaximumSize(this.spinner.getPreferredSize());
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(Box.createHorizontalGlue());
        b1.add(new JLabel(" Score = "));
        b1.add(this.scoreLabel);
        b1.add(new JLabel(" Pattern "));
        b1.add(this.spinner);
        b1.add(this.totalLabel);
        b.add(b1);
        Box b2 = Box.createHorizontalBox();
        JPanel graphPanel = new JPanel();
        graphPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.workbench);
        graphPanel.add(jScrollPane);
        b2.add(graphPanel);
        b.add(b2);
        this.setLayout(new BorderLayout());
        this.add((Component)b, "Center");
    }

    private void setPattern() {
        this.setDisplayGraph();
        this.setDisplayScore();
    }

    private void setDisplayGraph() {
        int index = this.getIndexable().getIndex();
        ScoredGraph scoredGraph = this.topGraphs.get(index);
        this.workbench.setGraph(scoredGraph.getGraph());
    }

    private void setDisplayScore() {
        if (this.topGraphs.isEmpty()) {
            this.scoreLabel.setText("*");
        } else {
            this.scoreLabel.setText(this.nf.format(this.topGraphs.get(this.getIndexable().getIndex()).getScore()));
        }
    }

    private void resetDisplay() {
        int numPatterns = this.topGraphs.size();
        int min = 1;
        final SpinnerNumberModel model = new SpinnerNumberModel(numPatterns == 0 ? 1 : numPatterns, min, numPatterns, 1);
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GesDisplay.this.getIndexable().setIndex((Integer)model.getValue() - 1);
                GesDisplay.this.setPattern();
            }
        });
        this.spinner.setModel(model);
        this.totalLabel.setText(" of " + numPatterns);
        if (numPatterns == 0) {
            this.workbench.setGraph(null);
        } else {
            this.workbench.setGraph(this.topGraphs.get(numPatterns - 1).getGraph());
        }
        this.setDisplayScore();
    }

    public void resetGraphs(List<ScoredGraph> topGraphs) {
        this.topGraphs = topGraphs;
        this.resetDisplay();
    }

    @Override
    public List getSelectedModelComponents() {
        Component[] components = this.getWorkbench().getComponents();
        ArrayList<TetradSerializable> selectedModelComponents = new ArrayList<TetradSerializable>();
        for (Component comp : components) {
            if (comp instanceof DisplayNode) {
                selectedModelComponents.add(((DisplayNode)comp).getModelNode());
                continue;
            }
            if (!(comp instanceof DisplayEdge)) continue;
            selectedModelComponents.add(((DisplayEdge)comp).getModelEdge());
        }
        return selectedModelComponents;
    }

    @Override
    public void pasteSubsession(List sessionElements, Point upperLeft) {
        this.getWorkbench().pasteSubgraph(sessionElements, upperLeft);
        this.getWorkbench().deselectAll();
        for (int i = 0; i < sessionElements.size(); ++i) {
            Object o = sessionElements.get(i);
            if (!(o instanceof GraphNode)) continue;
            Node modelNode = (Node)o;
            this.getWorkbench().selectNode(modelNode);
        }
        this.getWorkbench().selectConnectingEdges();
    }

    @Override
    public GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    @Override
    public Graph getGraph() {
        return this.workbench.getGraph();
    }

    @Override
    public void setGraph(Graph graph) {
        this.workbench.setGraph(graph);
    }

    public List<ScoredGraph> getTopGraphs() {
        return this.topGraphs;
    }

    private Indexable getIndexable() {
        return this.indexable;
    }

    private void setIndexable(Indexable indexable) {
        this.indexable = indexable;
    }
}

