/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetradapp.model.GesIndTestParams;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

class GesIndTestParamsEditor
extends JComponent {
    private GesIndTestParams params;
    private DoubleTextField cellPriorField;
    private DoubleTextField structurePriorField;
    private JButton defaultStructurePrior;
    private JButton uniformStructurePrior;
    private boolean discreteData;
    private DoubleTextField penaltyDiscount;
    private IntTextField numPatternsToSave;

    public GesIndTestParamsEditor(GesIndTestParams simulator, boolean discreteData) {
        this.params = simulator;
        this.discreteData = discreteData;
        DecimalFormat nf = new DecimalFormat("0.0####");
        if (this.discreteData) {
            this.cellPriorField = new DoubleTextField(this.getGesIndTestParams().getCellPrior(), 5, nf);
            this.cellPriorField.setFilter(new DoubleTextField.Filter(){

                @Override
                public double filter(double value, double oldValue) {
                    try {
                        GesIndTestParamsEditor.this.getGesIndTestParams().setCellPrior(value);
                        return value;
                    }
                    catch (IllegalArgumentException e) {
                        return oldValue;
                    }
                }
            });
            this.structurePriorField = new DoubleTextField(this.getGesIndTestParams().getStructurePrior(), 5, nf);
            this.structurePriorField.setFilter(new DoubleTextField.Filter(){

                @Override
                public double filter(double value, double oldValue) {
                    try {
                        GesIndTestParamsEditor.this.getGesIndTestParams().setStructurePrior(value);
                        return value;
                    }
                    catch (IllegalArgumentException e) {
                        return oldValue;
                    }
                }
            });
            this.defaultStructurePrior = new JButton("Default structure prior = 0.05");
            Font font = new Font("Dialog", 1, 10);
            this.defaultStructurePrior.setFont(font);
            this.defaultStructurePrior.setBorder(null);
            this.defaultStructurePrior.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GesIndTestParamsEditor.this.structurePriorField.setValue(0.05);
                }
            });
            this.uniformStructurePrior = new JButton("Uniform structure prior = 1.0");
            this.uniformStructurePrior.setFont(font);
            this.uniformStructurePrior.setBorder(null);
            this.uniformStructurePrior.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GesIndTestParamsEditor.this.structurePriorField.setValue(1.0);
                }
            });
        } else {
            this.penaltyDiscount = new DoubleTextField(this.getGesIndTestParams().getPenaltyDiscount(), 5, nf);
            this.penaltyDiscount.setFilter(new DoubleTextField.Filter(){

                @Override
                public double filter(double value, double oldValue) {
                    try {
                        GesIndTestParamsEditor.this.getGesIndTestParams().setPenaltyDiscount(value);
                        return value;
                    }
                    catch (IllegalArgumentException e) {
                        return oldValue;
                    }
                }
            });
        }
        this.numPatternsToSave = new IntTextField(this.getGesIndTestParams().getNumPatternsToSave(), 5);
        this.numPatternsToSave.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    GesIndTestParamsEditor.this.getGesIndTestParams().setNumPatternsToSave(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        this.buildGui();
    }

    private void buildGui() {
        this.setLayout(new BoxLayout(this, 1));
        if (this.discreteData) {
            Box b0 = Box.createHorizontalBox();
            b0.add(new JLabel("BDeu:"));
            b0.add(Box.createHorizontalGlue());
            this.add(b0);
            this.add(Box.createVerticalStrut(5));
            Box b2 = Box.createHorizontalBox();
            b2.add(Box.createHorizontalStrut(5));
            b2.add(new JLabel("Sample prior:"));
            b2.add(Box.createHorizontalGlue());
            b2.add(this.cellPriorField);
            this.add(b2);
            this.add(Box.createVerticalStrut(5));
            Box b3 = Box.createHorizontalBox();
            b3.add(Box.createHorizontalStrut(5));
            b3.add(new JLabel("Structure prior:"));
            b3.add(Box.createHorizontalGlue());
            b3.add(this.structurePriorField);
            this.add(b3);
            Box b4 = Box.createHorizontalBox();
            b4.add(Box.createHorizontalGlue());
            b4.add(this.defaultStructurePrior);
            this.add(b4);
            Box b5 = Box.createHorizontalBox();
            b5.add(Box.createHorizontalGlue());
            b5.add(this.uniformStructurePrior);
            this.add(b5);
            this.add(Box.createVerticalStrut(10));
        } else {
            Box b7 = Box.createHorizontalBox();
            b7.add(new JLabel("Penalty Discount"));
            b7.add(Box.createHorizontalGlue());
            b7.add(this.penaltyDiscount);
            this.add(b7);
            this.add(Box.createHorizontalGlue());
        }
        Box b8 = Box.createHorizontalBox();
        b8.add(new JLabel("Num Patterns to Save"));
        b8.add(Box.createHorizontalGlue());
        b8.add(this.numPatternsToSave);
        this.add(b8);
    }

    private GesIndTestParams getGesIndTestParams() {
        return this.params;
    }
}

