/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.ContinuousDiscretizationSpec;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.Discretizer;
import edu.cmu.tetrad.graph.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Histogram {
    private DataSet dataSet;
    private double[] values;
    private Node selectedVariable;
    private double min = 0.0;
    private double max = 0.0;
    private int[] frequencies;
    private int categories = 2;
    private List<ConditionalDependency> conditions = new ArrayList<ConditionalDependency>();

    public Histogram(DataSet dataSet, Node selectedNode, int categories) {
        if (dataSet == null) {
            throw new NullPointerException("the given dataset must not be null");
        }
        if (dataSet.getNumColumns() == 0) {
            throw new IllegalArgumentException("The given dataset should not be empty");
        }
        if (categories < 2) {
            throw new IllegalArgumentException("Category must be at least 2");
        }
        this.dataSet = dataSet;
        if (selectedNode == null && dataSet.getNumColumns() != 0) {
            int[] selected = dataSet.getSelectedIndices();
            selectedNode = selected == null || selected.length == 0 ? dataSet.getVariable(0) : dataSet.getVariable(selected[0]);
        }
        this.setCategories(selectedNode, categories);
        this.setSelectedVariable(selectedNode);
    }

    public Histogram(Histogram histogram, int categories) {
        this.dataSet = histogram.dataSet;
        this.selectedVariable = histogram.selectedVariable;
        this.conditions = histogram.conditions;
        this.setCategories(this.selectedVariable, categories);
    }

    public Histogram(Histogram histogram, List<ConditionalDependency> dependencies) {
        this.dataSet = histogram.dataSet;
        this.selectedVariable = histogram.selectedVariable;
        this.categories = histogram.categories;
        this.conditions = dependencies;
        for (ConditionalDependency condition : dependencies) {
            condition.column = this.dataSet.getColumn(condition.node);
        }
    }

    public List<ConditionalDependency> getConditionalDependencies() {
        return Collections.unmodifiableList(this.conditions);
    }

    public int getNumberOfCategories() {
        return this.categories;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public double getMaxValue() {
        return this.max;
    }

    public double getMinValue() {
        return this.min;
    }

    public Node getSelectedVariable() {
        return this.selectedVariable;
    }

    public int[] getFrequencies() {
        this.buildHistogramData();
        int[] freqs = new int[this.frequencies.length];
        System.arraycopy(this.frequencies, 0, freqs, 0, this.frequencies.length);
        return freqs;
    }

    private void setCategories(Node selectedNode, int categories) {
        this.categories = selectedNode instanceof DiscreteVariable ? Math.min(((DiscreteVariable)selectedNode).getCategories().size(), categories) : categories;
    }

    private double[] getValues() {
        if (this.values == null) {
            int column = this.dataSet.getColumn(this.selectedVariable);
            int rows = this.dataSet.getNumRows();
            this.values = new double[rows];
            for (int i = 0; i < rows; ++i) {
                boolean satisfied = true;
                for (ConditionalDependency condition : this.conditions) {
                    Object value;
                    if (condition.satisfied(value = this.dataSet.getObject(i, condition.column))) continue;
                    satisfied = false;
                    break;
                }
                if (!satisfied) continue;
                this.values[i] = this.dataSet.getDouble(i, column);
            }
        }
        return this.values;
    }

    private ContinuousDiscretizationSpec calculateSpec() {
        this.calculateMinMax();
        double[] breakPoints = Histogram.defaultBreakpoints(this.max, this.min, this.categories);
        LinkedList<String> categories = new LinkedList<String>();
        for (int i = 1; i <= this.categories; ++i) {
            categories.add(String.valueOf(i));
        }
        return new ContinuousDiscretizationSpec(breakPoints, categories);
    }

    private void calculateMinMax() {
        double[] values = this.getValues();
        if (values.length == 0) {
            this.min = 0.0;
            this.max = 8.0E-10;
            return;
        }
        double min = values[0];
        double max = values[0];
        for (double value : this.getValues()) {
            if (!Double.isNaN(value) && value != Double.NEGATIVE_INFINITY && value != Double.POSITIVE_INFINITY && value < min) {
                min = value;
            }
            if (Double.isNaN(value) || value == Double.NEGATIVE_INFINITY || value == Double.POSITIVE_INFINITY || !(max < value)) continue;
            max = value;
        }
        if (min == max) {
            this.max = this.min + 8.0E-10;
        }
        this.min = min;
        this.max = max;
    }

    private static double[] defaultBreakpoints(double max, double min, int numCategories) {
        if (Double.isNaN(max) || max == Double.NEGATIVE_INFINITY || max == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("Max cannot be NaN or positive or negative infinity: " + max);
        }
        if (Double.isNaN(min) || min == Double.NEGATIVE_INFINITY || min == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("Min cannot be NaN or positive or negative infinity: " + min);
        }
        double interval = (max - min) / (double)numCategories;
        double[] breakpoints = new double[numCategories - 1];
        for (int i = 0; i < breakpoints.length; ++i) {
            breakpoints[i] = min + (double)(i + 1) * interval;
        }
        return breakpoints;
    }

    private void setSelectedVariable(Node node) {
        this.selectedVariable = node;
        this.values = null;
    }

    private void buildHistogramData() {
        if (this.frequencies == null) {
            ContinuousDiscretizationSpec spec = this.calculateSpec();
            if (spec == null) {
                this.frequencies = new int[this.categories];
            } else {
                Discretizer.Discretization discretization = Discretizer.discretize(this.getValues(), spec.getBreakpoints(), this.selectedVariable.getName(), spec.getCategories());
                int[] data = discretization.getData();
                this.frequencies = new int[this.categories];
                int[] arr$ = data;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    int category;
                    int n = category = arr$[i$];
                    this.frequencies[n] = this.frequencies[n] + 1;
                }
            }
        }
    }

    public static class ConditionalDependency {
        private int column = -1;
        private Node node;
        private List<String> values;

        public ConditionalDependency(Node node, List<String> values) {
            this.node = node;
            this.values = values;
        }

        public Node getNode() {
            return this.node;
        }

        public List<String> getValues() {
            return this.values;
        }

        public boolean satisfied(Object object) {
            for (String value : this.values) {
                if (!value.equals(object.toString())) continue;
                return true;
            }
            return false;
        }
    }
}

