/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetradapp.editor.Histogram;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JPanel;

public class HistogramDisplayPanel
extends JPanel {
    private static Color LINE_COLOR = Color.GRAY.darker();
    private static Color[] BAR_COLORS = new Color[]{new Color(153, 102, 102), new Color(102, 102, 153), new Color(102, 153, 102), new Color(153, 102, 153), new Color(153, 153, 102), new Color(102, 153, 153), new Color(204, 153, 153), new Color(153, 153, 204), new Color(153, 204, 153), new Color(204, 153, 204), new Color(204, 204, 153), new Color(153, 204, 204), new Color(255, 204, 204), new Color(204, 204, 255), new Color(204, 255, 204)};
    private static final int PADDING = 40;
    private static final int HEIGHT = 290;
    private static final int DISPLAYED_HEIGHT = 221;
    private static final int WIDTH = 330;
    private static final int SPACE = 2;
    private static final int DASH = 10;
    private Dimension size = new Dimension(334, 290);
    private NumberFormat format = new DecimalFormat("0.#");
    private Histogram histogram;
    private String displayString;
    private int topFreq = -1;
    private Map<Rectangle, Integer> rectMap = new ConcurrentHashMap<Rectangle, Integer>();

    public HistogramDisplayPanel(Histogram histogram) {
        if (histogram == null) {
            throw new NullPointerException("Given histogram must be null");
        }
        this.histogram = histogram;
        this.addMouseMotionListener(new MouseMovementListener());
        this.setToolTipText(" ");
    }

    public synchronized void updateHistogram(Histogram histogram) {
        if (histogram == null) {
            throw new NullPointerException("The given histogram must not be null");
        }
        this.displayString = null;
        this.histogram = histogram;
        this.topFreq = -1;
        this.repaint();
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        Point point = evt.getPoint();
        for (Rectangle rect : this.rectMap.keySet()) {
            if (!rect.contains(point)) continue;
            Integer i = this.rectMap.get(rect);
            if (i == null) break;
            return i.toString();
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.rectMap.clear();
        Graphics2D g2d = (Graphics2D)graphics;
        Histogram histogram = this.histogram;
        int[] freqs = histogram.getFrequencies();
        int categories = freqs.length;
        int barWidth = Math.max(290 / categories, 12) - 2;
        int height = 250;
        int max = HistogramDisplayPanel.getMax(freqs);
        double scale = 221.0 / (double)max;
        FontMetrics fontMetrics = g2d.getFontMetrics();
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, 334, 290);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(40, 0, 292, height);
        for (int i = 0; i < categories; ++i) {
            int freq = freqs[i];
            int y = (int)Math.ceil(scale * (double)freq);
            int x = 2 * (i + 1) + barWidth * i + 40;
            g2d.setColor(HistogramDisplayPanel.getBarColor(i));
            Rectangle rect = new Rectangle(x, height - y, barWidth, y);
            g2d.fill(rect);
            this.rectMap.put(rect, freq);
        }
        g2d.setColor(LINE_COLOR);
        g2d.drawRect(40, 0, 292, height);
        g2d.setColor(LINE_COLOR);
        Map<Integer, Double> pointsAndValues = this.pickGoodPointsAndValues(40, 332, histogram.getMinValue(), histogram.getMaxValue());
        for (int point : pointsAndValues.keySet()) {
            double value = pointsAndValues.get(point);
            if (point < 322) {
                g2d.drawString(this.format.format(value), point + 2, height + 15);
            }
            g2d.drawLine(point, height + 10, point, height);
        }
        g2d.setColor(LINE_COLOR);
        int topFreq = this.getTopFreq();
        int topY = height - (int)Math.ceil(scale * (double)topFreq);
        String top = String.valueOf(topFreq);
        g2d.drawString(top, 40 - fontMetrics.stringWidth(top), topY - 2);
        g2d.drawLine(30, topY, 40, topY);
        g2d.drawString("0", 40 - fontMetrics.stringWidth("0"), height - 2);
        g2d.drawLine(30, height, 40, height);
        int hSize = (height - topY) / 4;
        for (int i = 1; i < 4; ++i) {
            int topHeight = height - hSize * i;
            g2d.drawLine(30, topHeight, 40, topHeight);
        }
        g2d.setColor(LINE_COLOR);
        g2d.drawString(this.getDisplayString(), 40, 285);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size;
    }

    private Map<Integer, Double> pickGoodPointsAndValues(int min, int max, double minValue, double maxValue) {
        double range = maxValue - minValue;
        int powerOfTen = (int)Math.floor(Math.log(range) / Math.log(10.0));
        HashMap<Integer, Double> points = new HashMap<Integer, Double>();
        int low = (int)Math.floor(minValue / Math.pow(10.0, powerOfTen));
        int high = (int)Math.ceil(maxValue / Math.pow(10.0, powerOfTen));
        for (int i = low; i < high; ++i) {
            double realValue = (double)i * Math.pow(10.0, powerOfTen);
            Integer intValue = this.translateToInt(min, max, minValue, maxValue, realValue);
            if (intValue == null) continue;
            points.put(intValue, realValue);
        }
        return points;
    }

    private Integer translateToInt(int min, int max, double minValue, double maxValue, double value) {
        if (minValue >= maxValue) {
            throw new IllegalArgumentException();
        }
        if (min >= max) {
            throw new IllegalArgumentException();
        }
        double ratio = (value - minValue) / (maxValue - minValue);
        int intValue = (int)Math.round((double)min + ratio * (double)(max - min));
        if (intValue < min || intValue > max) {
            return null;
        }
        return intValue;
    }

    private static Color getBarColor(int i) {
        return BAR_COLORS[i % BAR_COLORS.length];
    }

    private int getTopFreq() {
        if (this.topFreq == -1) {
            int[] freqs = this.histogram.getFrequencies();
            int top = freqs[0];
            for (int freq : freqs) {
                if (top >= freq) continue;
                top = freq;
            }
            this.topFreq = top;
        }
        return this.topFreq;
    }

    private String getDisplayString() {
        if (this.displayString == null) {
            StringBuilder builder = new StringBuilder();
            builder.append("Showing: ");
            builder.append(this.histogram.getSelectedVariable().getName());
            List<Histogram.ConditionalDependency> conditions = this.histogram.getConditionalDependencies();
            if (!conditions.isEmpty()) {
                builder.append(" | ");
                for (int k = 0; k < conditions.size(); ++k) {
                    Histogram.ConditionalDependency condition = conditions.get(k);
                    builder.append(condition.getNode().getName());
                    builder.append("=");
                    List<String> values = condition.getValues();
                    for (int i = 0; i < values.size(); ++i) {
                        builder.append(values.get(i));
                        if (i < values.size() - 1) {
                            builder.append(" v ");
                            continue;
                        }
                        if (k >= conditions.size() - 1) continue;
                        builder.append(", ");
                    }
                }
            }
            this.displayString = builder.toString();
        }
        return this.displayString;
    }

    private static int getMax(int[] freqs) {
        int max = freqs[0];
        for (int i = 1; i < freqs.length; ++i) {
            int current = freqs[i];
            if (max >= current) continue;
            max = current;
        }
        return max;
    }

    private class MouseMovementListener
    implements MouseMotionListener {
        private MouseMovementListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Rectangle rect;
            Point point = e.getPoint();
            Iterator i$ = HistogramDisplayPanel.this.rectMap.keySet().iterator();
            while (i$.hasNext() && !(rect = (Rectangle)i$.next()).contains(point)) {
            }
        }
    }
}

