/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Pattern;
import edu.cmu.tetrad.search.GesOrienter;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.PatternToDag;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.AbstractSearchEditor;
import edu.cmu.tetradapp.editor.AllPathsAction;
import edu.cmu.tetradapp.editor.DirectedPathsAction;
import edu.cmu.tetradapp.editor.DiscDetIndepParamsEditor;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.GesIndTestParamsEditor;
import edu.cmu.tetradapp.editor.GraphPropertiesAction;
import edu.cmu.tetradapp.editor.IndTestParamsEditor;
import edu.cmu.tetradapp.editor.NeighborhoodsAction;
import edu.cmu.tetradapp.editor.PcIndTestParamsEditor;
import edu.cmu.tetradapp.editor.ScoredGraphsDisplay;
import edu.cmu.tetradapp.editor.SelectBidirectedAction;
import edu.cmu.tetradapp.editor.SelectUndirectedAction;
import edu.cmu.tetradapp.editor.TimeSeriesIndTestParamsEditor;
import edu.cmu.tetradapp.editor.TreksAction;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.AlgorithmRunner;
import edu.cmu.tetradapp.model.DiscDetIndepParams;
import edu.cmu.tetradapp.model.GesIndTestParams;
import edu.cmu.tetradapp.model.GesRunner;
import edu.cmu.tetradapp.model.GraphIndTestParams;
import edu.cmu.tetradapp.model.IGesRunner;
import edu.cmu.tetradapp.model.ImagesRunner;
import edu.cmu.tetradapp.model.IndTestParams;
import edu.cmu.tetradapp.model.KnowledgeEditable;
import edu.cmu.tetradapp.model.LagIndTestParams;
import edu.cmu.tetradapp.model.LingamRunner;
import edu.cmu.tetradapp.model.MeekSearchParams;
import edu.cmu.tetradapp.model.PcIndTestParams;
import edu.cmu.tetradapp.model.SearchParams;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.util.LayoutMenu;
import edu.cmu.tetradapp.util.WatchedProcess;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class ImagesSearchEditor
extends AbstractSearchEditor
implements KnowledgeEditable,
LayoutEditable {
    private double pruningAlpha;
    private boolean alreadyLaidOut = false;

    public ImagesSearchEditor(LingamRunner runner) {
        super(runner, "Result Graph");
    }

    @Override
    public Graph getGraph() {
        return this.getWorkbench().getGraph();
    }

    @Override
    public void layoutByGraph(Graph graph) {
        this.getWorkbench().layoutByGraph(graph);
    }

    @Override
    public void layoutByKnowledge() {
        GraphWorkbench resultWorkbench = this.getWorkbench();
        Graph graph = resultWorkbench.getGraph();
        Knowledge knowledge = this.getAlgorithmRunner().getParams().getKnowledge();
        SearchGraphUtils.arrangeByKnowledgeTiers(graph, knowledge);
        resultWorkbench.setGraph(graph);
    }

    @Override
    public Rectangle getVisibleRect() {
        return this.getWorkbench().getVisibleRect();
    }

    @Override
    protected void setup(String resultLabel) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getToolbar(), "West");
        this.add(this.workbenchScroll(resultLabel));
        this.add((Component)this.menuBar(), "North");
    }

    @Override
    protected JPanel getToolbar() {
        JPanel toolbar = new JPanel();
        this.getExecuteButton().setText("Execute*");
        this.getExecuteButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImagesSearchEditor.this.execute();
            }
        });
        Box b1 = Box.createVerticalBox();
        Box b21 = Box.createVerticalBox();
        Box b211 = Box.createHorizontalBox();
        b211.add(new JLabel("Pruning Alpha "));
        DoubleTextField field = new DoubleTextField(0.05, 8, NumberFormatUtil.getInstance().getNumberFormat());
        field.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                if (value >= 0.0 && value <= 1.0) {
                    ImagesSearchEditor.this.setPruningAlpha(value);
                    return value;
                }
                return oldValue;
            }
        });
        b211.add(field);
        b21.add(b211);
        JPanel paramsPanel = new JPanel();
        paramsPanel.add(b21);
        paramsPanel.setBorder(new TitledBorder("Parameters"));
        b1.add(paramsPanel);
        b1.add(Box.createVerticalStrut(10));
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createGlue());
        b2.add(this.getExecuteButton());
        b1.add(b2);
        b1.add(Box.createVerticalStrut(10));
        if (this.getAlgorithmRunner().getDataModel() instanceof DataSet) {
            Box b3 = Box.createHorizontalBox();
            b3.add(Box.createGlue());
            b1.add(b3);
        }
        if (this.getAlgorithmRunner().getParams() instanceof MeekSearchParams) {
            b1.add(Box.createVerticalStrut(5));
            Box hBox = Box.createHorizontalBox();
            hBox.add(Box.createHorizontalGlue());
            b1.add(hBox);
            b1.add(Box.createVerticalStrut(5));
        }
        Box b4 = Box.createHorizontalBox();
        JLabel label = new JLabel("<html>*Please note that some<br>searches may take a<br>long time to complete.</html>");
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setBorder(new TitledBorder(""));
        b4.add(label);
        b1.add(Box.createVerticalStrut(10));
        b1.add(b4);
        toolbar.add(b1);
        return toolbar;
    }

    private void setPruningAlpha(double value) {
        this.pruningAlpha = value;
        Preferences.userRoot().putDouble("lingamPruningAlpha", value);
    }

    @Override
    protected void doPostExecutionSteps() {
        System.out.println("Post execution.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void addSpecialMenus(JMenuBar menuBar) {
        if (!(this.getAlgorithmRunner() instanceof IGesRunner)) {
            JMenu test = new JMenu("Independence");
            menuBar.add(test);
            DataModel dataModel = this.getAlgorithmRunner().getDataModel();
            if (dataModel == null && this.getAlgorithmRunner().getSourceGraph() != null) {
                this.addGraphTestMenuItems(test);
            } else if (dataModel instanceof DataSet) {
                DataSet _dataSet = (DataSet)dataModel;
                if (_dataSet.isContinuous()) {
                    this.addContinuousTestMenuItems(test);
                } else {
                    if (!_dataSet.isDiscrete()) throw new IllegalArgumentException("Don't have any tests for mixed data sets right now.");
                    this.addDiscreteTestMenuItems(test);
                }
            } else if (dataModel instanceof CovarianceMatrix) {
                this.addContinuousTestMenuItems(test);
            }
            test.addSeparator();
        }
        JMenu graph = new JMenu("Graph");
        JMenuItem showDags = new JMenuItem("Show DAGs in Pattern");
        JMenuItem meekOrient = new JMenuItem("Meek Orientation");
        JMenuItem dagInPattern = new JMenuItem("Choose DAG in Pattern");
        JMenuItem gesOrient = new JMenuItem("Global Score-based Reorientation");
        JMenuItem nextGraph = new JMenuItem("Next Graph");
        JMenuItem previousGraph = new JMenuItem("Previous Graph");
        graph.add(new GraphPropertiesAction(this.getWorkbench()));
        graph.add(new DirectedPathsAction(this.getWorkbench()));
        graph.add(new TreksAction(this.getWorkbench()));
        graph.add(new AllPathsAction(this.getWorkbench()));
        graph.add(new NeighborhoodsAction(this.getWorkbench()));
        graph.addSeparator();
        graph.add(meekOrient);
        graph.add(dagInPattern);
        graph.add(gesOrient);
        graph.addSeparator();
        graph.add(previousGraph);
        graph.add(nextGraph);
        graph.addSeparator();
        graph.add(showDags);
        graph.addSeparator();
        graph.add(new JMenuItem(new SelectBidirectedAction(this.getWorkbench())));
        graph.add(new JMenuItem(new SelectUndirectedAction(this.getWorkbench())));
        menuBar.add(graph);
        showDags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window owner = (Window)ImagesSearchEditor.this.getTopLevelAncestor();
                new WatchedProcess(owner){

                    @Override
                    public void watch() {
                        AlgorithmRunner runner = ImagesSearchEditor.this.getAlgorithmRunner();
                        Graph graph = runner.getResultGraph();
                        if (graph == null) {
                            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "No result gaph.");
                            return;
                        }
                        ScoredGraphsDisplay display = new ScoredGraphsDisplay(((ImagesRunner)runner).getDagsToScores());
                        GraphWorkbench workbench = ImagesSearchEditor.this.getWorkbench();
                        EditorWindow editorWindow = new EditorWindow(display, "Independence Facts", "Close", false, workbench);
                        DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
                        editorWindow.setVisible(true);
                    }
                };
            }
        });
        meekOrient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpliedOrientation rules = ImagesSearchEditor.this.getAlgorithmRunner().getMeekRules();
                rules.setKnowledge(ImagesSearchEditor.this.getAlgorithmRunner().getParams().getKnowledge());
                rules.orientImplied(ImagesSearchEditor.this.getGraph());
                ImagesSearchEditor.this.getGraphHistory().add(ImagesSearchEditor.this.getGraph());
                ImagesSearchEditor.this.getWorkbench().setGraph(ImagesSearchEditor.this.getGraph());
            }
        });
        dagInPattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdgeListGraph graph = new EdgeListGraph(ImagesSearchEditor.this.getGraph());
                for (Edge edge : graph.getEdges()) {
                    if (!Edges.isBidirectedEdge(edge)) continue;
                    graph.removeEdge(edge);
                }
                PatternToDag search = new PatternToDag(new Pattern(graph));
                Graph dag = search.patternToDagMeekRules();
                ImagesSearchEditor.this.getGraphHistory().add(dag);
                ImagesSearchEditor.this.getWorkbench().setGraph(dag);
                ((AbstractAlgorithmRunner)ImagesSearchEditor.this.getAlgorithmRunner()).setResultGraph(dag);
            }
        });
        gesOrient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataModel dataModel = ImagesSearchEditor.this.getAlgorithmRunner().getDataModel();
                GesOrienter rules = dataModel instanceof DataSet ? new GesOrienter((DataSet)dataModel, new Knowledge()) : new GesOrienter((CovarianceMatrix)dataModel);
                rules.setKnowledge(ImagesSearchEditor.this.getAlgorithmRunner().getParams().getKnowledge());
                rules.orient(ImagesSearchEditor.this.getGraph());
                ImagesSearchEditor.this.getGraphHistory().add(ImagesSearchEditor.this.getGraph());
                ImagesSearchEditor.this.getWorkbench().setGraph(ImagesSearchEditor.this.getGraph());
            }
        });
        nextGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Graph next = ImagesSearchEditor.this.getGraphHistory().next();
                ImagesSearchEditor.this.getWorkbench().setGraph(next);
                ((AbstractAlgorithmRunner)ImagesSearchEditor.this.getAlgorithmRunner()).setResultGraph(next);
            }
        });
        previousGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Graph previous = ImagesSearchEditor.this.getGraphHistory().previous();
                ImagesSearchEditor.this.getWorkbench().setGraph(previous);
                ((AbstractAlgorithmRunner)ImagesSearchEditor.this.getAlgorithmRunner()).setResultGraph(previous);
            }
        });
        menuBar.add(new LayoutMenu(this));
    }

    @Override
    public Graph getSourceGraph() {
        Graph sourceGraph = this.getWorkbench().getGraph();
        if (sourceGraph == null) {
            sourceGraph = this.getAlgorithmRunner().getSourceGraph();
        }
        return sourceGraph;
    }

    @Override
    public List<String> getVarNames() {
        SearchParams params = this.getAlgorithmRunner().getParams();
        return params.getVarNames();
    }

    private void addGraphTestMenuItems(JMenu test) {
        IndTestType testType = this.getTestType();
        if (testType != IndTestType.D_SEPARATION) {
            this.setTestType(IndTestType.D_SEPARATION);
        }
        ButtonGroup group = new ButtonGroup();
        JCheckBoxMenuItem dsep = new JCheckBoxMenuItem("D-Separation");
        group.add(dsep);
        test.add(dsep);
        dsep.setSelected(true);
        dsep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImagesSearchEditor.this.setTestType(IndTestType.D_SEPARATION);
            }
        });
    }

    private void addContinuousTestMenuItems(JMenu test) {
        IndTestType testType = this.getTestType();
        if (testType != IndTestType.FISHER_Z && testType != IndTestType.FISHER_ZD && testType != IndTestType.FISHER_Z_BOOTSTRAP && testType != IndTestType.CORRELATION_T && testType != IndTestType.LINEAR_REGRESSION) {
            this.setTestType(IndTestType.FISHER_Z);
        }
        ButtonGroup group = new ButtonGroup();
        JCheckBoxMenuItem fishersZ = new JCheckBoxMenuItem("Fisher's Z");
        group.add(fishersZ);
        test.add(fishersZ);
        JCheckBoxMenuItem fishersZD = new JCheckBoxMenuItem("Fisher's Z - Generalized inverse");
        group.add(fishersZD);
        test.add(fishersZD);
        JCheckBoxMenuItem fishersZBootstrap = new JCheckBoxMenuItem("Fisher's Z - Bootstrap");
        group.add(fishersZBootstrap);
        test.add(fishersZBootstrap);
        JCheckBoxMenuItem tTest = new JCheckBoxMenuItem("Cramer's T");
        group.add(tTest);
        test.add(tTest);
        JCheckBoxMenuItem linRegrTest = new JCheckBoxMenuItem("Linear Regression Test");
        group.add(linRegrTest);
        test.add(linRegrTest);
        testType = this.getTestType();
        if (testType == IndTestType.FISHER_Z) {
            fishersZ.setSelected(true);
        } else if (testType == IndTestType.FISHER_ZD) {
            fishersZD.setSelected(true);
        } else if (testType == IndTestType.FISHER_Z_BOOTSTRAP) {
            fishersZBootstrap.setSelected(true);
        } else if (testType == IndTestType.CORRELATION_T) {
            tTest.setSelected(true);
        } else if (testType == IndTestType.LINEAR_REGRESSION) {
            linRegrTest.setSelected(true);
        }
        fishersZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImagesSearchEditor.this.setTestType(IndTestType.FISHER_Z);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Fisher's Z.");
            }
        });
        fishersZD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImagesSearchEditor.this.setTestType(IndTestType.FISHER_ZD);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Fisher's Z - Generalized Inverse.");
            }
        });
        fishersZBootstrap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImagesSearchEditor.this.setTestType(IndTestType.FISHER_Z_BOOTSTRAP);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Fisher's Z - Bootstrap.");
            }
        });
        tTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImagesSearchEditor.this.setTestType(IndTestType.CORRELATION_T);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Cramer's T.");
            }
        });
        linRegrTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImagesSearchEditor.this.setTestType(IndTestType.LINEAR_REGRESSION);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using linear regression test.");
            }
        });
    }

    private void addDiscreteTestMenuItems(JMenu test) {
        IndTestType testType = this.getTestType();
        if (testType != IndTestType.CHI_SQUARE && testType != IndTestType.G_SQUARE) {
            this.setTestType(IndTestType.CHI_SQUARE);
        }
        ButtonGroup group = new ButtonGroup();
        JCheckBoxMenuItem chiSquare = new JCheckBoxMenuItem("Chi Square");
        group.add(chiSquare);
        test.add(chiSquare);
        JCheckBoxMenuItem gSquare = new JCheckBoxMenuItem("G Square");
        group.add(gSquare);
        test.add(gSquare);
        if (this.getTestType() == IndTestType.CHI_SQUARE) {
            chiSquare.setSelected(true);
        } else if (this.getTestType() == IndTestType.G_SQUARE) {
            gSquare.setSelected(true);
        }
        chiSquare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImagesSearchEditor.this.setTestType(IndTestType.CHI_SQUARE);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Chi Square.");
            }
        });
        gSquare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImagesSearchEditor.this.setTestType(IndTestType.G_SQUARE);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using G square.");
            }
        });
    }

    private void setTestType(IndTestType testType) {
        this.getAlgorithmRunner().getParams().setIndTestType(testType);
    }

    private IndTestType getTestType() {
        return this.getAlgorithmRunner().getParams().getIndTestType();
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.getAlgorithmRunner().getParams().setKnowledge(knowledge);
    }

    @Override
    public Knowledge getKnowledge() {
        return this.getAlgorithmRunner().getParams().getKnowledge();
    }

    private JComponent getIndTestParamBox(IndTestParams indTestParams) {
        if (indTestParams == null) {
            throw new NullPointerException();
        }
        if (indTestParams instanceof GesIndTestParams && this.getAlgorithmRunner() instanceof IGesRunner) {
            GesRunner gesRunner = (GesRunner)this.getAlgorithmRunner();
            GesIndTestParams params = (GesIndTestParams)indTestParams;
            DataSet dataSet = (DataSet)gesRunner.getDataModel();
            boolean discreteData = dataSet.isDiscrete();
            return new GesIndTestParamsEditor(params, discreteData);
        }
        if (indTestParams instanceof LagIndTestParams) {
            return new TimeSeriesIndTestParamsEditor((LagIndTestParams)indTestParams);
        }
        if (indTestParams instanceof GraphIndTestParams) {
            return new IndTestParamsEditor((GraphIndTestParams)indTestParams);
        }
        if (indTestParams instanceof DiscDetIndepParams) {
            return new DiscDetIndepParamsEditor((DiscDetIndepParams)indTestParams);
        }
        if (indTestParams instanceof PcIndTestParams) {
            return new PcIndTestParamsEditor((PcIndTestParams)indTestParams);
        }
        return new IndTestParamsEditor(indTestParams);
    }

    @Override
    protected void doDefaultArrangement(Graph resultGraph) {
        if (this.alreadyLaidOut) {
            GraphUtils.arrangeBySourceGraph(resultGraph, this.getLatestWorkbenchGraph());
        } else if (this.getKnowledge().isDefaultToKnowledgeLayout()) {
            SearchGraphUtils.arrangeByKnowledgeTiers(resultGraph, this.getKnowledge());
            this.alreadyLaidOut = true;
        } else {
            GraphUtils.arrangeBySourceGraph(resultGraph, this.getLatestWorkbenchGraph());
            this.alreadyLaidOut = true;
        }
    }

    private JScrollPane dagWorkbenchScroll(String resultLabel, Graph dag) {
        GraphWorkbench dagWorkbench = new GraphWorkbench(dag);
        dagWorkbench.setAllowDoubleClickActions(false);
        dagWorkbench.setAllowNodeEdgeSelection(true);
        JScrollPane dagWorkbenchScroll = new JScrollPane(dagWorkbench);
        dagWorkbenchScroll.setPreferredSize(new Dimension(450, 450));
        dagWorkbenchScroll.setBorder(new TitledBorder(resultLabel));
        dagWorkbench.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                ImagesSearchEditor.this.storeLatestWorkbenchGraph();
            }
        });
        return dagWorkbenchScroll;
    }
}

