/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.DataEditor;
import edu.cmu.tetradapp.editor.LoadDataDialog;
import edu.cmu.tetradapp.model.DataWrapper;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

final class LoadDataAction
extends AbstractAction {
    private DataEditor dataEditor;

    public LoadDataAction(DataEditor editor) {
        super("Load Data...");
        if (editor == null) {
            throw new NullPointerException("Data Editor must not be null.");
        }
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataModelList _dataModelList;
        JFileChooser chooser = LoadDataAction.getJFileChooser();
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(true);
        chooser.showOpenDialog(this.dataEditor);
        File[] files = chooser.getSelectedFiles();
        if (files == null) {
            return;
        }
        if (files.length == 0) {
            return;
        }
        Preferences.userRoot().put("fileSaveLocation", files[0].getParent());
        LoadDataDialog dialog = new LoadDataDialog(files);
        int ret = JOptionPane.showOptionDialog(JOptionUtils.centeringComp(), dialog, "File Loader", 2, -1, null, new String[]{"Save", "Cancel"}, "Save");
        if (ret != 0) {
            return;
        }
        boolean keepData = false;
        if (!this.isDataEmpty()) {
            String message = "Would you like to replace the current data?";
            int option = JOptionPane.showOptionDialog(this.dataEditor, message, "Data Replacement", 0, 3, null, new String[]{"Replace", "Keep"}, "Replace");
            boolean bl = keepData = option == 1;
        }
        if ((_dataModelList = dialog.getDataModels()).isEmpty()) {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "No files were loaded.");
            return;
        }
        DataModelList dataModelList = keepData ? this.dataEditor.getDataModelList() : new DataModelList();
        dataModelList.addAll(_dataModelList);
        this.dataEditor.replace(dataModelList);
        this.dataEditor.selectFirstTab();
        this.firePropertyChange("modelChanged", null, null);
    }

    private boolean isDataEmpty() {
        DataWrapper wrapper = this.dataEditor.getDataWrapper();
        DataModelList dataModels = wrapper.getDataModelList();
        Iterator i$ = dataModels.iterator();
        if (i$.hasNext()) {
            DataModel model = (DataModel)i$.next();
            if (model instanceof DataSet) {
                return ((DataSet)model).getNumRows() == 0;
            }
            return false;
        }
        return true;
    }

    private static JFileChooser getJFileChooser() {
        JFileChooser chooser = new JFileChooser();
        String sessionSaveLocation = Preferences.userRoot().get("fileSaveLocation", "");
        chooser.setCurrentDirectory(new File(sessionSaveLocation));
        chooser.resetChoosableFileFilters();
        chooser.setFileSelectionMode(2);
        return chooser;
    }
}

