/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.editor.GraphEditable;
import edu.cmu.tetradapp.editor.GraphFileMenu;
import edu.cmu.tetradapp.editor.SaveDataAction;
import edu.cmu.tetradapp.editor.TabularDataJTable;
import edu.cmu.tetradapp.model.MarkovBlanketSearchRunner;
import edu.cmu.tetradapp.model.MbSearchParams;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.WatchedProcess;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.border.TitledBorder;

public class MarkovBlanketSearchEditor
extends JPanel
implements GraphEditable {
    private MarkovBlanketSearchRunner algorithmRunner;
    private JButton executeButton = new JButton();
    private JScrollPane workbenchScroll;
    private TabularDataJTable table;
    private boolean knowledgeMessageShown = false;

    public MarkovBlanketSearchEditor(MarkovBlanketSearchRunner algorithmRunner) {
        if (algorithmRunner == null) {
            throw new NullPointerException();
        }
        this.algorithmRunner = algorithmRunner;
        MbSearchParams params = algorithmRunner.getParams();
        List<String> vars = algorithmRunner.getSource().getVariableNames();
        if (params.getTargetName() == null && !vars.isEmpty()) {
            params.setTargetName(vars.get(0));
        }
        DataSet data = algorithmRunner.getDataModelForMarkovBlanket() == null ? algorithmRunner.getSource() : algorithmRunner.getDataModelForMarkovBlanket();
        this.table = new TabularDataJTable(data);
        this.table.setEditable(false);
        this.table.setTableHeader(null);
        this.setup();
    }

    public DataModel getDataModel() {
        if (this.algorithmRunner.getDataModelForMarkovBlanket() != null) {
            return this.algorithmRunner.getDataModelForMarkovBlanket();
        }
        return this.algorithmRunner.getSource();
    }

    private void execute() {
        Window owner = (Window)this.getTopLevelAncestor();
        final WatchedProcess process = new WatchedProcess(owner){

            @Override
            public void watch() {
                Knowledge knowledge;
                MarkovBlanketSearchEditor.this.getExecuteButton().setEnabled(false);
                this.setErrorMessage(null);
                if (!MarkovBlanketSearchEditor.this.knowledgeMessageShown && !(knowledge = MarkovBlanketSearchEditor.this.getAlgorithmRunner().getParams().getKnowledge()).equals(new Knowledge())) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using previously set knowledge. (To edit, use the Knowledge menu.)");
                    MarkovBlanketSearchEditor.this.knowledgeMessageShown = true;
                }
                try {
                    MarkovBlanketSearchEditor.this.getAlgorithmRunner().execute();
                }
                catch (Exception e) {
                    CharArrayWriter writer1 = new CharArrayWriter();
                    PrintWriter writer2 = new PrintWriter(writer1);
                    e.printStackTrace(writer2);
                    String message = writer1.toString();
                    writer2.close();
                    e.printStackTrace(System.out);
                    TetradLogger.getInstance().error(message);
                    String messageString = e.getMessage();
                    if (e.getCause() != null) {
                        messageString = e.getCause().getMessage();
                    }
                    if (messageString == null) {
                        messageString = message;
                    }
                    this.setErrorMessage(messageString);
                    MarkovBlanketSearchEditor.this.getExecuteButton().setEnabled(true);
                    throw new RuntimeException(e);
                }
                MarkovBlanketSearchEditor.this.setLabel();
                DataSet modelForMarkovBlanket = MarkovBlanketSearchEditor.this.algorithmRunner.getDataModelForMarkovBlanket();
                if (modelForMarkovBlanket != null) {
                    MarkovBlanketSearchEditor.this.table.setDataSet(modelForMarkovBlanket);
                }
                MarkovBlanketSearchEditor.this.table.repaint();
                MarkovBlanketSearchEditor.this.getExecuteButton().setEnabled(true);
            }
        };
        Thread watcher = new Thread(){

            @Override
            public void run() {
                try {
                    do {
                        2.sleep(300L);
                    } while (process.isAlive());
                    MarkovBlanketSearchEditor.this.getExecuteButton().setEnabled(true);
                    return;
                }
                catch (InterruptedException e) {
                    MarkovBlanketSearchEditor.this.getExecuteButton().setEnabled(true);
                    return;
                }
            }
        };
        watcher.start();
    }

    private void setLabel() {
        this.getWorkbenchScroll().setBorder(new TitledBorder(this.algorithmRunner.getSearchName()));
    }

    private JButton getExecuteButton() {
        return this.executeButton;
    }

    private MarkovBlanketSearchRunner getAlgorithmRunner() {
        return this.algorithmRunner;
    }

    private void setup() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createToolbar(), "West");
        this.add((Component)this.workbenchScroll(), "Center");
        this.add((Component)this.menuBar(), "North");
    }

    private JPanel createToolbar() {
        JPanel toolbar = new JPanel();
        this.getExecuteButton().setText("Execute*");
        this.getExecuteButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkovBlanketSearchEditor.this.execute();
            }
        });
        Box b1 = Box.createVerticalBox();
        b1.add(this.getParamEditor());
        b1.add(Box.createVerticalStrut(10));
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createGlue());
        b2.add(this.getExecuteButton());
        b1.add(b2);
        b1.add(Box.createVerticalStrut(10));
        Box b3 = Box.createHorizontalBox();
        JLabel label = new JLabel("<html>*Please note that some<br>searches may take a<br>long time to complete.</html>");
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setBorder(new TitledBorder(""));
        b3.add(label);
        b1.add(b3);
        toolbar.add(b1);
        return toolbar;
    }

    private JComponent getParamEditor() {
        Box box = Box.createVerticalBox();
        JComboBox<Object> comboBox = new JComboBox<Object>(this.algorithmRunner.getSource().getVariableNames().toArray());
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String s = (String)e.getItem();
                if (s != null) {
                    MarkovBlanketSearchEditor.this.algorithmRunner.getParams().setTargetName(s);
                }
            }
        });
        DoubleTextField alphaField = new DoubleTextField(this.getParams().getAlpha(), 4, NumberFormatUtil.getInstance().getNumberFormat());
        alphaField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    MarkovBlanketSearchEditor.this.getParams().setAlpha(value);
                    Preferences.userRoot().putDouble("alpha", MarkovBlanketSearchEditor.this.getParams().getAlpha());
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        box.add(comboBox);
        box.add(Box.createVerticalStrut(4));
        box.add(this.createLabeledComponent("Alpha", alphaField));
        box.setBorder(new TitledBorder("Parameters"));
        return box;
    }

    private Box createLabeledComponent(String label, JComponent comp) {
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(label));
        box.add(Box.createHorizontalStrut(5));
        box.add(comp);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private MbSearchParams getParams() {
        return this.algorithmRunner.getParams();
    }

    private JScrollPane workbenchScroll() {
        this.workbenchScroll = new JScrollPane(this.table);
        this.workbenchScroll.setPreferredSize(new Dimension(500, 500));
        this.setLabel();
        return this.workbenchScroll;
    }

    private JMenuBar menuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        file.add(new JMenuItem(new SaveDataAction(this)));
        file.add(new GraphFileMenu(this, this.getWorkbench()));
        JMenu edit = new JMenu("Edit");
        JMenuItem copyCells = new JMenuItem("Copy Cells");
        copyCells.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        copyCells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Action copyAction = TransferHandler.getCopyAction();
                ActionEvent actionEvent = new ActionEvent(MarkovBlanketSearchEditor.this.table, 1001, "copy");
                copyAction.actionPerformed(actionEvent);
            }
        });
        edit.add(copyCells);
        menuBar.add(file);
        menuBar.add(edit);
        JMenu independence = new JMenu("Independence");
        if (this.algorithmRunner.getSource().isContinuous()) {
            this.addContinuousTestMenuItems(independence);
            menuBar.add(independence);
        } else if (this.algorithmRunner.getSource().isDiscrete()) {
            this.addDiscreteTestMenuItems(independence);
            menuBar.add(independence);
        }
        menuBar.add(independence);
        return menuBar;
    }

    private void addContinuousTestMenuItems(JMenu test) {
        IndTestType testType = this.getParams().getIndTestType();
        if (testType != IndTestType.FISHER_Z && testType != IndTestType.FISHER_ZD && testType != IndTestType.FISHER_Z_BOOTSTRAP && testType != IndTestType.CORRELATION_T && testType != IndTestType.LINEAR_REGRESSION) {
            this.getParams().setIndTestType(IndTestType.FISHER_Z);
        }
        ButtonGroup group = new ButtonGroup();
        JCheckBoxMenuItem fishersZ = new JCheckBoxMenuItem("Fisher's Z");
        group.add(fishersZ);
        test.add(fishersZ);
        JCheckBoxMenuItem fishersZD = new JCheckBoxMenuItem("Fisher's Z - Generalized Inverse");
        group.add(fishersZD);
        test.add(fishersZD);
        JCheckBoxMenuItem fishersZBootstrap = new JCheckBoxMenuItem("Fisher's Z - Bootstrap");
        group.add(fishersZBootstrap);
        test.add(fishersZBootstrap);
        JCheckBoxMenuItem tTest = new JCheckBoxMenuItem("Cramer's T");
        group.add(tTest);
        test.add(tTest);
        JCheckBoxMenuItem linRegrTest = new JCheckBoxMenuItem("Linear Regression Test");
        group.add(linRegrTest);
        test.add(linRegrTest);
        testType = this.getParams().getIndTestType();
        if (testType == IndTestType.FISHER_Z) {
            fishersZ.setSelected(true);
        } else if (testType == IndTestType.FISHER_ZD) {
            fishersZD.setSelected(true);
        } else if (testType == IndTestType.FISHER_Z_BOOTSTRAP) {
            fishersZBootstrap.setSelected(true);
        } else if (testType == IndTestType.CORRELATION_T) {
            tTest.setSelected(true);
        } else if (testType == IndTestType.LINEAR_REGRESSION) {
            linRegrTest.setSelected(true);
        }
        fishersZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkovBlanketSearchEditor.this.getParams().setIndTestType(IndTestType.FISHER_Z);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Fisher's Z.");
            }
        });
        fishersZD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkovBlanketSearchEditor.this.getParams().setIndTestType(IndTestType.FISHER_ZD);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Fisher's Z - Generalized Inverse.");
            }
        });
        fishersZBootstrap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkovBlanketSearchEditor.this.getParams().setIndTestType(IndTestType.FISHER_Z_BOOTSTRAP);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Fisher's Z - Bootstrap.");
            }
        });
        tTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkovBlanketSearchEditor.this.getParams().setIndTestType(IndTestType.CORRELATION_T);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Cramer's T.");
            }
        });
        linRegrTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkovBlanketSearchEditor.this.getParams().setIndTestType(IndTestType.LINEAR_REGRESSION);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using linear regression test.");
            }
        });
    }

    private void addDiscreteTestMenuItems(JMenu test) {
        IndTestType testType = this.getParams().getIndTestType();
        if (testType != IndTestType.CHI_SQUARE && testType != IndTestType.G_SQUARE) {
            this.getParams().setIndTestType(testType);
        }
        ButtonGroup group = new ButtonGroup();
        JCheckBoxMenuItem chiSquare = new JCheckBoxMenuItem("Chi Square");
        group.add(chiSquare);
        test.add(chiSquare);
        JCheckBoxMenuItem gSquare = new JCheckBoxMenuItem("G Square");
        group.add(gSquare);
        test.add(gSquare);
        if (this.getParams().getIndTestType() == IndTestType.CHI_SQUARE) {
            chiSquare.setSelected(true);
        } else if (this.getParams().getIndTestType() == IndTestType.G_SQUARE) {
            gSquare.setSelected(true);
        }
        chiSquare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkovBlanketSearchEditor.this.getParams().setIndTestType(IndTestType.CHI_SQUARE);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Chi Square.");
            }
        });
        gSquare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkovBlanketSearchEditor.this.getParams().setIndTestType(IndTestType.G_SQUARE);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using G square.");
            }
        });
    }

    private JScrollPane getWorkbenchScroll() {
        return this.workbenchScroll;
    }

    @Override
    public List getSelectedModelComponents() {
        throw new UnsupportedOperationException("Cannot return selected components.");
    }

    @Override
    public void pasteSubsession(List sessionElements, Point upperLeft) {
        throw new UnsupportedOperationException("Cannot paste subsessions on a search editor.");
    }

    @Override
    public GraphWorkbench getWorkbench() {
        return this.getWorkbench();
    }

    @Override
    public void setGraph(Graph g) {
        throw new UnsupportedOperationException("Cannot set the graph on a search editor.");
    }

    @Override
    public Graph getGraph() {
        if (this.getWorkbench().getGraph() != null) {
            return this.getWorkbench().getGraph();
        }
        return new EdgeListGraph();
    }
}

