/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.search.GesOrienter;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.Mbfs;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.AbstractSearchEditor;
import edu.cmu.tetradapp.editor.AllPathsAction;
import edu.cmu.tetradapp.editor.DirectedPathsAction;
import edu.cmu.tetradapp.editor.GraphPropertiesAction;
import edu.cmu.tetradapp.editor.IndependenceFactsAction;
import edu.cmu.tetradapp.editor.MbPatternDisplay;
import edu.cmu.tetradapp.editor.MbSearchParamEditor;
import edu.cmu.tetradapp.editor.NeighborhoodsAction;
import edu.cmu.tetradapp.editor.TreksAction;
import edu.cmu.tetradapp.model.AlgorithmRunner;
import edu.cmu.tetradapp.model.CeFanSearchRunner;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.KnowledgeEditable;
import edu.cmu.tetradapp.model.MbFanSearchRunner;
import edu.cmu.tetradapp.model.MbSearchParams;
import edu.cmu.tetradapp.model.MbfsRunner;
import edu.cmu.tetradapp.model.PcdRunner;
import edu.cmu.tetradapp.model.SearchParams;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.util.LayoutMenu;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class MbSearchEditor
extends AbstractSearchEditor
implements LayoutEditable,
KnowledgeEditable {
    public MbSearchEditor(MbfsRunner runner) {
        super(runner, "Result MB Pattern");
    }

    public MbSearchEditor(MbFanSearchRunner runner) {
        super(runner, "Result MB Pattern");
    }

    public MbSearchEditor(CeFanSearchRunner runner) {
        super(runner, "Result Causal Environment");
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.getAlgorithmRunner().getParams().setKnowledge(knowledge);
    }

    @Override
    public Knowledge getKnowledge() {
        return this.getAlgorithmRunner().getParams().getKnowledge();
    }

    @Override
    public List<String> getVarNames() {
        SearchParams params = this.getAlgorithmRunner().getParams();
        return params.getVarNames();
    }

    @Override
    public Graph getSourceGraph() {
        Graph sourceGraph = this.getWorkbench().getGraph();
        if (sourceGraph == null) {
            sourceGraph = this.getAlgorithmRunner().getSourceGraph();
        }
        return sourceGraph;
    }

    @Override
    public void layoutByGraph(Graph graph) {
        this.getWorkbench().layoutByGraph(graph);
    }

    @Override
    public void layoutByKnowledge() {
        GraphWorkbench resultWorkbench = this.getWorkbench();
        Graph graph = resultWorkbench.getGraph();
        Knowledge knowledge = this.getAlgorithmRunner().getParams().getKnowledge();
        SearchGraphUtils.arrangeByKnowledgeTiers(graph, knowledge);
        resultWorkbench.setGraph(graph);
    }

    @Override
    public Rectangle getVisibleRect() {
        return this.getWorkbench().getVisibleRect();
    }

    @Override
    protected JPanel getToolbar() {
        JPanel toolbar = new JPanel();
        this.getExecuteButton().setText("Execute*");
        this.getExecuteButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MbSearchEditor.this.execute();
            }
        });
        Box b1 = Box.createVerticalBox();
        b1.add(this.getParamsPanel());
        b1.add(Box.createVerticalStrut(10));
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createGlue());
        b2.add(this.getExecuteButton());
        b1.add(b2);
        b1.add(Box.createVerticalStrut(10));
        Box b3 = Box.createHorizontalBox();
        JLabel label = new JLabel("<html>*Please note that some<br>searches may take a<br>long time to complete.</html>");
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setBorder(new TitledBorder(""));
        b3.add(label);
        b1.add(b3);
        toolbar.add(b1);
        return toolbar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void addSpecialMenus(JMenuBar menuBar) {
        JMenu test = new JMenu("Independence");
        menuBar.add(test);
        DataModel dataModel = this.getAlgorithmRunner().getDataModel();
        if (dataModel == null && this.getAlgorithmRunner().getSourceGraph() != null) {
            this.addGraphTestMenuItems(test);
        } else if (dataModel instanceof DataSet) {
            DataSet _dataSet = (DataSet)dataModel;
            if (_dataSet.isContinuous()) {
                this.addContinuousTestMenuItems(test);
            } else {
                if (!_dataSet.isDiscrete()) throw new IllegalArgumentException("Don't have any tests for mixed data sets right now.");
                this.addDiscreteTestMenuItems(test);
            }
        } else if (dataModel instanceof CovarianceMatrix) {
            this.addCovMatrixTestMenuItems(test);
        }
        test.addSeparator();
        AlgorithmRunner algorithmRunner = this.getAlgorithmRunner();
        if (algorithmRunner instanceof IndTestProducer) {
            IndTestProducer p = (IndTestProducer)((Object)algorithmRunner);
            IndependenceFactsAction action = new IndependenceFactsAction(this, p, "Independence Facts...");
            test.add(action);
        }
        if (this.getAlgorithmRunner() instanceof MbfsRunner) {
            JMenu graph = new JMenu("Graph");
            JMenuItem showDags = new JMenuItem("Show DAG's Consistent with Pattern");
            JMenuItem meekOrient = new JMenuItem("Meek Orientation");
            JMenuItem gesOrient = new JMenuItem("Global Score-based Reorientation");
            JMenuItem nextGraph = new JMenuItem("Next Graph");
            JMenuItem previousGraph = new JMenuItem("Previous Graph");
            graph.add(new GraphPropertiesAction(this.getWorkbench()));
            graph.add(new DirectedPathsAction(this.getWorkbench()));
            graph.add(new TreksAction(this.getWorkbench()));
            graph.add(new AllPathsAction(this.getWorkbench()));
            graph.add(new NeighborhoodsAction(this.getWorkbench()));
            graph.addSeparator();
            graph.add(meekOrient);
            graph.add(gesOrient);
            graph.addSeparator();
            graph.add(previousGraph);
            graph.add(nextGraph);
            graph.addSeparator();
            graph.add(showDags);
            menuBar.add(graph);
            showDags.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlgorithmRunner runner = MbSearchEditor.this.getAlgorithmRunner();
                    if (!(runner instanceof MbfsRunner)) {
                        return;
                    }
                    MbfsRunner mbRunner = (MbfsRunner)runner;
                    Mbfs search = mbRunner.getMbFanSearch();
                    if (search == null) {
                        JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "The search was not stored.");
                        return;
                    }
                    MbPatternDisplay display = new MbPatternDisplay(search);
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), display, "MB DAG's Consistent with Pattern", -1);
                }
            });
            meekOrient.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImpliedOrientation rules = MbSearchEditor.this.getAlgorithmRunner().getMeekRules();
                    rules.setKnowledge(MbSearchEditor.this.getAlgorithmRunner().getParams().getKnowledge());
                    rules.orientImplied(MbSearchEditor.this.getGraph());
                    MbSearchEditor.this.getWorkbench().setGraph(MbSearchEditor.this.getGraph());
                }
            });
            gesOrient.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataModel dataModel = MbSearchEditor.this.getAlgorithmRunner().getDataModel();
                    GesOrienter rules = dataModel instanceof DataSet ? new GesOrienter((DataSet)dataModel, new Knowledge()) : new GesOrienter((CovarianceMatrix)dataModel);
                    rules.setKnowledge(MbSearchEditor.this.getAlgorithmRunner().getParams().getKnowledge());
                    rules.orient(MbSearchEditor.this.getGraph());
                    MbSearchEditor.this.getWorkbench().setGraph(MbSearchEditor.this.getGraph());
                }
            });
        }
        menuBar.add(new LayoutMenu(this));
    }

    private JPanel getParamsPanel() {
        JPanel paramsPanel = new JPanel();
        paramsPanel.setLayout(new BoxLayout(paramsPanel, 1));
        paramsPanel.add(this.getSearchParamBox());
        paramsPanel.setBorder(new TitledBorder("Parameters"));
        return paramsPanel;
    }

    private Box getSearchParamBox() {
        if (!(this.getAlgorithmRunner().getParams() instanceof MbSearchParams)) {
            throw new IllegalStateException();
        }
        Box b = Box.createHorizontalBox();
        MbSearchParams params = (MbSearchParams)this.getAlgorithmRunner().getParams();
        MbSearchParamEditor comp = new MbSearchParamEditor();
        comp.setParams(params);
        comp.setParams(params);
        comp.setup();
        b.add(comp);
        return b;
    }

    private void addGraphTestMenuItems(JMenu test) {
        IndTestType testType = this.getTestType();
        if (testType != IndTestType.D_SEPARATION) {
            this.setTestType(IndTestType.D_SEPARATION);
        }
        ButtonGroup group = new ButtonGroup();
        JCheckBoxMenuItem dsep = new JCheckBoxMenuItem("D-Separation");
        group.add(dsep);
        test.add(dsep);
        dsep.setSelected(true);
        dsep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MbSearchEditor.this.setTestType(IndTestType.D_SEPARATION);
            }
        });
    }

    private void addContinuousTestMenuItems(JMenu test) {
        IndTestType testType = this.getTestType();
        if (testType != IndTestType.FISHER_Z && testType != IndTestType.FISHER_ZD && testType != IndTestType.CORRELATION_T && testType != IndTestType.LINEAR_REGRESSION) {
            AlgorithmRunner algorithmRunner = this.getAlgorithmRunner();
            if (algorithmRunner instanceof PcdRunner) {
                this.setTestType(IndTestType.FISHER_ZD);
            } else {
                this.setTestType(IndTestType.FISHER_Z);
            }
        }
        ButtonGroup group = new ButtonGroup();
        JCheckBoxMenuItem fishersZ = new JCheckBoxMenuItem("Fisher's Z");
        group.add(fishersZ);
        test.add(fishersZ);
        JCheckBoxMenuItem fishersZD = new JCheckBoxMenuItem("Fisher's Z - Generalized Inverse");
        group.add(fishersZD);
        test.add(fishersZD);
        JCheckBoxMenuItem tTest = new JCheckBoxMenuItem("Cramer's T");
        group.add(tTest);
        test.add(tTest);
        JCheckBoxMenuItem linRegrTest = new JCheckBoxMenuItem("Linear Regression Test");
        group.add(linRegrTest);
        test.add(linRegrTest);
        if (this.getTestType() == IndTestType.FISHER_Z) {
            fishersZ.setSelected(true);
        } else if (this.getTestType() == IndTestType.FISHER_ZD) {
            fishersZD.setSelected(true);
        } else if (this.getTestType() == IndTestType.CORRELATION_T) {
            tTest.setSelected(true);
        } else if (this.getTestType() == IndTestType.LINEAR_REGRESSION) {
            linRegrTest.setSelected(true);
        }
        fishersZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MbSearchEditor.this.setTestType(IndTestType.FISHER_Z);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Fisher's Z.");
            }
        });
        fishersZD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MbSearchEditor.this.setTestType(IndTestType.FISHER_ZD);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Fisher's Z - Generalized Inverse.");
            }
        });
        tTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MbSearchEditor.this.setTestType(IndTestType.CORRELATION_T);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Cramer's T.");
            }
        });
        linRegrTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MbSearchEditor.this.setTestType(IndTestType.LINEAR_REGRESSION);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using linear regression test.");
            }
        });
    }

    private void addCovMatrixTestMenuItems(JMenu test) {
        IndTestType testType = this.getTestType();
        if (testType != IndTestType.FISHER_Z && testType != IndTestType.CORRELATION_T) {
            this.setTestType(IndTestType.FISHER_Z);
        }
        ButtonGroup group = new ButtonGroup();
        JCheckBoxMenuItem fishersZ = new JCheckBoxMenuItem("Fisher's Z");
        group.add(fishersZ);
        test.add(fishersZ);
        JCheckBoxMenuItem tTest = new JCheckBoxMenuItem("Cramer's T");
        group.add(tTest);
        test.add(tTest);
        testType = this.getTestType();
        if (testType == IndTestType.FISHER_Z) {
            fishersZ.setSelected(true);
        } else if (testType == IndTestType.CORRELATION_T) {
            tTest.setSelected(true);
        }
        fishersZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MbSearchEditor.this.setTestType(IndTestType.FISHER_Z);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Fisher's Z.");
            }
        });
        tTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MbSearchEditor.this.setTestType(IndTestType.CORRELATION_T);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Cramer's T.");
            }
        });
    }

    private void addDiscreteTestMenuItems(JMenu test) {
        IndTestType testType = this.getTestType();
        if (testType != IndTestType.CHI_SQUARE && testType != IndTestType.G_SQUARE) {
            this.setTestType(IndTestType.CHI_SQUARE);
        }
        ButtonGroup group = new ButtonGroup();
        JCheckBoxMenuItem chiSquare = new JCheckBoxMenuItem("Chi Square");
        group.add(chiSquare);
        test.add(chiSquare);
        JCheckBoxMenuItem gSquare = new JCheckBoxMenuItem("G Square");
        group.add(gSquare);
        test.add(gSquare);
        if (this.getTestType() == IndTestType.CHI_SQUARE) {
            chiSquare.setSelected(true);
        } else if (this.getTestType() == IndTestType.G_SQUARE) {
            gSquare.setSelected(true);
        }
        chiSquare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MbSearchEditor.this.setTestType(IndTestType.CHI_SQUARE);
            }
        });
        gSquare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MbSearchEditor.this.setTestType(IndTestType.G_SQUARE);
            }
        });
    }

    private void setTestType(IndTestType testType) {
        this.getAlgorithmRunner().getParams().setIndTestType(testType);
    }

    private IndTestType getTestType() {
        return this.getAlgorithmRunner().getParams().getIndTestType();
    }

    @Override
    protected void doDefaultArrangement(Graph resultGraph) {
        Graph sourceGraph = this.getAlgorithmRunner().getSourceGraph();
        boolean arrangedAll = GraphUtils.arrangeBySourceGraph(resultGraph, sourceGraph);
        if (!arrangedAll) {
            GraphUtils.arrangeInCircle(resultGraph, 200, 200, 150);
        }
    }
}

