/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.MimBuild;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeEditor;
import edu.cmu.tetradapp.model.MimBuildIndTestParams;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;

class MimBuildIndTestParamsEditor
extends JComponent {
    private MimBuildIndTestParams params;

    public MimBuildIndTestParamsEditor(MimBuildIndTestParams params) {
        this.params = params;
        final DoubleTextField alphaField = new DoubleTextField(this.getParams().getAlpha(), 7, NumberFormatUtil.getInstance().getNumberFormat());
        alphaField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    MimBuildIndTestParamsEditor.this.getParams().setAlpha(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        if (this.getParams().getAlgorithmType() == 1) {
            alphaField.setEnabled(true);
        } else {
            alphaField.setEnabled(false);
        }
        JButton editKnowledge = new JButton("Edit...");
        editKnowledge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> latentVarList = MimBuild.generateLatentNames(MimBuildIndTestParamsEditor.this.getClusters().getNumClusters());
                for (String var : MimBuildIndTestParamsEditor.this.getKnowledge().getVariables()) {
                    if (latentVarList.contains(var)) continue;
                    MimBuildIndTestParamsEditor.this.getKnowledge().removeVariable(var);
                }
                for (String var : latentVarList) {
                    MimBuildIndTestParamsEditor.this.getKnowledge().addVariable(var);
                }
                final KnowledgeEditor editor = new KnowledgeEditor(MimBuildIndTestParamsEditor.this.getKnowledge(), latentVarList, MimBuildIndTestParamsEditor.this.getSourceGraph());
                EditorWindow window = new EditorWindow(editor, "Edit Knowledge (Latents Only)", "Save", false, MimBuildIndTestParamsEditor.this);
                DesktopController.getInstance().addEditorWindow(window, JLayeredPane.PALETTE_LAYER);
                window.setVisible(true);
                window.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentHidden(ComponentEvent componentEvent) {
                        MimBuildIndTestParamsEditor.this.getParams().setKnowledge(editor.getKnowledge());
                    }
                });
            }
        });
        String[] descriptions = MimBuild.getAlgorithmDescriptions();
        JComboBox<String> algorithmSelector = new JComboBox<String>(descriptions);
        algorithmSelector.setSelectedIndex(params.getAlgorithmType());
        algorithmSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                int index = combo.getSelectedIndex();
                MimBuildIndTestParamsEditor.this.getParams().setAlgorithmType(index);
                if (MimBuildIndTestParamsEditor.this.getParams().getAlgorithmType() == 1) {
                    System.out.println("AA " + index);
                    alphaField.setEnabled(true);
                } else {
                    System.out.println("BB " + index);
                    alphaField.setEnabled(false);
                }
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Knowledge:"));
        b2.add(Box.createHorizontalStrut(10));
        b2.add(Box.createHorizontalGlue());
        b2.add(editKnowledge);
        this.add(b2);
        this.add(Box.createVerticalStrut(2));
        Box b3 = Box.createHorizontalBox();
        b3.add(new JLabel("Algorithm:"));
        b3.add(Box.createHorizontalStrut(10));
        b3.add(Box.createHorizontalGlue());
        b3.add(algorithmSelector);
        this.add(b3);
        this.add(Box.createVerticalStrut(2));
        Box b4 = Box.createHorizontalBox();
        b4.add(new JLabel("Alpha:"));
        b4.add(Box.createHorizontalStrut(10));
        b4.add(Box.createHorizontalGlue());
        b4.add(alphaField);
        this.add(b4);
    }

    private Graph getSourceGraph() {
        return this.params.getSourceGraph();
    }

    private Knowledge getKnowledge() {
        return this.params.getKnowledge();
    }

    private Clusters getClusters() {
        return this.params.getClusters();
    }

    private List getVarNames() {
        return this.params.getVarNames();
    }

    private MimBuildIndTestParams getParams() {
        return this.params;
    }
}

