/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.DataEditor;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public final class MissingDataInjectorAction
extends AbstractAction {
    private DataEditor dataEditor;
    private double prob = 0.02;

    public MissingDataInjectorAction(DataEditor editor) {
        super("Inject Missing Data Randomly");
        if (editor == null) {
            throw new NullPointerException();
        }
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataModel dataModel = this.getDataEditor().getSelectedDataModel();
        if (dataModel instanceof DataSet) {
            DataSet dataSet = (DataSet)dataModel;
            JComponent editor = this.editor();
            int selection = JOptionPane.showOptionDialog(JOptionUtils.centeringComp(), editor, "Probability", 0, 3, null, new String[]{"Done", "Cancel"}, "Done");
            if (selection != 0) {
                return;
            }
            int numVars = dataSet.getNumColumns();
            double prob = this.getProb();
            double[] probs = new double[numVars];
            for (int i = 0; i < probs.length; ++i) {
                probs[i] = prob;
            }
            DataSet newDataSet = DataUtils.addMissingData(dataSet, probs);
            DataModelList list = new DataModelList();
            list.add(newDataSet);
            this.getDataEditor().reset(list);
            this.getDataEditor().selectFirstTab();
        } else {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Must be a tabular data set.");
        }
    }

    private JComponent editor() {
        JPanel editor = new JPanel();
        editor.setLayout(new BorderLayout());
        DoubleTextField probField = new DoubleTextField(this.getProb(), 6, NumberFormatUtil.getInstance().getNumberFormat());
        probField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    MissingDataInjectorAction.this.setProb(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("<html>The input dataset will have missing data values inserted <br>independently for each variable in each case with the<br>probability specified.</html>"));
        Box b7 = Box.createHorizontalBox();
        b7.add(Box.createHorizontalGlue());
        b7.add(new JLabel("<html><i>Probability:  </i></html>"));
        b7.add(probField);
        b1.add(b2);
        b1.add(Box.createVerticalStrut(5));
        b1.add(b7);
        b1.add(Box.createHorizontalGlue());
        editor.add((Component)b1, "Center");
        return editor;
    }

    private DataEditor getDataEditor() {
        return this.dataEditor;
    }

    private double getProb() {
        return this.prob;
    }

    private void setProb(double prob) {
        if (prob < 0.0 || prob > 1.0) {
            throw new IllegalArgumentException("Probability must be between 0.0 and 1.0: " + prob);
        }
        this.prob = prob;
    }
}

